/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class TaskListPlugin
extends AbstractListPlugin
implements ItemClickListener {
    private static Log logger = LogFactory.getLog(TaskListPlugin.class);
    private static final String STATUS = "status";
    private static final String JOBNUMBER = "job.number";
    private static final String JOBNAME = "job.name";
    private static final String PLANNAME = "schedule.name";
    private static final String RUNTIME = "runtime";
    private static final String ENDTIME = "endtime";
    private static final String USETIME = "costtime";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";

    public void registerListener(EventObject e) {
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new TaskListDataProviderImpl());
    }

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd0\u884c\u65e5\u5fd7\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u6708\u3002", (String)"TaskListPlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), 3));
        }
        this.setNumber2JobId(qfilters);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData;
        String status;
        if (e.getSource() instanceof ListOperationColumnDesc && StringUtils.equals((CharSequence)(status = String.valueOf((rowData = e.getRowData()).get(STATUS))), (CharSequence)"FAILED")) {
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                operationColItem.setVisible(true);
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
    }

    private void setNumber2JobId(List<QFilter> qfilters) {
        for (QFilter qfilter : qfilters) {
            if (!"number".equals(qfilter.getProperty())) continue;
            qfilter.setProperty("job");
        }
    }

    private boolean check(List<QFilter> qfilters) {
        int intervalMonth = 3;
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        for (QFilter filter : qfilters) {
            if (!"dispatchtime".equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime start = LocalDateTime.parse(startTime, dateTimeFormatter);
                LocalDateTime end = LocalDateTime.parse(endTime, dateTimeFormatter);
                long duration = ChronoUnit.DAYS.between(start, end);
                if (duration > (long)(intervalMonth * 31)) {
                    checkResult = false;
                    continue;
                }
                checkResult = true;
            }
            catch (Exception px) {
                logger.error("Schedule***check error!", (Throwable)px);
                return checkResult;
            }
        }
        return checkResult;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate errorLog = (AbstractOperate)args.getSource();
            String operateKey = errorLog.getOperateKey();
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"errorlog") && !CollectionUtils.isEmpty((Collection)args.getListSelectedData())) {
                ILocaleString planName;
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                String taskId = listSelectedData.get(0).getPrimaryKeyValue().toString();
                DynamicObject taskLog = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sch_task");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("sch_errorjob_details");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("taskId", (Object)taskId);
                showParameter.setCustomParam("jobnumber", taskLog.get(JOBNUMBER));
                ILocaleString jobName = (ILocaleString)taskLog.get(JOBNAME);
                if (jobName != null) {
                    showParameter.setCustomParam("jobname", (Object)jobName.getLocaleValue());
                }
                if ((planName = (ILocaleString)taskLog.get(PLANNAME)) != null) {
                    showParameter.setCustomParam("planname", (Object)planName.getLocaleValue());
                }
                this.getView().showForm(showParameter);
            } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"tasktrace")) {
                BillList billlist = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"TaskListPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8ffd\u8e2a\u4e0d\u652f\u6301\u591a\u884c\u6570\u636e\u3002", (String)"TaskListPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                FormShowParameter taskTraceFsp = new FormShowParameter();
                ListSelectedRow selectedRow = selectedRows.get(0);
                String taskId = selectedRow.getPrimaryKeyValue().toString();
                TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
                if (taskInfo.getJobType() == JobType.REALTIME || taskInfo.getJobType() == JobType.WORKFLOW) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u65f6\u4efb\u52a1\u548c\u5de5\u4f5c\u6d41\u4e0d\u652f\u6301\u4efb\u52a1\u8ffd\u8e2a\u3002", (String)"TaskListPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                taskTraceFsp.setCustomParam("taskId", (Object)taskId);
                taskTraceFsp.setFormId("sch_tasktrace_query");
                String pageId = this.getPageCache().get(taskId);
                if (StringUtils.isNotBlank((CharSequence)pageId)) {
                    taskTraceFsp.setPageId(pageId);
                }
                taskTraceFsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(taskTraceFsp);
                this.getPageCache().put(taskId, taskTraceFsp.getPageId());
            }
        }
    }

    class TaskListDataProviderImpl
    extends ListDataProvider {
        TaskListDataProviderImpl() {
        }

        public int getMaxReturnData() {
            return Math.min(super.getMaxReturnData(), 10000);
        }
    }
}

