/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.StopTask;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.next.ClientObservableUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class TaskLogPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final Log log = LogFactory.getLog(TaskLogPlugin.class);
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";

    public void registerListener(EventObject e) {
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String id = "";
        if (dataEntity != null) {
            id = (String)dataEntity.getPkValue();
        }
        if (QueryServiceHelper.exists((String)"sch_errorjob", (Object)id)) {
            DynamicObject errorLogData = BusinessDataServiceHelper.loadSingle((Object)id, (String)"sch_errorjob");
            this.getModel().setValue("errorlog", errorLogData.get("ferrorreason"));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
        }
        String appid = (String)this.getModel().getValue("appid");
        if (ZkConfig.isMqAppSplit() && "SCHEDULED".equals(this.getModel().getValue("status"))) {
            List executorServerInfos;
            String statusdesc = "SCH_IN_LINE";
            JobInfo jobInfo = new JobInfo();
            jobInfo.setAppId(appid);
            Object jobTypeObj = this.getModel().getValue("jobtype");
            if (jobTypeObj != null) {
                String jobTypeStr = (String)jobTypeObj;
                jobInfo.setJobType(JobType.getJobType((String)jobTypeStr));
            }
            if ((executorServerInfos = ClientObservableUtils.queryExecutorServerStatus((JobInfo)jobInfo, (boolean)true)).isEmpty()) {
                statusdesc = "SCH_APP_NOTDEPLOY";
            }
            this.getModel().setValue("statusdesc", (Object)statusdesc);
        }
        if ("bos".equalsIgnoreCase(appid)) {
            appid = "sys";
        }
        if (!StringUtils.isEmpty((CharSequence)appid)) {
            String name;
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appid);
                name = appInfo.getName().getLocaleValue();
            }
            catch (Exception exp) {
                log.warn((Throwable)exp);
                name = appid;
            }
            this.getModel().setValue("appname", (Object)name);
        }
        this.getModel().setValue("taskid", (Object)id);
        String status = (String)this.getModel().getValue("status");
        if (!StringUtils.equals((CharSequence)status, (CharSequence)"BEGIN")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"stoptask"});
        }
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"tasktrace")) {
                Object jobTypeObj = this.getModel().getValue("jobtype");
                if (jobTypeObj != null) {
                    String jobType = (String)jobTypeObj;
                    if (StringUtils.equals((CharSequence)jobType, (CharSequence)JobType.REALTIME.name()) || StringUtils.equals((CharSequence)jobType, (CharSequence)JobType.WORKFLOW.name())) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u65f6\u4efb\u52a1\u548c\u5de5\u4f5c\u6d41\u4e0d\u652f\u6301\u4efb\u52a1\u8ffd\u8e2a\u3002", (String)"TaskLogPlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301\u4efb\u52a1\u8ffd\u8e2a\u3002", (String)"TaskLogPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                DynamicObject job = (DynamicObject)this.getModel().getValue("job");
                if (job != null) {
                    boolean isSupportTaskTrace = (Boolean)job.get("tasktrace");
                    if (!isSupportTaskTrace) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u672a\u5f00\u542f\u4efb\u52a1\u8ffd\u8e2a\u5c5e\u6027\u3002", (String)"TaskLogPlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301\u4efb\u52a1\u8ffd\u8e2a\u3002", (String)"TaskLogPlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                FormShowParameter taskTraceFsp = new FormShowParameter();
                String taskId = (String)this.getModel().getValue("taskid");
                taskTraceFsp.setCustomParam("taskId", (Object)taskId);
                taskTraceFsp.setFormId("sch_tasktrace_query");
                String pageId = this.getPageCache().get(taskId);
                if (StringUtils.isNotBlank((CharSequence)pageId)) {
                    taskTraceFsp.setPageId(pageId);
                }
                taskTraceFsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(taskTraceFsp);
                this.getPageCache().put(taskId, taskTraceFsp.getPageId());
            } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"stoptask")) {
                if (!this.isSupportStopTask()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u6267\u884c\u7a0b\u5e8f\u4e2d\u5b9e\u73b0kd.bos.schedule.api.StopTask\u63a5\u53e3\uff0c\u5b9e\u73b0\u540e\u624d\u652f\u6301\u7ec8\u6b62\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"TaskLogPlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    args.cancel = true;
                    return;
                }
                String taskId = (String)this.getModel().getValue("taskid");
                String taskStatusFromDB = this.getTaskStatusFromDB(taskId);
                if ("BEGIN".equals(taskStatusFromDB)) {
                    ScheduleServiceHelper.stopTask((String)taskId);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u901a\u77e5\u7a0b\u5e8f\u4e2d\u6b62\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u540e\uff0c\u5237\u65b0\u9875\u9762\u3002", (String)"TaskLogPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    this.getView().setEnable(Boolean.FALSE, new String[]{"stoptask"});
                } else {
                    String taskStatusDesc = this.getTaskStatusDesc(taskStatusFromDB);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u7ec8\u6b62\u201c\u8fd0\u884c\u4e2d\u201d\u7684\u4efb\u52a1\uff0c\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e3a\u201c%s\u201d\u3002", (String)"TaskLogPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), taskStatusDesc));
                    args.cancel = true;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)"taskanalyse")) {
            Object taskId = this.getModel().getValue("taskid");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("sch_taskanalyse");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("taskId", taskId);
            this.getView().showForm(fsp);
        }
    }

    private String getTaskStatusDesc(String taskStatus) {
        if (StringUtils.isBlank((CharSequence)taskStatus)) {
            return "";
        }
        return TaskStatusConstant.getStatusName((String)taskStatus);
    }

    private boolean isSupportStopTask() {
        String taskClassName = this.getTaskClassName();
        if (StringUtils.isNotBlank((CharSequence)taskClassName)) {
            try {
                Class<?> aClass = Class.forName(taskClassName);
                Object instance = aClass.newInstance();
                return instance instanceof StopTask;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error("Schedule***confirm task is supportStopTask error", (Throwable)e);
            }
        }
        return false;
    }

    private String getTaskClassName() {
        String taskClassName = "";
        DynamicObject jobDoj = (DynamicObject)this.getModel().getValue("job");
        if (jobDoj != null) {
            DynamicObject taskClassDoj = jobDoj.getDynamicObject("taskclassname");
            taskClassName = taskClassDoj != null ? taskClassDoj.getString("classname") : (String)jobDoj.get("classname");
        }
        return taskClassName;
    }

    private String getTaskStatusFromDB(String taskId) {
        String sql = String.format("SELECT FSTATUS FROM T_SCH_TASK WHERE FID = '%s'", taskId);
        return (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, rs -> {
            if (rs.next()) {
                return rs.getString("FSTATUS");
            }
            return "";
        });
    }
}

