/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.opplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;

public class SchAppConfigEventPlugin
implements IEventServicePlugin {
    private static Log log = LogFactory.getLog(SchAppConfigEventPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        String source = evt.getSource();
        log.info("schedule***\u5e94\u7528\u542f\u505c\u76d1\u542c\u5904\u7406 eventnumber:{},event\uff1a{}", (Object)evt.getEventNumber(), (Object)source);
        if (StringUtils.isEmpty((String)source)) {
            return null;
        }
        JSONArray jsonArray = JSON.parseArray((String)source);
        if (jsonArray.isEmpty()) {
            return null;
        }
        if ("bos_smc_appconfig.appdisable".equals(evt.getEventNumber())) {
            this.handleApp(false, jsonArray);
        } else if ("bos_smc_appconfig.appenable".equals(evt.getEventNumber())) {
            this.handleApp(true, jsonArray);
        } else if ("bos_smc_appconfig.clouddisable".equals(evt.getEventNumber())) {
            this.handleCloud(false, jsonArray);
        } else if ("bos_smc_appconfig.cloudenable".equals(evt.getEventNumber())) {
            this.handleCloud(true, jsonArray);
        }
        return null;
    }

    private void handleCloud(boolean enable, JSONArray jsonArray) {
        ArrayList<String> cloudIds = new ArrayList<String>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            String cloudId;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONObject bizcloud = jsonObject.getJSONObject("bizcloud");
            if (bizcloud == null || StringUtils.isEmpty((String)(cloudId = bizcloud.getString("id")))) continue;
            cloudIds.add(cloudId);
        }
        ArrayList<String> appNum = new ArrayList<String>(8);
        DynamicObjectCollection coll = BizAppServiceHelp.getAllBizAppsByCloudID(cloudIds);
        for (DynamicObject dObj : coll) {
            String number = dObj.getString("number");
            if (!StringUtils.isNotEmpty((String)number)) continue;
            appNum.add(number);
        }
        this.afterUpdateJob(enable, appNum);
    }

    private void handleApp(boolean enable, JSONArray jsonArray) {
        ArrayList<String> appNum = new ArrayList<String>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            String number;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONObject bizapp = jsonObject.getJSONObject("bizapp");
            if (bizapp == null || StringUtils.isEmpty((String)(number = bizapp.getString("number")))) continue;
            appNum.add(number);
        }
        this.afterUpdateJob(enable, appNum);
    }

    private void afterUpdateJob(boolean enable, List<String> appNum) {
        QFilter[] filters = new QFilter[]{new QFilter("taskclassname.appid", "in", appNum), new QFilter("status", "=", (Object)"1"), new QFilter("jobtype", "=", (Object)JobType.BIZ)};
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"sch_job", (String)"id", (QFilter[])filters);
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        HashSet<String> jobIds = new HashSet<String>(coll.size());
        for (DynamicObject dObj : coll) {
            String jobId = dObj.getString("id");
            jobIds.add(jobId);
        }
        log.info("Schedule***afterUpdateJob. enableflag is {}, appNum is {} , jobIds is {} ", new Object[]{enable, appNum, jobIds});
        int batchSize = 500;
        ArrayList<String> subJobIds = new ArrayList<String>(batchSize);
        for (String jobId : jobIds) {
            subJobIds.add(jobId);
            if (subJobIds.size() != batchSize) continue;
            scheduleManager.batchUpdateJob(subJobIds);
            subJobIds.clear();
        }
        if (!subJobIds.isEmpty()) {
            scheduleManager.batchUpdateJob(subJobIds);
        }
        log.info("Schedule***\u5e94\u7528\u542f\u505c. enableflag is {}, appNum is {} , jobIds is {} ", new Object[]{enable, appNum, jobIds});
    }
}

