/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.service.ServiceFactory;

public class ScheduleOpPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(ScheduleOpPlugin.class);
    private List<String> jobIds = new ArrayList<String>(5);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String opKey = e.getOperationKey();
        DynamicObject objInfo = e.getDataEntities()[0];
        String id = (String)objInfo.getPkValue();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        if ("save".equals(opKey)) {
            scheduleManager.afterUpdateSchedule(id, this.jobIds);
        } else if ("delete".equals(opKey)) {
            scheduleManager.afterDeleteSchedule(id);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String opKey = e.getOperationKey();
        DynamicObject objInfo = e.getDataEntities()[0];
        String id = (String)objInfo.getPkValue();
        if ("save".equals(opKey)) {
            ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
            this.jobIds = scheduleDao.getJobIdByScheduleId(id);
            log.info("\u67e5t_sch_schedule_entry\u83b7\u5f97\u5220\u9664\u524d\u7684jobid\uff1a" + StringUtils.join((Object[])this.jobIds.toArray(), (String)","));
        }
    }
}

