/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SchTableJobIdNullUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SchTableJobIdNullUpgradeServiceImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        StringBuilder log = new StringBuilder();
        try {
            this.repairSchTableJobIdNullData(dbKey, log);
        }
        catch (Exception e) {
            logger.error("Schedule***handler jobId null data error", (Throwable)e);
            throw e;
        }
        result.setLog(log.toString());
        return result;
    }

    private void repairSchTableJobIdNullData(String dbKey, StringBuilder log) {
        log.append("Repair null data begin.").append("\n");
        Map<String, String> scheduleBindJobIdMap = this.getScheduleBindJobIdMap(dbKey, log);
        this.fillJobId(dbKey, scheduleBindJobIdMap);
        log.append("Repair null data success!");
    }

    private void fillJobId(String dbKey, Map<String, String> scheduleBindJobIdMap) {
        if (scheduleBindJobIdMap.isEmpty()) {
            return;
        }
        String fillSql = "UPDATE T_SCH_SCHEDULE SET FJOBID = ? WHERE FID = ?";
        ArrayList<Object[]> batchParameters = new ArrayList<Object[]>(scheduleBindJobIdMap.size());
        for (Map.Entry<String, String> entry : scheduleBindJobIdMap.entrySet()) {
            Object[] params = new Object[]{new SqlParameter(":FJOBID", 12, (Object)entry.getValue()), new SqlParameter(":FID", 12, (Object)entry.getKey())};
            batchParameters.add(params);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)fillSql, batchParameters);
    }

    private Map<String, String> getScheduleBindJobIdMap(String dbKey, StringBuilder log) {
        log.append("begin to getScheduleBindJobIdMap:").append("\n");
        String querySql = "SELECT FID,FJOBNUMBER FROM T_SCH_SCHEDULE_ENTRY WHERE FID IN (SELECT FID FROM T_SCH_SCHEDULE WHERE FJOBID IS NULL OR FJOBID = NULL OR FJOBID = '' OR FJOBID = ' ') ORDER BY FID,FSEQ ASC";
        Map scheduleBindJobIdMap = (Map)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)querySql, rs -> {
            HashMap<String, String> tempMap = new HashMap<String, String>(16);
            while (rs.next()) {
                String scheduleId = rs.getString("FID");
                String jobId = rs.getString("FJOBNUMBER");
                if (tempMap.containsKey(scheduleId)) continue;
                tempMap.put(scheduleId, jobId);
            }
            return tempMap;
        });
        for (Map.Entry entry : scheduleBindJobIdMap.entrySet()) {
            log.append((String)entry.getKey()).append("=>").append((String)entry.getValue()).append(",");
        }
        log.append("\n");
        return scheduleBindJobIdMap;
    }
}

