/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class SchTableMulIndexUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SchTableMulIndexUpgradeServiceImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        StringBuilder log = new StringBuilder();
        try {
            this.repairTableMulIndex(dbKey, log, "T_SCH_TASKDEFINE_L", "IDX_SCH_TDEF_L_ID");
            this.repairTableMulIndex(dbKey, log, "T_SCH_JOB_L", "IDX_SCH_JOB_L_ID");
            this.repairTableMulIndex(dbKey, log, "T_SCH_SCHEDULE_L", "IDX_SCH_SCD_L_ID");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            log.append(e.getMessage());
        }
        result.setLog(log.toString());
        return result;
    }

    private void repairTableMulIndex(String dbKey, StringBuilder log, String tablename, String idxName) {
        try {
            log.append(String.format("Repair %s idx %s begin , ", tablename, idxName));
            this.createIndex(dbKey, log, tablename, idxName);
        }
        catch (Exception e) {
            try {
                this.tryRepair(dbKey, log, tablename);
                this.createIndex(dbKey, log, tablename, idxName);
            }
            catch (Exception ee) {
                String str = String.format("Repair %s idx %s warn. this messaage can ignore.", tablename, idxName);
                logger.error(str, (Throwable)e);
                log.append(str).append("\n").append(e.getMessage());
            }
        }
        log.append("\n");
    }

    private void tryRepair(String dbKey, StringBuilder log, String tablename) {
        log.append(String.format("Repair %s begin , ", tablename));
        String sql = String.format("select fid,flocaleid from %s group by fid, flocaleid having count(*) > 1", tablename);
        List list = (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, resultSet -> {
            ArrayList<Tuple> list1 = new ArrayList<Tuple>(8);
            while (resultSet.next()) {
                Tuple tuple = new Tuple((Object)resultSet.getString("fid"), (Object)resultSet.getString("flocaleid"));
                list1.add(tuple);
            }
            return list1;
        });
        LocaleString localeString = ResManager.getLocaleString((String)"\u81ea\u52a8\u751f\u6210", (String)"DbJobDao_0", (String)"bos-schedule-message");
        ArrayList deletePkIdss = new ArrayList(list.size());
        for (Tuple tuple : list) {
            sql = String.format("select fpkid,fname from %s where fid = ? and flocaleid = ?", tablename);
            Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, tuple.item1), new SqlParameter(":flocaleid", 12, tuple.item2)};
            List deletePkIds = (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])params, resultSet -> {
                ArrayList<Data> pks = new ArrayList<Data>(6);
                Data validPk = null;
                while (resultSet.next()) {
                    String fname = resultSet.getString("fname");
                    String fpkid = resultSet.getString("fpkid");
                    Data data = new Data();
                    data.setFname(fname);
                    data.setFpkid(fpkid);
                    data.setFlocaleid((String)tuple.item2);
                    data.setFid((String)tuple.item1);
                    pks.add(data);
                    if (validPk != null || !StringUtils.isNotEmpty((String)fname) || localeString == null) continue;
                    for (String value : localeString.values()) {
                        if (value == null || value.equals(fname)) continue;
                        validPk = data;
                    }
                }
                if (validPk == null && !pks.isEmpty()) {
                    validPk = (Data)pks.get(0);
                }
                pks.remove(validPk);
                return pks;
            });
            deletePkIdss.addAll(deletePkIds);
        }
        try (TXHandle txHandle = TX.required();){
            if (!deletePkIdss.isEmpty()) {
                ArrayList<SqlParameter[]> paramss = new ArrayList<SqlParameter[]>(deletePkIdss.size());
                for (Data data : deletePkIdss) {
                    SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FPKID", 12, (Object)data.getFpkid()), new SqlParameter(":FID", 12, (Object)data.getFid()), new SqlParameter(":FLOCALEID", 12, (Object)data.getFlocaleid()), new SqlParameter(":FNAME", 12, (Object)data.getFname())};
                    paramss.add(params);
                }
                String insertSql = String.format("INSERT INTO %s (FPKID,FID,FLOCALEID,FNAME) VALUES (?,?,?,? )", this.getRepairTableName(tablename));
                DB.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)insertSql, paramss);
                String deleteSql = String.format("delete from %s where fpkid = ? ", tablename);
                ArrayList<SqlParameter[]> dparamss = new ArrayList<SqlParameter[]>(deletePkIdss.size());
                for (Data data : deletePkIdss) {
                    SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FPKID", 12, (Object)data.getFpkid())};
                    dparamss.add(params);
                }
                DB.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)deleteSql, dparamss);
            }
        }
    }

    private void createIndex(String dbKey, StringBuilder log, String tablename, String idxName) {
        String sql = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s' and KSQL_TABNAME = '%s') CREATE UNIQUE INDEX %s ON %s ( FID ,FLOCALEID )", idxName, tablename, idxName, tablename);
        log.append(String.format("Repair %s idx %s complete.", tablename, idxName));
        DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql);
    }

    private String getRepairTableName(String tableName) {
        tableName = tableName + "_23928_REBAK";
        return tableName;
    }

    static class Data {
        private String fpkid;
        private String fid;
        private String flocaleid;
        private String fname;

        Data() {
        }

        public String getFpkid() {
            return this.fpkid;
        }

        public void setFpkid(String fpkid) {
            this.fpkid = fpkid;
        }

        public String getFid() {
            return this.fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getFlocaleid() {
            return this.flocaleid;
        }

        public void setFlocaleid(String flocaleid) {
            this.flocaleid = flocaleid;
        }

        public String getFname() {
            return this.fname;
        }

        public void setFname(String fname) {
            this.fname = fname;
        }
    }
}

