/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.api;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.PluginType;
import kd.bos.schedule.api.TaskHandler;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractJobHandler
implements MessageHandler {
    protected Map<PluginType, TaskHandler> taskHandlers;
    protected ObjectFactory objectFactory = null;
    private JobInfo jobInfo = null;

    public void setJobInfo(JobInfo jobInfo) {
        this.jobInfo = jobInfo;
    }

    @Override
    public void handle(MessageInfo message) {
        JobInfo curjobInfo = message.fetchJobInfo();
        this.execute(RequestContext.get(), message, curjobInfo);
    }

    @Deprecated
    public RequestContext createRequestContext(MessageInfo message, JobInfo job) {
        RequestContext rc = RequestContext.create((boolean)true);
        rc.setClient("batch");
        rc.setRequestId(UUID.randomUUID().toString());
        rc.setTenantId(message.getTenantId());
        rc.setAccountId(message.getAccountId());
        rc.setUserId(String.valueOf(job.getRunByUserId()));
        return rc;
    }

    public JobInfo convertMessage(MessageInfo message) {
        if (this.jobInfo == null) {
            this.jobInfo = message.fetchJobInfo();
        }
        return this.jobInfo;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public ObjectFactory getObjFactory() {
        return this.objectFactory;
    }

    @Override
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void execute(RequestContext rc, MessageInfo message, JobInfo job) {
        TaskHandler taskHandler;
        if (this.taskHandlers == null || this.taskHandlers.isEmpty()) {
            this.taskHandlers = this.initTaskHandler();
        }
        if ((taskHandler = this.taskHandlers.get((Object)job.getPluginType())) == null) {
            throw new KDBizException(new ErrorCode("TASK_HANDLER_NULL", String.format(ResManager.loadKDString((String)"\u63d2\u4ef6\u7c7b\u578b\uff1a%s \u5bf9\u5e94\u7684\u4efb\u52a1\u5904\u7406\u5668\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractJobHandler_0", (String)"mservice-schedule-api", (Object[])new Object[0]), new Object[]{job.getPluginType()})), new Object[0]);
        }
        taskHandler.execute(rc, message, job, this);
    }

    protected Map<PluginType, TaskHandler> initTaskHandler() {
        HashMap<PluginType, TaskHandler> taskCreators = new HashMap<PluginType, TaskHandler>(8);
        taskCreators.put(PluginType.JAVA, (TaskHandler)TypesContainer.createInstance((String)"kd.bos.schedule.executor.JavaTaskHandler"));
        taskCreators.put(PluginType.KING_SCRIPT, (TaskHandler)TypesContainer.createInstance((String)"kd.bos.schedule.executor.KSTaskHandler"));
        return taskCreators;
    }
}

