/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobNotifyEvent;
import kd.bos.schedule.api.JobNotifyListener;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleMsgInfo;
import kd.bos.schedule.api.TaskResult;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MessageInfo {
    private static final String TASK_RESULT = "taskResult";
    private static final String RUN_BY_ORG_ID = "runByOrgId";
    private static final String RUN_BY_USER_ID = "runByUserId";
    private static final String TIMEOUT_DATA = "timeout";
    private String id;
    private String title;
    private String target;
    private Map<String, Object> body = new HashMap<String, Object>();
    private String taskId;
    private MessageType messageType;
    private String tenantId = null;
    private String flag = null;
    private String messageMQId = null;
    private String instanceId = null;
    private String traceId = null;
    private int timeout;
    private JobNotifyListener notifyListener;
    private NotifyScene notifyScene;
    private RequestContext requestContext;
    private Thread thread;
    private String accountId = null;

    public void setNotifyListener(JobNotifyListener notifyListener) {
        this.notifyListener = notifyListener;
    }

    public void send(MessageInfo messageInfo) {
        if (this.notifyListener != null) {
            JobNotifyEvent notifyEvent = new JobNotifyEvent();
            notifyEvent.setMessageInfo(messageInfo);
            this.notifyListener.sendMessage(notifyEvent);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getMessageMQId() {
        return this.messageMQId;
    }

    public void setMessageMQId(String messageMQId) {
        this.messageMQId = messageMQId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public void setBody(Map<String, Object> body) {
        this.body = body;
    }

    public void setTaskResult(TaskResult taskResult) {
        this.body.put(TASK_RESULT, taskResult);
    }

    public TaskResult fectchTaskResult() {
        if (this.body.get(TASK_RESULT) != null) {
            Object result = this.body.get(TASK_RESULT);
            TaskResult taskResult = null;
            if (result instanceof Map) {
                taskResult = new TaskResult();
                Map jsonObj = (Map)result;
                taskResult.setResultType(TaskResult.ResultTypeEnum.valueOf((String)jsonObj.get("resultType")));
                taskResult.setStatus((String)jsonObj.get("status"));
                taskResult.setStatusDesc((String)jsonObj.get("statusDesc"));
                taskResult.setProgress((Integer)jsonObj.get("progress"));
                taskResult.setCustomData((Map)jsonObj.get("customData"));
                this.setTaskResult(taskResult);
            } else {
                taskResult = (TaskResult)result;
            }
            return taskResult;
        }
        return null;
    }

    public JobInfo fetchJobInfo() {
        if (this.body.containsKey("job")) {
            Object jobObj = this.body.get("job");
            JobInfo jobInfo = null;
            if (jobObj instanceof Map) {
                jobInfo = new JobInfo();
                Map jsonObj = (Map)jobObj;
                jobInfo.setId((String)jsonObj.get("id"));
                jobInfo.setJobType(JobType.valueOf((String)jsonObj.get("jobType")));
                if (jsonObj.get("name") instanceof String) {
                    jobInfo.setName((String)jsonObj.get("name"));
                } else if (jsonObj.get("lName") instanceof Map && !((Map)jsonObj.get("lName")).isEmpty()) {
                    LocaleString lName = new LocaleString();
                    for (Map.Entry entry : ((Map)jsonObj.get("lName")).entrySet()) {
                        lName.setItem(String.valueOf(entry.getKey()), (Object)String.valueOf(entry.getValue()));
                    }
                    jobInfo.setlName(lName);
                }
                if (jsonObj.get(RUN_BY_ORG_ID) instanceof Long) {
                    jobInfo.setRunByOrgId((Long)jsonObj.get(RUN_BY_ORG_ID));
                } else {
                    jobInfo.setRunByOrgId(((Integer)jsonObj.get(RUN_BY_ORG_ID)).longValue());
                }
                jobInfo.setRunByLang(Lang.valueOf((String)((String)jsonObj.get("runByLang"))));
                if (jsonObj.get("taskId") != null) {
                    jobInfo.setTaskId((String)jsonObj.get("taskId"));
                }
                if (jsonObj.get(RUN_BY_USER_ID) instanceof Long) {
                    jobInfo.setRunByUserId((Long)jsonObj.get(RUN_BY_USER_ID));
                } else {
                    jobInfo.setRunByUserId(((Integer)jsonObj.get(RUN_BY_USER_ID)).intValue());
                }
                jobInfo.setTaskClassname((String)jsonObj.get("taskClassname"));
                jobInfo.setParams((Map)jsonObj.get("params"));
                jobInfo.setAppId((String)jsonObj.get("appId"));
                jobInfo.setRetryTime((Integer)jsonObj.get("retryTime"));
                if (jsonObj.get(TIMEOUT_DATA) instanceof Long) {
                    jobInfo.setTimeout(((Long)jsonObj.get(TIMEOUT_DATA)).intValue());
                } else if (jsonObj.get(TIMEOUT_DATA) != null) {
                    jobInfo.setTimeout((Integer)jsonObj.get(TIMEOUT_DATA));
                }
                if (jsonObj.get("runConcurrently") instanceof Boolean) {
                    jobInfo.setRunConcurrently(Boolean.parseBoolean(jsonObj.get("runConcurrently").toString()));
                } else {
                    jobInfo.setRunConcurrently(true);
                }
                if (jsonObj.get("failNotify") instanceof Boolean) {
                    jobInfo.setFailNotify(Boolean.parseBoolean(jsonObj.get("failNotify").toString()));
                } else {
                    jobInfo.setFailNotify(false);
                }
                if (jsonObj.get("successNotify") instanceof Boolean) {
                    jobInfo.setSuccessNotify(Boolean.parseBoolean(jsonObj.get("successNotify").toString()));
                } else {
                    jobInfo.setSuccessNotify(false);
                }
                if (jsonObj.get("overTime") instanceof Boolean) {
                    jobInfo.setSuccessNotify(Boolean.parseBoolean(jsonObj.get("overTime").toString()));
                } else {
                    jobInfo.setSuccessNotify(false);
                }
                if (jsonObj.get("aborted") instanceof Boolean) {
                    jobInfo.setAborted(Boolean.parseBoolean(jsonObj.get("aborted").toString()));
                } else {
                    jobInfo.setAborted(false);
                }
                if (jsonObj.get("taskTrace") instanceof Boolean) {
                    jobInfo.setTaskTrace(Boolean.parseBoolean(jsonObj.get("taskTrace").toString()));
                } else {
                    jobInfo.setTaskTrace(false);
                }
                jobInfo.setNotifyType((String)jsonObj.get("notifyType"));
                Object jobPrincipalStr = jsonObj.get("jobPrincipal");
                if (jobPrincipalStr == null || StringUtils.isBlank((String)jobPrincipalStr.toString())) {
                    jobInfo.setJobPrincipal(0L);
                } else {
                    jobInfo.setJobPrincipal(Long.parseLong(jobPrincipalStr.toString()));
                }
                Object jobMsgReceiverStr = jsonObj.get("jobMsgReceiver");
                if (jobMsgReceiverStr == null || StringUtils.isBlank((String)jobMsgReceiverStr.toString())) {
                    jobInfo.setJobMsgReceiver(0L);
                } else {
                    jobInfo.setJobMsgReceiver(Long.parseLong(jobMsgReceiverStr.toString()));
                }
                jobInfo.setCaption((String)jsonObj.get("caption"));
                jobInfo.setMsgContent((String)jsonObj.get("msgContent"));
                jobInfo.setStrategy((String)jsonObj.get("strategy"));
                if (StringUtils.isEmpty((String)((String)jsonObj.get("routeMode")))) {
                    jobInfo.setRouteMode(RouteMode.RAMDOM);
                } else {
                    jobInfo.setRouteMode(RouteMode.valueOf((String)jsonObj.get("routeMode")));
                }
                jobInfo.setScheduleId((String)jsonObj.get("scheduleId"));
                jobInfo.setExecuteTime(jsonObj.get("executeTime") == null ? 0 : (Integer)jsonObj.get("executeTime"));
                jobInfo.setRetryRecord(jsonObj.get("retryRecord") == null ? 0 : (Integer)jsonObj.get("retryRecord"));
                if (jsonObj.get("groupId") == null) {
                    jobInfo.setGroupId(0L);
                } else {
                    jobInfo.setGroupId(Long.parseLong(jsonObj.get("groupId").toString()));
                }
                Object scheduleMsgInfo = jsonObj.get("scheduleMsgInfo");
                if (scheduleMsgInfo instanceof Map) {
                    ScheduleMsgInfo msgInfo = new ScheduleMsgInfo();
                    Map smi = (Map)scheduleMsgInfo;
                    msgInfo.setFailNotify(smi.getOrDefault("failNotify", false));
                    msgInfo.setSuccessNotify(smi.getOrDefault("successNotify", false));
                    msgInfo.setSchPrincipal(Long.parseLong(String.valueOf(smi.getOrDefault("schPrincipal", 0))));
                    msgInfo.setMsgreceiver(Long.parseLong(String.valueOf(smi.getOrDefault("msgreceiver", 0))));
                    msgInfo.setNotifyType(smi.getOrDefault("notifyType", ""));
                    msgInfo.setMsgContent(smi.getOrDefault("msgContent", ""));
                    msgInfo.setTimeOut(smi.getOrDefault("timeOut", false));
                    msgInfo.setAborted(smi.getOrDefault("aborted", false));
                    jobInfo.setScheduleMsgInfo(msgInfo);
                }
                jobInfo.setFromScheduler(Boolean.parseBoolean(String.valueOf(jsonObj.get("fromScheduler"))));
                jobInfo.setShareIndex(jsonObj.getOrDefault("shareIndex", 0));
                jobInfo.setScheduleTime((Long)((Object)jsonObj.getOrDefault("scheduleTime", 0)));
                this.body.put("job", jobInfo);
            } else {
                jobInfo = (JobInfo)this.body.get("job");
            }
            return jobInfo;
        }
        return null;
    }

    public void setJobInfo(JobInfo jobInfo) {
        this.body.put("job", jobInfo);
    }

    public Object getJobInfo() {
        return this.body.get("job");
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public String toString() {
        JobInfo jobInfo = this.fetchJobInfo();
        return String.format("id=%s,taskid=%s,tenantId=%s,accountId=%s, messageType=%s,flag=%s, jobInfo:%s", new Object[]{this.id, this.taskId, this.tenantId, this.accountId, this.messageType, this.flag, jobInfo});
    }

    public NotifyScene getNotifyScene() {
        return this.notifyScene;
    }

    public void setNotifyScene(NotifyScene notifyScene) {
        this.notifyScene = notifyScene;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @JsonIgnore
    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public static enum NotifyScene {
        JOBFAIL,
        JOBSUCCESS,
        SCHEDULEFAIL,
        SCHEDULESUCCESS,
        JOBTIMEOUT,
        SCHTIMEOUT;

    }
}

