/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.developer.openapi;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import kd.bos.cloudcommunity.api.CommunityUser;
import kd.bos.context.RequestContextCreator;
import kd.bos.developer.pojo.CommunitySessionUser;
import kd.bos.developer.pojo.IDEAPluginVersion;
import kd.bos.developer.service.CommunityuserService;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.gptas.qa.model.LLMAPIMsg;
import kd.bos.gptas.qa.model.LLMData;
import kd.bos.gptas.qa.webapi.QAService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiHeader;
import kd.bos.openapi.common.custom.annotation.ApiHeaders;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

@ApiController(value="CloudDeveloperService", desc="\u4e91\u793e\u533a\u5f00\u53d1\u8005\u670d\u52a1")
public class CloudDeveloperService {
    private static final String BOS_KINGSCRIPT_CONSOLE = "bos-kingscript-console";
    Log logger = LogFactory.getLog(CloudDeveloperService.class);
    private static final String SESSIONKEY_DEVELOPER_UID = "developer_uid";
    private static final String APPCACHE_KEY_CLOUD_DEVELOPER = "cloudDeveloper";
    private static final String ENTITY = "bos_comm_ide_version";
    private static final int POLLING_INTERVAL = 1000;
    private static final int MAX_ATTEMPTS = 10;

    @ApiPostMapping(value="cloudcommunity/developer/pollingLogin")
    @ApiErrorCodes(value={@ApiErrorCode(code="100", desc="\u53c2\u6570\u5f02\u5e38"), @ApiErrorCode(code="200", desc="\u6743\u9650\u5f02\u5e38"), @ApiErrorCode(code="300", desc="\u7528\u6237\u5f02\u5e38"), @ApiErrorCode(code="400", desc="\u989d\u5ea6\u5f02\u5e38")})
    public CustomApiResult<CommunitySessionUser> pollingLogin(@ApiParam(value="\u5f00\u53d1\u8005\u8eab\u4efd\u7f16\u7801", required=true) @ApiParam(value="\u5f00\u53d1\u8005\u8eab\u4efd\u7f16\u7801", required=true) String developerCode) {
        this.logger.info("\u5f00\u59cb\u8fdb\u5165\u8f6e\u8be2\u8bf7\u6c42\uff1apollingLogin");
        IAppCache cloudDeveloperCache = AppCache.get((String)APPCACHE_KEY_CLOUD_DEVELOPER);
        CommunityuserService communityuserService = CommunityuserService.create();
        if (this.checkDeveloperLoginStatus(cloudDeveloperCache, developerCode)) {
            String sessionId = this.consumeDeveloperSession(cloudDeveloperCache, developerCode);
            this.logger.info(String.format("\u5f00\u59cb\u901a\u8fc7sessionid\u83b7\u53d6uid\uff1a%s", sessionId));
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
            String uid = sessionDAO.getAttribute(SESSIONKEY_DEVELOPER_UID);
            this.logger.info(String.format("\u5f00\u59cb\u83b7\u53d6\u7528\u6237uid\uff1a%s", uid));
            if (StringUtils.isBlank((CharSequence)uid)) {
                return CustomApiResult.fail((String)ErrorCode.AUTH_ERROR.code, (String)String.format("Unable to retrieve uid from the session associated with developerToken: %s. Please try logging in again.", sessionId));
            }
            this.logger.info("\u5f00\u59cb\u6839\u636euid\u67e5\u8be2\u7528\u6237\u4fe1\u606f");
            CommunityUser communityUser = communityuserService.find(Long.valueOf(uid));
            this.logger.info(String.format("\u67e5\u8be2\u5230\u7684\u7528\u6237\u4fe1\u606f\uff1a" + communityUser.toString(), new Object[0]));
            if (communityUser == null) {
                return CustomApiResult.fail((String)ErrorCode.USER_ERROR.code, (String)String.format("The developer associated with the current UID has not completed registration. Please contact the administrator. UID: %s", uid));
            }
            CommunitySessionUser communitySessionUser = new CommunitySessionUser();
            communitySessionUser.setCommunityUser(communityUser);
            communitySessionUser.setSessionId(sessionId);
            return CustomApiResult.success((Object)communitySessionUser);
        }
        return CustomApiResult.fail((String)"-1", (String)String.format("Session not found. Developer code: %s. Please ensure the session is initialized correctly.", developerCode));
    }

    @ApiPostMapping(value="cloudcommunity/developer/qaPolling")
    @ApiHeaders(value={@ApiHeader(name="developerToken", desc="\u5f00\u53d1\u8005Token")})
    @ApiErrorCodes(value={@ApiErrorCode(code="100", desc="\u53c2\u6570\u5f02\u5e38"), @ApiErrorCode(code="200", desc="\u6743\u9650\u5f02\u5e38"), @ApiErrorCode(code="300", desc="\u7528\u6237\u5f02\u5e38"), @ApiErrorCode(code="400", desc="\u989d\u5ea6\u5f02\u5e38")})
    public CustomApiResult<LLMAPIMsg> qaPolling(@ApiParam(value="\u95ee\u9898", example="\u5982\u4f55\u65b0\u5efa\u5355\u636e?", required=false) @ApiParam(value="\u95ee\u9898", example="\u5982\u4f55\u65b0\u5efa\u5355\u636e?", required=false) String question, @ApiParam(value="\u77e5\u8bc6\u5e93\u7f16\u7801", example="", required=false) @ApiParam(value="\u77e5\u8bc6\u5e93\u7f16\u7801", example="", required=false) String number, @ApiParam(value="\u8bf7\u6c42Id", example="", required=false) @ApiParam(value="\u8bf7\u6c42Id", example="", required=false) String requestId, @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1,Idea\uff1a2, vsCode:3,\u5176\u4ed6\uff1a99 ") @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1,Idea\uff1a2, vsCode:3,\u5176\u4ed6\uff1a99 ") Integer clientType, @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="") @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="") String userType, @ApiParam(value="\u5bf9\u8bddId", example="") @ApiParam(value="\u5bf9\u8bddId", example="") String chatSessionId, @ApiParam(value="\u63d0\u793a\u8bcd\u6a21\u7248\u7c7b\u578b \u9ed8\u8ba4: QA\u95ee\u7b54", example="1:\u751f\u6210\u4ee3\u7801 2:\u751f\u6210\u6ce8\u91ca 3:\u4ee3\u7801\u4f18\u5316 4:\u4ee3\u7801\u89e3\u91ca") @ApiParam(value="\u63d0\u793a\u8bcd\u6a21\u7248\u7c7b\u578b \u9ed8\u8ba4: QA\u95ee\u7b54", example="1:\u751f\u6210\u4ee3\u7801 2:\u751f\u6210\u6ce8\u91ca 3:\u4ee3\u7801\u4f18\u5316 4:\u4ee3\u7801\u89e3\u91ca") Integer promptTemplateType) {
        this.logger.info("\u5f00\u59cb\u8fdb\u5165\u5bf9\u8bdd\u8bf7\u6c42\uff1aqaPolling");
        CommunityuserService communityuserService = CommunityuserService.create();
        Map reqHeader = ServiceApiContext.getRequest().getRequestHeaders();
        String developerToken = (String)reqHeader.get("developerToken");
        if (StringUtils.isBlank((CharSequence)developerToken)) {
            return CustomApiResult.fail((String)ErrorCode.PARAMS_ERROR.code, (String)"Missing 'developerToken' parameter in the request header, unable to verify user identity.");
        }
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)developerToken);
        String uid = sessionDAO.getAttribute(SESSIONKEY_DEVELOPER_UID);
        if (StringUtils.isBlank((CharSequence)uid)) {
            return CustomApiResult.fail((String)ErrorCode.AUTH_ERROR.code, (String)String.format("Unable to retrieve uid from the session associated with developerToken: %s. Please try logging in again.", developerToken));
        }
        SessionInfo si = CloudDeveloperService.getSessinInfoBySessionId(developerToken);
        RequestContextCreator.createForOnlySesssion((String)sessionDAO.getSessionId(), (SessionInfo)si, (String)"web");
        this.logger.info(String.format("\u83b7\u53d6\u5bf9\u8bdd\u8bf7\u6c42\u63a5\u53e3\u4e2d\u5f00\u59cb\u5224\u65ad\u662f\u5426\u6ce8\u518c\uff1a%s", uid));
        boolean userRegistered = communityuserService.isUserRegistered(Long.valueOf(uid));
        this.logger.info(String.format("\u83b7\u53d6\u5bf9\u8bdd\u8bf7\u6c42\u63a5\u53e3\u4e2d\u5f00\u59cb\u5224\u65ad\u662f\u5426\u6ce8\u518c\u7684\u7ed3\u679c\uff1a%s", userRegistered));
        if (!userRegistered) {
            return CustomApiResult.fail((String)ErrorCode.USER_ERROR.code, (String)String.format("The developer associated with the current UID has not completed registration. Please contact the administrator. UID: %s", uid));
        }
        boolean userLimitFullResult = communityuserService.isUserLimitFull(Long.valueOf(uid), requestId);
        if (!userLimitFullResult) {
            return CustomApiResult.fail((String)ErrorCode.LIMITTOKEN_ERROR.code, (String)String.format("Unable to obtain credit limit : %s. Please try recharge.", requestId));
        }
        CustomApiResult llmapiMsgCustomApiResult = new QAService().qaPolling(question, number, requestId, clientType, userType, chatSessionId, promptTemplateType, uid);
        LLMData data = ((LLMAPIMsg)llmapiMsgCustomApiResult.getData()).getData();
        String llmValue = data.getLlmValue();
        byte[] bytes = llmValue.getBytes(StandardCharsets.UTF_8);
        int consumelength = new String(bytes).length();
        boolean end = data.isEnd();
        communityuserService.consume(Long.valueOf(uid), requestId, consumelength, clientType, end);
        return llmapiMsgCustomApiResult;
    }

    @ApiPostMapping(value="cloudcommunity/developer/getLatestIdeaPlugin")
    @ApiErrorCodes(value={@ApiErrorCode(code="400", desc="\u6570\u636e\u8ff7\u8def\u4e86")})
    public CustomApiResult<IDEAPluginVersion> getLatestIdeaPlugin() {
        return CustomApiResult.success((Object)new IDEAPluginVersion());
    }

    private boolean checkDeveloperLoginStatus(IAppCache cloudDeveloperCache, String developerCode) {
        String sessionId = (String)cloudDeveloperCache.get(developerCode, String.class);
        return StringUtils.isNotBlank((CharSequence)sessionId);
    }

    private String consumeDeveloperSession(IAppCache cloudDeveloperCache, String developerCode) {
        String sessionId = (String)cloudDeveloperCache.get(developerCode, String.class);
        cloudDeveloperCache.remove(developerCode);
        return sessionId;
    }

    private static SessionInfo getSessinInfoBySessionId(String sessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        Map sessionMap = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", "kdCsrfToken", "accountId", "uid", "loginIP", "loginOrg", "client", "accCompanyId", "api3rdAppId", "api3rdAppNum", "bizPartnerId"});
        SessionInfo sessionInfo = new SessionInfo();
        if (MapUtils.isEmpty((Map)sessionMap)) {
            return sessionInfo;
        }
        sessionInfo.setTenantId((String)sessionMap.get("tenantId"));
        sessionInfo.setSandboxId((String)sessionMap.get("sandboxId"));
        sessionInfo.setOrgId((String)sessionMap.get("orgId"));
        sessionInfo.setUserId((String)sessionMap.get("userId"));
        sessionInfo.setUserName((String)sessionMap.get("userName"));
        sessionInfo.setUserOpenId((String)sessionMap.get("userOpenId"));
        sessionInfo.setUserType((String)sessionMap.get("userType"));
        sessionInfo.setYzjAppId((String)sessionMap.get("yzjAppId"));
        sessionInfo.setYzjAppTicket((String)sessionMap.get("yzjAppTicket"));
        sessionInfo.setLanguage((String)sessionMap.get("language"));
        sessionInfo.setUid((String)sessionMap.get("uid"));
        sessionInfo.setAccCompany((String)sessionMap.get("accCompanyId"));
        sessionInfo.setAccountId((String)sessionMap.get("accountId"));
        String client = (String)sessionMap.get("client");
        sessionInfo.setClient(client);
        if ("api".equalsIgnoreCase(client)) {
            sessionInfo.setApi3rdAppId((String)sessionMap.get("api3rdAppId"));
            sessionInfo.setApi3rdAppNum((String)sessionMap.get("api3rdAppNum"));
        }
        sessionInfo.setLoginOrg((String)sessionMap.get("loginOrg"));
        sessionInfo.setBizPartnerId((String)sessionMap.get("bizPartnerId"));
        sessionInfo.setKdCsrfToken((String)sessionMap.get("kdCsrfToken"));
        sessionInfo.setLoginIP((String)sessionMap.get("loginIP"));
        return sessionInfo;
    }

    static enum ClientType {
        WEBCHAT(1, "web"),
        IDEA(2, "IDEA"),
        VSCODE(3, "VSCODE"),
        OTHER(99, "other");

        private Integer code;
        private String desc;

        private ClientType(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    static enum ErrorCode {
        PARAMS_ERROR("100", "param error"),
        AUTH_ERROR("200", "auth error"),
        USER_ERROR("300", "user error"),
        LIMITTOKEN_ERROR("400", "quota error");

        private String code;
        private String desc;

        private ErrorCode(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

