/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.developer.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ExtractZipContentPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String ENTITY = "bos_comm_ide_version";
    private static final String KEY_ATTACHMENTPANEL = "attachmentpanel";
    private static final String KEY_VERSION = "number";
    private static final String KEY_VERSIONDES = "versiondes";
    private static final String KEY_ISLATEST = "islatest";
    private static final String XMLPATH = "META-INF/plugin.xml";
    Log logger = LogFactory.getLog(ExtractZipContentPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        IDataModel model = this.getModel();
        Object[] urls = evt.getUrls();
        if (urls.length != 0) {
            String zipFileUrl = ((Map)urls[0]).get("url").toString();
            try {
                PluginVersionInfo pluginVersionInfo = this.extractVersionInfoFromUrl(zipFileUrl);
                if (pluginVersionInfo.isIllegal || pluginVersionInfo.version == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6b63\u786e\u6587\u4ef6\u3002", (String)"ExtractZipContentPlugin_01", (String)"bos-cloud-developer", (Object[])new Object[0]));
                    this.removeAttachment();
                } else {
                    model.setValue(KEY_VERSION, (Object)pluginVersionInfo.version);
                    model.setValue(KEY_VERSIONDES, (Object)pluginVersionInfo.changeNote);
                    model.setValue(KEY_ISLATEST, (Object)(this.isEarlierVersion(this.getHistoryLatestVersion(), pluginVersionInfo.version) ? 0 : 1));
                }
            }
            catch (Exception exception) {
                this.logger.error((Throwable)exception);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6b63\u786e\u6587\u4ef6\u3002", (String)"ExtractZipContentPlugin_01", (String)"bos-cloud-developer", (Object[])new Object[0]));
                this.removeAttachment();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginVersionInfo extractVersionInfoFromUrl(String zipFileUrl) throws Exception {
        TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
        PluginVersionInfo pluginVersionInfo = new PluginVersionInfo();
        Pattern jarPattern = Pattern.compile(".*instrumented.*\\.jar$");
        try (InputStream in = downLoad.getInputStream(zipFileUrl);
             BufferedInputStream bis = new BufferedInputStream(in);
             ZipInputStream zis = new ZipInputStream(bis);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ZipEntry entry;
            block59: while ((entry = zis.getNextEntry()) != null) {
                int count;
                Matcher matcher = jarPattern.matcher(entry.getName());
                if (!matcher.find()) continue;
                byte[] buffer = new byte[1024];
                while ((count = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, count);
                }
                ZipInputStream jarZis = new ZipInputStream(new ByteArrayInputStream(baos.toByteArray()));
                Throwable throwable2 = null;
                try {
                    ZipEntry jarEntry;
                    do {
                        if ((jarEntry = jarZis.getNextEntry()) == null) continue block59;
                    } while (!jarEntry.getName().equals(XMLPATH));
                    String xmlContent = this.readInputStream(jarZis);
                    Map<String, String> elementMap = this.extractElement(xmlContent);
                    String changeNotes = this.extractChangeNote(elementMap.get("change-notes"));
                    String version = elementMap.get("version");
                    PluginVersionInfo pluginVersionInfo2 = pluginVersionInfo = new PluginVersionInfo(false, changeNotes, version);
                    return pluginVersionInfo2;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (jarZis == null) continue;
                    if (throwable2 != null) {
                        try {
                            jarZis.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    jarZis.close();
                }
            }
            return pluginVersionInfo;
        }
    }

    private Map<String, String> extractElement(String xmlContent) throws DocumentException {
        Document document = DocumentHelper.parseText((String)xmlContent);
        Element root = document.getRootElement();
        List list = root.elements();
        HashMap<String, String> elementMap = new HashMap<String, String>(list.size());
        for (Element element : list) {
            elementMap.put(element.getName(), element.getText());
        }
        return elementMap;
    }

    private String readInputStream(InputStream inputStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder content = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            content.append(line);
        }
        return content.toString();
    }

    private String extractChangeNote(String changeNote) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)changeNote)) {
            for (String extractListItem : this.extractListItems(changeNote)) {
                stringBuilder.append(extractListItem);
            }
        }
        return stringBuilder.toString();
    }

    private List<String> extractListItems(String content) {
        int liEnd;
        int liStart;
        ArrayList<String> items = new ArrayList<String>();
        int startIndex = 0;
        while ((liStart = content.indexOf("<li>", startIndex)) != -1 && (liEnd = content.indexOf("</li>", liStart)) != -1) {
            items.add(content.substring(liStart + 4, liEnd).trim());
            startIndex = liStart + 5;
        }
        return items;
    }

    private void removeAttachment() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        if (!attachmentPanel.getAttachmentData().isEmpty()) {
            List mapList = attachmentPanel.getAttachmentData();
            Map map = (Map)mapList.get(0);
            String formId = map.get("entityNum").toString();
            Object pkId = map.get("billPkId");
            Object fileUid = map.get("uid");
            AttachmentServiceHelper.remove((String)formId, pkId, fileUid);
            attachmentPanel.remove(map);
            this.getView().invokeOperation("refresh");
        }
    }

    private String getHistoryLatestVersion() {
        try {
            QFilter filter = new QFilter(KEY_ISLATEST, "=", (Object)1);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)KEY_VERSION, (QFilter[])filter.toArray());
            if (dynamicObject != null) {
                return dynamicObject.getString(KEY_VERSION);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        return "0.0.0";
    }

    private boolean isEarlierVersion(String historyLatestVersion, String curVersion) {
        String[] hisParts = historyLatestVersion.split("\\.");
        String[] curParts = curVersion.split("\\.");
        int length = Math.max(hisParts.length, curParts.length);
        for (int i = 0; i < length; ++i) {
            int v2;
            int v1 = i < hisParts.length ? Integer.parseInt(hisParts[i]) : 0;
            int n = v2 = i < curParts.length ? Integer.parseInt(curParts[i]) : 0;
            if (v1 > v2) {
                return true;
            }
            if (v1 >= v2) continue;
            return false;
        }
        return true;
    }

    static class PluginVersionInfo {
        boolean isIllegal = true;
        String changeNote;
        String version;

        public PluginVersionInfo() {
        }

        public PluginVersionInfo(boolean isIllegal, String changeNote, String version) {
            this.isIllegal = isIllegal;
            this.changeNote = changeNote;
            this.version = version;
        }
    }
}

