/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.developer.service.Impl;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cloudcommunity.api.CommunityUser;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.developer.constants.LimitUserConstans;
import kd.bos.developer.pojo.CommunityUserLimit;
import kd.bos.developer.service.CommunityuserFlow;
import kd.bos.developer.service.CommunityuserService;
import kd.bos.developer.service.Impl.CommunityuserFlowImpl;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CommunityuserServiceImpl
extends AbstractFormPlugin
implements CommunityuserService {
    Log logger = LogFactory.getLog(CommunityuserServiceImpl.class);
    private CommunityuserFlow communityuserFlow = new CommunityuserFlowImpl();
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("CommunityuserServiceImpl", new DistributeCacheHAPolicy(true, true));
    private static final String KEY_COMMUNITY_USER = "community_user";
    private static final String KEY_COMMUNITY_USER_Limit = "community_user_limit";
    private static final String KEY_COMMUNITY_USER_Flow = "community_user_flow";
    private static final int CACHE_REQUESTID = 300;

    public boolean save(CommunityUser communityUser) {
        this.logger.info("\u5f00\u59cb\u4fdd\u5b58\u793e\u533a\u7528\u6237");
        if (communityUser == null) {
            return false;
        }
        this.logger.info("\u5224\u65ad\u662f\u5426\u5df2\u7ecf\u4fdd\u5b58\u8fc7uid");
        QFilter[] qFilters = new QFilter("uid", "=", (Object)communityUser.getUid()).toArray();
        DynamicObject[] uids = BusinessDataServiceHelper.load((String)KEY_COMMUNITY_USER, (String)"uid", (QFilter[])qFilters);
        if (uids.length > 0) {
            return false;
        }
        DynamicObject selfCourse = BusinessDataServiceHelper.newDynamicObject((String)KEY_COMMUNITY_USER);
        DynamicObject LimitObject = BusinessDataServiceHelper.newDynamicObject((String)KEY_COMMUNITY_USER_Limit);
        CommunityUserLimit communityUserLimit = new CommunityUserLimit();
        communityUserLimit.setLid(ID.genLongId());
        communityUserLimit.setUid(communityUser.getUid());
        this.extracted(communityUser, selfCourse, LimitObject);
        this.extracted(selfCourse, communityUser);
        Object[] saveuser = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selfCourse});
        this.logger.info("\u4fdd\u5b58\u793e\u533a\u7528\u6237\u5165\u5e93\u6210\u529f" + selfCourse.toString());
        Object[] savelimit = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{LimitObject});
        this.logger.info("\u4fdd\u5b58\u793e\u533a\u7528\u6237\u989d\u5ea6\u5165\u5e93\u6210\u529f" + LimitObject.toString());
        return true;
    }

    private void extracted(CommunityUser communityUser, DynamicObject selfCourse, DynamicObject LimitObject) {
        LimitObject.set("status", (Object)"C");
        LimitObject.set("enable", (Object)"1");
        LimitObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        LimitObject.set("uid", (Object)communityUser.getUid());
        LimitObject.set("totalamount", (Object)LimitUserConstans.MaxLimitCounts);
        LimitObject.set("currentamount", (Object)LimitUserConstans.MaxLimitCounts);
        LimitObject.set("remainamount", (Object)LimitUserConstans.MaxLimitCounts);
    }

    @Override
    public boolean update(CommunityUser communityUser) {
        if (communityUser == null) {
            return false;
        }
        QFilter[] qFilters = new QFilter("uid", "=", (Object)communityUser.getUid()).toArray();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)KEY_COMMUNITY_USER, (QFilter[])qFilters);
        if (dynamicObject != null) {
            DeleteServiceHelper.delete((String)KEY_COMMUNITY_USER, (QFilter[])qFilters);
            DynamicObject selfCourse = BusinessDataServiceHelper.newDynamicObject((String)KEY_COMMUNITY_USER);
            selfCourse.set("status", (Object)"C");
            selfCourse.set("creator", (Object)RequestContext.get().getCurrUserId());
            this.extracted(selfCourse, communityUser);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selfCourse});
            return true;
        }
        return false;
    }

    private void extracted(DynamicObject selfCourse, CommunityUser communityUser) {
        selfCourse.set("status", (Object)"C");
        selfCourse.set("enable", (Object)"1");
        selfCourse.set("creator", (Object)RequestContext.get().getCurrUserId());
        selfCourse.set("uid", (Object)communityUser.getUid());
        selfCourse.set("address", (Object)communityUser.getAddress());
        selfCourse.set("avatar", (Object)communityUser.getAvatar());
        selfCourse.set("phone", (Object)communityUser.getPhone());
        selfCourse.set("email", (Object)communityUser.getEmail());
        selfCourse.set("gender", (Object)communityUser.getGender());
        selfCourse.set("birthday", (Object)communityUser.getBirthday());
        selfCourse.set("nickname", (Object)communityUser.getNickName());
    }

    @Override
    public boolean delete(Long uid) {
        QFilter q1 = new QFilter("uid", "=", (Object)uid);
        QFilter[] filter = new QFilter[]{q1};
        int delete = DeleteServiceHelper.delete((String)KEY_COMMUNITY_USER, (QFilter[])filter);
        return delete != 0;
    }

    @Override
    public boolean isUserRegistered(Long uid) {
        this.logger.info("\u5224\u65ad\u7528\u6237uid\u662f\u5426\u5df2\u7ecf\u6ce8\u518c\u8fc7\uff1a" + uid);
        QFilter[] qFilters = new QFilter("uid", "=", (Object)uid).toArray();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)KEY_COMMUNITY_USER, (QFilter[])qFilters);
        return dynamicObject != null;
    }

    @Override
    public void consume(Long uid, String requestId, int consumelength, Integer clientType, boolean end) {
        if (end) {
            this.communityuserFlow.consume(uid, consumelength, clientType);
            this.cache.remove(requestId);
        }
    }

    @Override
    public boolean isUserLimitFull(Long uid, String flowid) {
        QFilter[] qFilterss;
        DynamicObject LimitObject;
        if (!this.cache.contains(flowid) && (LimitObject = BusinessDataServiceHelper.loadSingle((String)KEY_COMMUNITY_USER_Limit, (QFilter[])(qFilterss = new QFilter("uid", "=", (Object)uid).toArray()))) != null) {
            boolean flag = LimitObject.getInt("remainamount") >= LimitUserConstans.InitialLimit;
            this.cache.put(flowid, (Object)String.valueOf(flag), 300);
            return flag;
        }
        return "true".equals(this.cache.get(flowid));
    }

    @Override
    public CommunityUser find(Long uid) {
        this.logger.info("\u6839\u636euid\u67e5\u627e\u7528\u6237\u4fe1\u606f\u5e76\u8fd4\u56de\u5b9e\u4f53\u7c7b\uff1a" + uid);
        QFilter[] qFilters = new QFilter("uid", "=", (Object)uid).toArray();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)KEY_COMMUNITY_USER, (QFilter[])qFilters);
        CommunityUser communityUser = this.getCommunityUser(dynamicObject);
        this.logger.info("\u6839\u636euid\u67e5\u627e\u7528\u6237\u4fe1\u606f\u5e76\u8fd4\u56de\u5b9e\u4f53\u7c7b\u7ed3\u679c\u4e3a\uff1a" + communityUser.toString());
        return communityUser;
    }

    private CommunityUser getCommunityUser(DynamicObject dynamicObject) {
        CommunityUser communityUser = new CommunityUser();
        communityUser.setAddress((String)dynamicObject.get("address"));
        communityUser.setUid((Long)dynamicObject.get("uid"));
        communityUser.setAvatar((String)dynamicObject.get("avatar"));
        communityUser.setEmail((String)dynamicObject.get("email"));
        communityUser.setNickName((String)dynamicObject.get("nickname"));
        communityUser.setBirthday((String)dynamicObject.get("birthday"));
        communityUser.setGender((Integer)dynamicObject.get("gender"));
        communityUser.setPhone((String)dynamicObject.get("phone"));
        return communityUser;
    }
}

