/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.kingscript.console.RequestContextChangeException;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import org.apache.commons.lang3.StringUtils;

public class RequestContextChanged
implements AutoCloseable {
    private RequestContext oldRequestContext = RequestContext.get();

    private RequestContextChanged() {
    }

    public static RequestContextChanged newInstance(String accountId) {
        RequestContextChanged requestContextChanged = new RequestContextChanged();
        RequestContext requestContext = RequestContext.create();
        requestContext.setAccountId(accountId);
        Account account = AccountUtils.getAccountById((String)accountId);
        if (account == null) {
            throw new RuntimeException("RequestContextChanged#newInstance error");
        }
        requestContext.setTenantId(account.getTenantId());
        return requestContextChanged;
    }

    public static RequestContextChanged newInstanceForVSCode() {
        RequestContextChanged requestContextChanged = new RequestContextChanged();
        String pcSessionId = SessionDAOFactory.get().getAttribute("pcSessionId");
        if (StringUtils.isBlank((CharSequence)pcSessionId)) {
            throw new RequestContextChangeException(String.format("PC session ID not found. Current VSCode session ID: %s", requestContextChanged.getOldRequestContext()));
        }
        RequestContext ctx = RequestContext.create();
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)pcSessionId);
        Map map = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", "accountId", "uid", "loginOrg", "client", "api3rdAppId", "api3rdAppNum"});
        SessionInfo pcSessionInfo = SessionManager.getSessionInfo((Map)map);
        if (null == pcSessionInfo) {
            throw new RequestContextChangeException(String.format("PC session ID not found. Current VSCode session ID: %s", requestContextChanged.getOldRequestContext()));
        }
        RequestContext current = requestContextChanged.oldRequestContext;
        ctx.setRequestId(current.getRequestId());
        ctx.setTraceId(current.getTraceId());
        ctx.setSandboxId(current.getSandboxId());
        ctx.setClient(current.getClient());
        ctx.setUserAgent(current.getUserAgent());
        ctx.setLocalSessionId(current.getLocalSessionId());
        ctx.setTenantCode(current.getTenantCode());
        ctx.setOrgId(Long.parseLong(pcSessionInfo.getOrgId()));
        ctx.setClientFullContextPath(current.getClientFullContextPath());
        ctx.setClientContextPath(current.getClientContextPath());
        ctx.setClientUrl(current.getClientUrl());
        ctx.setQueryString(current.getQueryString());
        ctx.setLang(current.getLang());
        ctx.setLoginIP(current.getLoginIP());
        ctx.setLoginTime(current.getLoginTime());
        ctx.setDebugInfo(current.getDebugInfo());
        ctx.setYzjAppId(current.getYzjAppId());
        ctx.setYzjAppTicket(current.getYzjAppTicket());
        ctx.setTccTransactionId(current.getTccTransactionId());
        ctx.setTccBranchId(current.getTccBranchId());
        ctx.setAccCompanyId(current.getAccCompanyId());
        ctx.setApi3rdAppId(current.getApi3rdAppId());
        ctx.setBizPartnerId(current.getBizPartnerId());
        ctx.setOperationType(current.getOperationType());
        ctx.setAuthType(current.getAuthType());
        ctx.setUserOpenId(current.getUserOpenId());
        ctx.setAccountId(current.getAccountId());
        ctx.setTenantId(current.getTenantId());
        ctx.setUid(pcSessionInfo.getUid());
        ctx.setUserId(pcSessionInfo.getUserId());
        ctx.setGlobalSessionId(pcSessionId);
        ctx.setUserType(pcSessionInfo.getUserType());
        ctx.setUserName(pcSessionInfo.getUserName());
        return requestContextChanged;
    }

    public RequestContext getOldRequestContext() {
        return this.oldRequestContext;
    }

    @Override
    public void close() {
        RequestContext.set((RequestContext)this.oldRequestContext);
    }
}

