/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.control;

import com.oracle.truffle.polyglot.PolyglotContextImpl;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import kd.sdk.kingscript.engine.KingScriptContext;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.exception.ScriptTimeoutException;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.timeout.service.LevelTimeoutInterrupter;
import org.graalvm.polyglot.Context;
import org.slf4j.Logger;

public class DebugLevelTimeoutInterrupterImpl
implements LevelTimeoutInterrupter {
    private static final Logger logger = Logs.getLogger();
    private final Context context;
    private final String engineName;
    private final KingScriptEngineImpl engine;
    private volatile boolean terminated = false;
    private volatile boolean started = false;
    private volatile boolean checking = false;
    private volatile boolean interrupted = true;
    private final Object interruptedLock = new Object();
    private volatile String timeoutMessage = null;
    private long timeout;
    private volatile long beginTimeMillis;
    private String scriptName;
    private String scriptPath;

    public DebugLevelTimeoutInterrupterImpl(String engineName, Context context, KingScriptEngineImpl engine) {
        this.engineName = engineName;
        this.context = context;
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTiming(String scriptName, String scriptPath) {
        this.scriptPath = scriptPath;
        try {
            this.timeout = this.engine.getOptions().getCachedSecurityController().getScriptEvalDebugTimeout();
        }
        catch (Exception e) {
            this.timeout = Long.MAX_VALUE;
            logger.warn("error:" + e.getMessage());
        }
        finally {
            this.beginTimeMillis = System.currentTimeMillis();
            this.scriptName = scriptName;
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTiming() {
        this.started = false;
        if (!this.interrupted) {
            Object object = this.interruptedLock;
            synchronized (object) {
                if (!this.interrupted) {
                    try {
                        this.interruptedLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void onTimeout() {
        if (this.timeoutMessage != null) {
            ScriptTimeoutException e = new ScriptTimeoutException(this.timeoutMessage);
            this.timeoutMessage = null;
            this.resume();
            throw e;
        }
    }

    private void resume() {
        Context context = KingScriptContext.get().getContext();
        try {
            Field field = context.getClass().getDeclaredField("receiver");
            field.setAccessible(true);
            PolyglotContextImpl receiver = (PolyglotContextImpl)field.get(context);
            receiver.resumeInterrupt();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void destroy() {
        this.terminated = true;
    }

    public void run() {
        if (!this.terminated && this.started && !this.checking) {
            this.checking = true;
            try {
                this.check();
            }
            finally {
                this.checking = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        block15: {
            try {
                this.timeoutMessage = null;
                if (this.remainTimeMillis() >= 0L) break block15;
                this.started = false;
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                String newName = oldName + '#' + this.engineName + '#' + this.scriptName + '#' + System.currentTimeMillis();
                currentThread.setName(newName);
                try {
                    this.timeoutMessage = "KingScript execute timeout(>" + this.timeout + "ms): " + this.scriptName;
                    logger.warn(this.timeoutMessage);
                    Object object = this.interruptedLock;
                    synchronized (object) {
                        this.interrupted = false;
                    }
                    this.engine.getKingScriptContext().setRuntimeAttr("timeout_message_key", (Object)this.timeoutMessage);
                    this.context.interrupt(Duration.ofMillis(Long.MAX_VALUE));
                    object = this.interruptedLock;
                    synchronized (object) {
                        this.interrupted = true;
                        this.interruptedLock.notifyAll();
                    }
                }
                finally {
                    currentThread.setName(oldName);
                }
            }
            catch (TimeoutException currentThread) {
            }
            catch (Exception e) {
                Object object = this.interruptedLock;
                synchronized (object) {
                    this.interrupted = true;
                    this.interruptedLock.notifyAll();
                }
                throw ScriptException.wrap((Throwable)e);
            }
        }
    }

    public boolean isStartTiming() {
        return !this.terminated && this.started;
    }

    public long remainTimeMillis() {
        if (this.beginTimeMillis == 0L) {
            return 0L;
        }
        return this.timeout - (System.currentTimeMillis() - this.beginTimeMillis);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isDestroyed() {
        return this.terminated;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }
}

