/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.kingscript.console.control.LevelControlScript;
import org.apache.commons.collections4.CollectionUtils;

public class LevelControl {
    public static final String ENTITY_NAME = "kingscript_level_control";
    public static final LevelControl EMPTY = new LevelControl();
    private Long pkId;
    private String billno;
    private String controlName;
    private String controlLevel;
    private BigDecimal limitRuntime;
    private String tenant;
    private String module;
    private Date modifyTime;
    private List<LevelControlScript> scriptLevelControlScripts;

    public static LevelControl createInstance(Long pkId, String billno, String controlName, String controlLevel, BigDecimal limitRuntime, String module, Date modifyTime) {
        LevelControl scriptLevelControl = new LevelControl();
        scriptLevelControl.pkId = pkId;
        scriptLevelControl.billno = billno;
        scriptLevelControl.controlName = controlName;
        scriptLevelControl.controlLevel = controlLevel;
        scriptLevelControl.limitRuntime = limitRuntime;
        scriptLevelControl.tenant = RequestContext.get().getTenantId();
        scriptLevelControl.module = module;
        scriptLevelControl.modifyTime = modifyTime;
        return scriptLevelControl;
    }

    public static LevelControl convertFromDynamicObject(DynamicObject dynamicObject) {
        LevelControl scriptLevelControl = new LevelControl();
        scriptLevelControl.pkId = (Long)dynamicObject.getPkValue();
        scriptLevelControl.billno = dynamicObject.getString(((BillEntityType)dynamicObject.getDataEntityType()).getBillNo());
        scriptLevelControl.controlName = dynamicObject.getString("control_name");
        scriptLevelControl.controlLevel = dynamicObject.getString("control_level");
        scriptLevelControl.limitRuntime = dynamicObject.getBigDecimal("limit_runtime");
        scriptLevelControl.tenant = RequestContext.get().getTenantId();
        scriptLevelControl.module = dynamicObject.getString("module");
        scriptLevelControl.modifyTime = dynamicObject.getDate("modifytime");
        DynamicObjectCollection entryDataEntity = dynamicObject.getDynamicObjectCollection("entry_script");
        if (CollectionUtils.isNotEmpty((Collection)entryDataEntity)) {
            scriptLevelControl.scriptLevelControlScripts = new ArrayList<LevelControlScript>(entryDataEntity.size());
            for (DynamicObject scriptPlugin : entryDataEntity) {
                Long entryId = (Long)scriptPlugin.getPkValue();
                String scriptId = scriptPlugin.getString("script_basedata.id");
                LevelControlScript scriptLevelControlScript = new LevelControlScript(entryId, scriptId);
                scriptLevelControl.scriptLevelControlScripts.add(scriptLevelControlScript);
            }
        }
        return scriptLevelControl;
    }

    public BigDecimal getLimitRuntime() {
        return this.limitRuntime;
    }

    public Long getPkId() {
        return this.pkId;
    }

    public String getBillno() {
        return this.billno;
    }

    public String getControlName() {
        return this.controlName;
    }

    public String getControlLevel() {
        return this.controlLevel;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getModule() {
        return this.module;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public List<LevelControlScript> getScriptLevelControlScripts() {
        return this.scriptLevelControlScripts;
    }

    static {
        LevelControl.EMPTY.limitRuntime = new BigDecimal(Long.MAX_VALUE);
    }
}

