/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.control.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.kingscript.console.RequestContextChanged;
import kd.bos.kingscript.console.control.LevelControl;
import kd.bos.kingscript.console.control.level.ConfigAssemble;
import kd.bos.kingscript.console.control.level.LevelConfig;
import kd.bos.kingscript.console.control.level.LevelControlEnum;
import kd.bos.kingscript.console.control.level.LevelWrapper;
import kd.bos.kingscript.console.monitor.ScriptPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

class CacheTimeoutConfigService {
    private static final LocalMemoryCache configCache;
    private static LevelWrapper scriptConfigStore;
    private static Map<String, Object> accountLockMap;

    CacheTimeoutConfigService() {
    }

    static LevelControl getConfig(ScriptPlugin scriptPlugin) {
        String accountId = RequestContext.get().getAccountId();
        LevelConfig levelConfig = ConfigAssemble.create(scriptPlugin);
        Map<LevelControlEnum, Map<String, List<LevelControl>>> allConfig = CacheTimeoutConfigService.getConfigByAccount(accountId);
        return levelConfig.getConfig(allConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<LevelControlEnum, Map<String, List<LevelControl>>> getConfigByAccount(String accountId) {
        Object lock;
        Object object = lock = accountLockMap.computeIfAbsent(accountId, k -> new Object());
        synchronized (object) {
            Map<LevelControlEnum, Map<String, List<LevelControl>>> map = (Map<LevelControlEnum, Map<String, List<LevelControl>>>)configCache.get(accountId);
            if (map == null) {
                map = CacheTimeoutConfigService.loadByAccount(accountId);
                configCache.put(accountId, map);
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearConfig(String accountId) {
        Object lock;
        Object object = lock = accountLockMap.computeIfAbsent(accountId, k -> new Object());
        synchronized (object) {
            configCache.remove(new String[]{accountId});
        }
    }

    private static Map<LevelControlEnum, Map<String, List<LevelControl>>> loadByAccount(String accountId) {
        List<LevelControl> controls;
        HashMap<LevelControlEnum, Map<String, List<LevelControl>>> result = new HashMap<LevelControlEnum, Map<String, List<LevelControl>>>(4);
        if (RequestContext.get() != null && accountId.equals(RequestContext.get().getAccountId())) {
            controls = CacheTimeoutConfigService.loadFromDB();
        } else {
            try (RequestContextChanged changed = RequestContextChanged.newInstance(accountId);){
                controls = CacheTimeoutConfigService.loadFromDB();
            }
        }
        Map<LevelControlEnum, List<LevelControl>> scriptLevelControlsMap = CacheTimeoutConfigService.groupByControlLevel(controls);
        scriptConfigStore.buildAllConfig(scriptLevelControlsMap, result);
        return result;
    }

    private static List<LevelControl> loadFromDB() {
        String select = "id, billno, control_name, control_level, limit_runtime, module, modifytime, entry_script.script_basedata";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"kingscript_level_control", (String)select, null);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            List<LevelControl> scriptLevelControls = Arrays.stream(dynamicObjects).map(LevelControl::convertFromDynamicObject).collect(Collectors.toList());
            return scriptLevelControls;
        }
        return new ArrayList<LevelControl>(1);
    }

    private static Map<LevelControlEnum, List<LevelControl>> groupByControlLevel(Collection<LevelControl> scriptLevelControls) {
        return scriptLevelControls.stream().collect(Collectors.groupingBy(s -> LevelControlEnum.convert(s.getControlLevel())));
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(604800000);
        info.setTimeToLive(true);
        info.setMaxItemSize(100000);
        configCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("KingScript", "CacheTimeoutConfigService", info);
        scriptConfigStore = ConfigAssemble.create();
        accountLockMap = new ConcurrentHashMap<String, Object>();
    }
}

