/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.control.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.kingscript.console.control.LevelControl;
import kd.bos.kingscript.console.control.cache.CacheTimeoutConfigService;
import kd.bos.kingscript.console.monitor.ScriptPlugin;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.timeout.service.TimeoutConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ScriptPathSecurityCache
implements TimeoutConfig {
    private static final Logger logger = Logs.getLogger();
    private static final LocalMemoryCache scriptPathControlCache;
    private static Object lock;

    public void preheat() {
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : accounts) {
            try {
                CacheTimeoutConfigService.getConfigByAccount(account.getAccountId());
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LevelControl getTimeoutControl(String scriptPath) {
        Map scriptControlCache;
        LevelControl control;
        RequestContext requestContext = RequestContext.get();
        if (requestContext == null) {
            return null;
        }
        String accountId = requestContext.getAccountId();
        if (!scriptPathControlCache.contains(accountId)) {
            scriptPathControlCache.put(accountId, new HashMap(128));
        }
        if ((control = (LevelControl)(scriptControlCache = (Map)scriptPathControlCache.get(accountId)).get(scriptPath)) == null) {
            Object object = lock;
            synchronized (object) {
                if (control == null) {
                    control = ScriptPathSecurityCache.loadTimeoutControl(scriptPath);
                    scriptControlCache.put(scriptPath, control);
                    String formattedPath = ScriptPathFormat.format((String)scriptPath);
                    scriptControlCache.putIfAbsent(formattedPath, control);
                }
            }
        }
        return control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTimeoutControl(String accountId) {
        Object object = lock;
        synchronized (object) {
            if (StringUtils.isBlank((CharSequence)accountId)) {
                accountId = RequestContext.get().getAccountId();
            }
            scriptPathControlCache.remove(new String[]{accountId});
            CacheTimeoutConfigService.clearConfig(accountId);
        }
    }

    private static LevelControl loadTimeoutControl(String scriptPath) {
        Optional<ScriptPlugin> kingScriptPlugin = ScriptPlugin.loadScript(scriptPath);
        return kingScriptPlugin.map(CacheTimeoutConfigService::getConfig).orElse(null);
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(604800000);
        info.setTimeToLive(true);
        info.setMaxItemSize(100000);
        scriptPathControlCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("KingScript", "ScriptPathSecurityCache", info);
        lock = new Object();
    }
}

