/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.control.level;

import java.util.List;
import java.util.Map;
import kd.bos.kingscript.console.control.LevelControl;
import kd.bos.kingscript.console.control.level.LevelConfig;
import kd.bos.kingscript.console.control.level.LevelControlEnum;
import kd.bos.kingscript.console.control.level.LevelWrapper;
import kd.bos.kingscript.console.monitor.ScriptPlugin;

public abstract class BaseConfig
implements LevelConfig,
LevelWrapper {
    protected LevelConfig config;

    public BaseConfig(LevelConfig config) {
        this.config = config;
    }

    @Override
    public void buildAllConfig(Map<LevelControlEnum, List<LevelControl>> originData, Map<LevelControlEnum, Map<String, List<LevelControl>>> cacheData) {
        List<LevelControl> levelControls;
        if (this.config != null) {
            this.config.buildAllConfig(originData, cacheData);
        }
        if ((levelControls = originData.get((Object)this.getControlLevel())) != null && !levelControls.isEmpty()) {
            Map<String, List<LevelControl>> result = this.wrap(levelControls);
            cacheData.put(this.getControlLevel(), result);
        }
    }

    @Override
    public LevelControl getConfig(Map<LevelControlEnum, Map<String, List<LevelControl>>> cacheData) {
        LevelControl scriptLevelControl;
        if (this.config != null && (scriptLevelControl = this.config.getConfig(cacheData)) != null) {
            return scriptLevelControl;
        }
        Map<String, List<LevelControl>> levelCacheData = cacheData.get((Object)this.getControlLevel());
        if (levelCacheData != null && !levelCacheData.isEmpty()) {
            List<LevelControl> configs = this.unwrap(levelCacheData);
            return this.getConfigByLimitRuntime(configs);
        }
        return null;
    }

    @Override
    public ScriptPlugin getKingScriptPlugin() {
        return this.config.getKingScriptPlugin();
    }
}

