/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.control.level;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.kingscript.console.control.LevelControl;
import kd.bos.kingscript.console.control.LevelControlScript;
import kd.bos.kingscript.console.control.level.BaseConfig;
import kd.bos.kingscript.console.control.level.LevelControlEnum;
import kd.bos.kingscript.console.control.level.LevelWrapper;
import kd.bos.kingscript.console.monitor.ScriptPlugin;

public class FileLevelConfig
extends BaseConfig
implements LevelWrapper {
    private ScriptPlugin scriptPlugin;

    public FileLevelConfig(ScriptPlugin scriptPlugin) {
        super(null);
        this.scriptPlugin = scriptPlugin;
    }

    @Override
    public LevelControlEnum getControlLevel() {
        return LevelControlEnum.SCRIPT;
    }

    @Override
    public Map<String, List<LevelControl>> wrap(List<LevelControl> originData) {
        HashMap<String, List<LevelControl>> scriptPathCacheDatas = new HashMap<String, List<LevelControl>>();
        for (LevelControl control : originData) {
            for (LevelControlScript plugin : control.getScriptLevelControlScripts()) {
                List cacheControls = scriptPathCacheDatas.computeIfAbsent(plugin.getScriptId(), k -> new ArrayList());
                cacheControls.add(control);
            }
        }
        return scriptPathCacheDatas;
    }

    @Override
    public List<LevelControl> unwrap(Map<String, List<LevelControl>> cacheData) {
        return cacheData.get(this.getKingScriptPlugin().getScriptId());
    }

    @Override
    public ScriptPlugin getKingScriptPlugin() {
        return this.scriptPlugin;
    }
}

