/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.control.level;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.kingscript.console.control.LevelControl;
import kd.bos.kingscript.console.control.level.BaseConfig;
import kd.bos.kingscript.console.control.level.LevelConfig;
import kd.bos.kingscript.console.control.level.LevelControlEnum;
import kd.bos.kingscript.console.control.level.LevelWrapper;
import kd.sdk.kingscript.security.DefaultSecurityController;

public class GlobalConfig
extends BaseConfig
implements LevelWrapper {
    public GlobalConfig(LevelConfig config) {
        super(config);
    }

    @Override
    public LevelControlEnum getControlLevel() {
        return LevelControlEnum.GLOBAL;
    }

    @Override
    public void buildAllConfig(Map<LevelControlEnum, List<LevelControl>> originData, Map<LevelControlEnum, Map<String, List<LevelControl>>> cacheData) {
        DefaultSecurityController securityController = DefaultSecurityController.INSTANCE;
        long timeout = securityController.getScriptEvalTimeout();
        LevelControl levelControl = LevelControl.createInstance(1L, "global_config", "Global", this.getControlLevel().getLevel(), new BigDecimal(timeout / 1000L), null, new Date());
        originData.computeIfAbsent(this.getControlLevel(), k -> new ArrayList(1)).add(levelControl);
        super.buildAllConfig(originData, cacheData);
    }

    @Override
    public Map<String, List<LevelControl>> wrap(List<LevelControl> originData) {
        return originData.stream().collect(Collectors.groupingBy(s -> "ALL"));
    }

    @Override
    public List<LevelControl> unwrap(Map<String, List<LevelControl>> cacheData) {
        return cacheData.get("ALL");
    }
}

