/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.monitor;

import java.util.Map;
import java.util.Optional;
import kd.bos.kingscript.console.RequestContextChanged;
import kd.bos.kingscript.console.monitor.ScriptMonitorManager;
import kd.bos.kingscript.console.monitor.ScriptPlugin;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.cost.CostData;
import kd.sdk.kingscript.monitor.cost.EngineCostType;
import kd.sdk.kingscript.monitor.report.Reporter;
import org.slf4j.Logger;

public class KingScriptExecDBReport
implements Reporter {
    private static final Logger logger = Logs.getLogger();

    public void report(Map<String, Map<String, CostData>> accountCosts) {
    }

    public void reportDetail(Map<String, Map<String, Map<String, CostData>>> accountCosts) {
        for (Map.Entry<String, Map<String, Map<String, CostData>>> accountCostsEntry : accountCosts.entrySet()) {
            Map<String, Map<String, CostData>> typeCosts = accountCostsEntry.getValue();
            for (Map.Entry<String, Map<String, CostData>> typeCostsEntry : typeCosts.entrySet()) {
                if (!typeCostsEntry.getKey().equals(EngineCostType.engine_eval.name())) continue;
                Map<String, CostData> scriptPathCosts = typeCostsEntry.getValue();
                for (Map.Entry<String, CostData> scriptPathCostsEntry : scriptPathCosts.entrySet()) {
                    this.record(accountCostsEntry.getKey(), scriptPathCostsEntry.getKey(), scriptPathCostsEntry.getValue());
                }
            }
        }
    }

    private void record(String accountId, String scriptPath, CostData costData) {
        if ("ACCOUNT_SHARED".equals(accountId)) {
            return;
        }
        try (RequestContextChanged rc = RequestContextChanged.newInstance(accountId);){
            Optional<ScriptPlugin> pluginOptional = ScriptPlugin.loadScript(scriptPath);
            if (!pluginOptional.isPresent()) {
                return;
            }
            String scriptId = pluginOptional.get().getScriptId();
            Optional<ScriptMonitorManager> monitorOptional = ScriptMonitorManager.load(scriptId);
            ScriptMonitorManager scriptMonitor = monitorOptional.orElseGet(() -> ScriptMonitorManager.add(scriptId));
            scriptMonitor.addRecord(costData);
        }
        catch (Exception e) {
            if (e.getMessage().contains("kd.bos.orm.query.NoSuchPropertyException")) {
                logger.info("KingScriptExecDBReport.record error, scriptpath: " + scriptPath + ", accountid: " + accountId);
                return;
            }
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }
}

