/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.monitor;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.kingscript.console.monitor.ScriptMonitorManager;
import kd.sdk.kingscript.monitor.cost.CostData;
import org.apache.commons.lang3.StringUtils;

public class ScriptExecRecord {
    private Long scriptMonitorId;
    private int execCount;
    private BigDecimal execTime;
    private BigDecimal execMaxTime;
    private boolean isExecption;
    private String execptionContext;

    public static ScriptExecRecord createExecRecord(ScriptMonitorManager scriptMonitor, CostData costData) {
        ScriptExecRecord execRecord = new ScriptExecRecord();
        execRecord.scriptMonitorId = scriptMonitor.getId();
        execRecord.execCount = costData.getTimes();
        execRecord.execTime = new BigDecimal((double)costData.getTotalCost() * 0.001);
        execRecord.execMaxTime = new BigDecimal((double)costData.getMaxCost() * 0.001);
        execRecord.execptionContext = costData.getExceptionContext();
        execRecord.isExecption = StringUtils.isNotBlank((CharSequence)costData.getExceptionContext());
        return execRecord;
    }

    public void convertToDynamicObject(DynamicObject dynamicObject) {
        dynamicObject.set("exec_scene", (Object)"engine_eval");
        dynamicObject.set("exec_count", (Object)this.execCount);
        dynamicObject.set("exec_time", (Object)this.execTime);
        dynamicObject.set("exec_max_time", (Object)this.execMaxTime);
        dynamicObject.set("exec_is_exception", (Object)this.isExecption);
        dynamicObject.set("exec_exception_context", (Object)this.execptionContext);
    }

    public Long getScriptMonitorId() {
        return this.scriptMonitorId;
    }

    public int getExecCount() {
        return this.execCount;
    }

    public BigDecimal getExecTime() {
        return this.execTime;
    }

    public boolean isExecption() {
        return this.isExecption;
    }

    public String getExecptionContext() {
        return this.execptionContext;
    }
}

