/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.monitor;

import dm.jdbc.util.IDGenerator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.kingscript.console.monitor.ScriptExecRecord;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.kingscript.monitor.cost.CostData;

public class ScriptMonitorManager {
    private static final String ENTITY_NAME = "kingscript_monitor";
    private long id;
    private String scriptNumber;
    private String scriptName;
    private String scriptModule;
    private Long allCount;

    public void addRecord(CostData costData) {
        ScriptExecRecord scriptExecRecord = ScriptExecRecord.createExecRecord(this, costData);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getId(), (String)ENTITY_NAME);
        DynamicObjectCollection entryExecRecord = dynamicObject.getDynamicObjectCollection("entry_exec_record");
        DynamicObjectType entryType = entryExecRecord.getDynamicObjectType();
        DynamicObject entryData = new DynamicObject(entryType);
        scriptExecRecord.convertToDynamicObject(entryData);
        entryExecRecord.add((Object)entryData);
        long allCount = dynamicObject.getLong("all_count");
        dynamicObject.set("all_count", (Object)(allCount + (long)scriptExecRecord.getExecCount()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static Optional<ScriptMonitorManager> load(String scriptId) {
        QFilter[] qFilters = new QFilter("script_basedata", "=", (Object)scriptId).toArray();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])qFilters);
        return ScriptMonitorManager.convertFromDynamicObject(dynamicObject);
    }

    public static ScriptMonitorManager add(String scriptId) {
        BillEntityType dataEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)ENTITY_NAME);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
        String billno = IDGenerator.generateStrId((int)20);
        dynamicObject.set(dataEntityType.getBillNo(), (Object)billno);
        dynamicObject.set("all_count", (Object)0L);
        dynamicObject.set("script_basedata", (Object)scriptId);
        dynamicObject.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        QFilter[] qFilters = new QFilter(dataEntityType.getBillNo(), "=", (Object)billno).toArray();
        DynamicObject newDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])qFilters);
        return ScriptMonitorManager.convertFromDynamicObject(newDynamicObject).get();
    }

    public static Optional<ScriptMonitorManager> convertFromDynamicObject(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return Optional.empty();
        }
        ScriptMonitorManager monitor = new ScriptMonitorManager();
        DynamicObject scriptPluginBasedata = dynamicObject.getDynamicObject("script_basedata");
        monitor.id = (Long)dynamicObject.getPkValue();
        monitor.allCount = dynamicObject.getLong("all_count");
        monitor.scriptName = scriptPluginBasedata.getString("txt_scriptname");
        monitor.scriptNumber = scriptPluginBasedata.getString("txt_scriptnumber");
        monitor.scriptModule = scriptPluginBasedata.getString("scriptmodule");
        return Optional.of(monitor);
    }

    public static ScriptMonitorManager convertFromResultSet(ResultSet resultSet) throws SQLException {
        ScriptMonitorManager monitor = new ScriptMonitorManager();
        monitor.id = resultSet.getLong(1);
        return monitor;
    }

    public String getScriptNumber() {
        return this.scriptNumber;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getScriptModule() {
        return this.scriptModule;
    }

    public long getId() {
        return this.id;
    }

    public Long getAllCount() {
        return this.allCount;
    }
}

