/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.monitor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ScriptPlugin
implements Serializable {
    private static final String ENTITY_NAME = "ide_pluginscript";
    private String scriptId;
    private String scriptName;
    private String scriptNumber;
    private String scriptModule;
    private String scriptPath;
    private String scripttype;
    private String bizunitId;
    private String bizappId;

    public static List<ScriptPlugin> loadAllScript() {
        QFilter[] qFilters = new QFilter("enginetype", "=", (Object)"1").toArray();
        String selectProperties = "id, txt_scriptname, txt_scriptnumber, scriptmodule, classname, bizunitid, bizappid, cbox_script_type, enginetype";
        Map pluginscripts = BusinessDataServiceHelper.loadFromCache((String)ENTITY_NAME, (String)selectProperties, (QFilter[])qFilters);
        return pluginscripts.values().stream().map(ScriptPlugin::convertFromDynamicObject).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static Optional<ScriptPlugin> loadScript(String scriptPath) {
        QFilter[] qFilters = new QFilter("enginetype", "=", (Object)"1").and(new QFilter("classname", "=", (Object)scriptPath)).toArray();
        String selectProperties = "id, txt_scriptname, txt_scriptnumber, scriptmodule, classname, bizunitid, bizappid, cbox_script_type, enginetype";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (String)selectProperties, (QFilter[])qFilters);
        return ScriptPlugin.convertFromDynamicObject(dynamicObject);
    }

    public static Optional<ScriptPlugin> convertFromDynamicObject(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return Optional.empty();
        }
        ScriptPlugin plugin = new ScriptPlugin();
        plugin.scriptId = dynamicObject.getPkValue().toString();
        plugin.scriptName = dynamicObject.getString("txt_scriptname");
        plugin.scriptNumber = dynamicObject.getString("txt_scriptnumber");
        plugin.scriptModule = dynamicObject.getString("scriptmodule");
        plugin.scriptPath = dynamicObject.getString("classname");
        plugin.scripttype = dynamicObject.getString("cbox_script_type");
        plugin.bizappId = dynamicObject.getString("bizappid");
        plugin.bizunitId = dynamicObject.getString("bizunitid");
        return Optional.of(plugin);
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getScriptNumber() {
        return this.scriptNumber;
    }

    public String getScriptModule() {
        return this.scriptModule;
    }

    public String getBizunitId() {
        return this.bizunitId;
    }

    public String getBizappId() {
        return this.bizappId;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getScripttype() {
        return this.scripttype;
    }
}

