/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.kingscript.KingScriptPluginType;
import kd.bos.entity.EntryType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.kingscript.console.monitor.ScriptMonitorManager;
import kd.bos.kingscript.console.monitor.ScriptPlugin;
import kd.bos.kingscript.console.plugin.KingScriptTreeViewHelper;
import kd.bos.list.ListShowParameter;

public class KingScriptEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final String BOS_PROJECTNAME = "bos-kingscript-console";
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_SEARCH_PATH = "searchscript";
    private static final String CACHEID_TREE_NODES = "nodes";
    private static final String CACHEID_CURR_NODE = "currnode";
    private static final String CACHEID_CONVERT_PATHS = "paths";
    private List<ScriptPlugin> scriptPlugins;

    public void initialize() {
        super.initialize();
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"tbar_main"});
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH_PATH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("level_control".equals(itemKey)) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("kingscript_level_control");
            showParameter.setShowTitle(false);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_PATH, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearchByBill(searchText);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String scriptnumber = (String)this.getModel().getValue("scriptnumber", rowIndex);
        Optional<ScriptPlugin> pluginOptional = this.getScriptCache().stream().filter(x -> x.getScriptNumber().equals(scriptnumber)).findFirst();
        if (!pluginOptional.isPresent()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef, \u672a\u627e\u5230\u8be5\u811a\u672c\u4fe1\u606f", (String)"KingScriptEdit_0", (String)BOS_PROJECTNAME, (Object[])new Object[0]));
            return;
        }
        String scriptId = pluginOptional.get().getScriptId();
        Optional<ScriptMonitorManager> monitorOptional = ScriptMonitorManager.load(scriptId);
        ScriptMonitorManager scriptMonitorManager = monitorOptional.orElseGet(() -> ScriptMonitorManager.add(scriptId));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("kingscript_monitor");
        showParameter.setPkId((Object)scriptMonitorManager.getId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeNode rootNode = this.buildTreeNodes();
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
        tView.addNode(rootNode);
        tView.focusNode(rootNode);
    }

    public void afterCreateNewData(EventObject e) {
        KingScriptPluginType[] values;
        super.afterCreateNewData(e);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        for (KingScriptPluginType type : values = KingScriptPluginType.values()) {
            comboItems.add(new ComboItem(new LocaleString(type.getDisplayName()), type.getValue()));
        }
        ComboEdit typeCombo = (ComboEdit)this.getControl("scripttype");
        typeCombo.setComboItems(comboItems);
        List<ScriptPlugin> allScript = ScriptPlugin.loadAllScript();
        this.putScriptCache(allScript);
        this.doSearchByNodeId(allScript, "");
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId;
        String newNodeId = (String)e.getNodeId();
        if (newNodeId.equals(currNodeId = this.getPageCache().get(CACHEID_CURR_NODE))) {
            return;
        }
        List<ScriptPlugin> scriptPlugins = this.getScriptCache();
        this.doSearchByNodeId(scriptPlugins, newNodeId);
        this.getPageCache().put(CACHEID_CURR_NODE, newNodeId);
    }

    private TreeNode buildTreeNodes() {
        KingScriptTreeViewHelper bizAppTreeBuilder = new KingScriptTreeViewHelper();
        bizAppTreeBuilder.setRuntime(true);
        TreeNode root = bizAppTreeBuilder.buildTree();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"BizAppTreeBuilder_0", (String)BOS_PROJECTNAME, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        String json = SerializationUtils.toJsonString((Object)bizAppTreeBuilder);
        this.getPageCache().put(CACHEID_TREE_NODES, json);
        return root;
    }

    private void putScriptCache(List<ScriptPlugin> scripts) {
        String pathsJsonString = SerializationUtils.toJsonString(scripts);
        this.getPageCache().put(CACHEID_CONVERT_PATHS, pathsJsonString);
        this.scriptPlugins = scripts;
    }

    private List<ScriptPlugin> getScriptCache() {
        if (this.scriptPlugins != null) {
            return this.scriptPlugins;
        }
        String pathsJsonString = this.getPageCache().get(CACHEID_CONVERT_PATHS);
        this.scriptPlugins = StringUtils.isBlank((CharSequence)pathsJsonString) ? new ArrayList<ScriptPlugin>() : SerializationUtils.fromJsonStringToList((String)pathsJsonString, ScriptPlugin.class);
        return this.scriptPlugins;
    }

    private void doSearchByNodeId(List<ScriptPlugin> scriptPlugins, String nodedId) {
        ArrayList<ScriptPlugin> myScriptPlugins = new ArrayList<ScriptPlugin>();
        if (StringUtils.isBlank((CharSequence)nodedId)) {
            myScriptPlugins.addAll(scriptPlugins);
        } else {
            String rootNodeJson = this.getPageCache().get(CACHEID_TREE_NODES);
            KingScriptTreeViewHelper bizAppTreeBuilder = (KingScriptTreeViewHelper)SerializationUtils.fromJsonString((String)rootNodeJson, KingScriptTreeViewHelper.class);
            TreeNode rootNode = bizAppTreeBuilder.getRootNode();
            if (rootNode.getId().equals(nodedId)) {
                myScriptPlugins.addAll(scriptPlugins);
            } else {
                TreeNode cloudNode = null;
                for (TreeNode node : rootNode.getChildren()) {
                    if (!node.getId().equals(nodedId)) continue;
                    cloudNode = node;
                    break;
                }
                HashSet<String> bizAppIds = new HashSet<String>();
                if (cloudNode != null) {
                    if (cloudNode.getChildren() != null) {
                        for (TreeNode bizAppNode : cloudNode.getChildren()) {
                            bizAppIds.add(bizAppNode.getId());
                            bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(bizAppNode.getId()));
                        }
                    }
                } else {
                    bizAppIds.add(nodedId);
                    bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(nodedId));
                }
                for (ScriptPlugin scriptPlugin : scriptPlugins) {
                    if (!bizAppIds.contains(scriptPlugin.getBizappId())) continue;
                    myScriptPlugins.add(scriptPlugin);
                }
            }
        }
        this.refreshEntryGrid(myScriptPlugins);
    }

    private void refreshEntryGrid(List<ScriptPlugin> scriptPlugins) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_ENTITY);
        int seq = 1;
        for (ScriptPlugin scriptPlugin : scriptPlugins) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("seq", (Object)seq);
            row.set("scriptmodule", (Object)scriptPlugin.getScriptModule());
            row.set("scriptnumber", (Object)scriptPlugin.getScriptNumber());
            row.set("scriptname", (Object)scriptPlugin.getScriptName());
            row.set("scripttype", (Object)scriptPlugin.getScripttype());
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private void doSearchByBill(String searchText) {
        List<ScriptPlugin> scriptPlugins = this.getScriptCache();
        ArrayList<ScriptPlugin> myScriptPlugins = new ArrayList<ScriptPlugin>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            myScriptPlugins.addAll(scriptPlugins);
        } else {
            for (ScriptPlugin scriptPlugin : scriptPlugins) {
                if (!this.checkPathSourceAndTarget(scriptPlugin, searchText)) continue;
                myScriptPlugins.add(scriptPlugin);
            }
        }
        this.refreshEntryGrid(myScriptPlugins);
    }

    private boolean checkPathSourceAndTarget(ScriptPlugin scriptPlugin, String searchText) {
        return StringUtils.isNotBlank((CharSequence)scriptPlugin.getScriptNumber()) && scriptPlugin.getScriptNumber().contains(searchText) || StringUtils.isNotBlank((CharSequence)scriptPlugin.getScriptName()) && scriptPlugin.getScriptName().contains(searchText);
    }
}

