/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.plugin;

import dm.jdbc.util.IDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.tenant.TenantInfo;
import org.apache.commons.collections4.CollectionUtils;

public class KingScriptLevelControlEdit
extends AbstractBillPlugIn {
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        String billno = IDGenerator.generateStrId((int)20);
        this.getModel().setValue(((BillEntityType)this.getModel().getDataEntityType()).getBillNo(), (Object)billno);
    }

    private void addControlForTenant() {
        List tenantInfos = AccountUtils.getAllTenantsByCurrentEnv();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(tenantInfos.size());
        for (TenantInfo tenantInfo : tenantInfos) {
            ComboItem blankItem = new ComboItem();
            blankItem.setValue(tenantInfo.getId());
            blankItem.setCaption(new LocaleString(tenantInfo.getName()));
            comboItems.add(blankItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("tenant");
        comboEdit.setComboItems(comboItems);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("script_select".equals(evt.getItemKey())) {
            this.scriptSelect();
        }
    }

    private void scriptSelect() {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setBillFormId("ide_pluginscript");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(true);
        para.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        para.getOpenStyle().setInlineStyleCss(css);
        para.setShowTitle(false);
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.setFilter(new QFilter("enginetype", "=", (Object)Character.valueOf('1')));
        para.setListFilterParameter(filterParameter);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "script_append"));
        this.getView().showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equalsIgnoreCase("script_append")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.appendEntry(rows);
        }
    }

    private void appendEntry(ListSelectedRowCollection rows) {
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            ArrayList<ListSelectedRow> appendRows = new ArrayList<ListSelectedRow>();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_script");
            for (ListSelectedRow row : rows) {
                boolean isExist = false;
                for (DynamicObject dynamicObject : entryEntity) {
                    String id = dynamicObject.getString("script_basedata.id");
                    if (!id.equals(row.getPrimaryKeyValue())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                appendRows.add(row);
            }
            if (appendRows.isEmpty()) {
                return;
            }
            int[] entryScripts = this.getModel().batchCreateNewEntryRow("entry_script", appendRows.size());
            int startIndex = entryScripts[0];
            for (int i = 0; i < appendRows.size(); ++i) {
                ListSelectedRow row = (ListSelectedRow)appendRows.get(i);
                this.getModel().setValue("script_basedata", row.getPrimaryKeyValue(), startIndex + i);
            }
        }
    }
}

