/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.console.plugin;

import java.util.EventObject;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.kingscript.console.control.LevelControl;
import kd.bos.kingscript.console.control.cache.ScriptPathSecurityCache;
import kd.bos.kingscript.console.control.level.LevelControlEnum;
import kd.bos.kingscript.console.monitor.ScriptPlugin;
import kd.bos.servicehelper.util.QueryPluginUtil;

public class KingScriptMonitorEdit
extends AbstractBillPlugIn {
    public void afterLoadData(EventObject e) {
        DynamicObject scriptPluginObj = (DynamicObject)this.getModel().getValue("script_basedata");
        Optional<ScriptPlugin> scriptPlugin = ScriptPlugin.convertFromDynamicObject(scriptPluginObj);
        if (scriptPlugin.isPresent()) {
            Set entityNumbers;
            LevelControl levelControl = ScriptPathSecurityCache.getTimeoutControl(scriptPlugin.get().getScriptPath());
            if (levelControl != null) {
                if (!levelControl.getControlLevel().equals(LevelControlEnum.MODULE.getLevel())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"control_module"});
                }
                this.getModel().batchCreateNewEntryRow("entry_script_control", 1);
                this.getModel().setValue("control_name", (Object)levelControl.getControlName(), 0);
                this.getModel().setValue("control_level", (Object)levelControl.getControlLevel(), 0);
                this.getModel().setValue("control_module", (Object)levelControl.getModule(), 0);
                this.getModel().setValue("limit_runtime", (Object)levelControl.getLimitRuntime(), 0);
                this.getModel().setDataChanged(false);
            }
            if ((entityNumbers = new QueryPluginUtil().queryScriptPluginLinkForms(scriptPlugin.get().getScriptPath(), scriptPlugin.get().getScripttype())) != null && entityNumbers.size() > 0) {
                this.getModel().batchCreateNewEntryRow("entry_relate_entity", entityNumbers.size());
                int row = 0;
                for (String entityNumber : entityNumbers) {
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    String entityType = dataEntityType instanceof BasedataEntityType ? ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"BizPageNewGuidePlugin_7", (String)"bos-devportal-plugin", (Object[])new Object[0]) : (dataEntityType instanceof BillEntityType ? ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"BizAppDeployTreePlugin_18", (String)"bos-devportal-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355", (String)"BizAppMenuPlugin_7", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                    this.getModel().setValue("relate_entitynumber", (Object)entityNumber, row);
                    this.getModel().setValue("relate_entitytype", (Object)entityType, row);
                    this.getModel().setDataChanged(false);
                    ++row;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("viewscript".equals(evt.getItemKey())) {
            if (!Plugin.enableRunKingScript()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5f00\u53d1\u5e73\u53f0\u672a\u542f\u7528\uff0c\u6682\u4e0d\u652f\u6301\u7f16\u8f91\u3002", (String)"PluginsPlugin_11", (String)"bos-designer-plugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject scriptPluginObj = (DynamicObject)this.getModel().getValue("script_basedata");
            Optional<ScriptPlugin> scriptPlugin = ScriptPlugin.convertFromDynamicObject(scriptPluginObj);
            if (scriptPlugin.isPresent()) {
                FormShowParameter param = new FormShowParameter();
                param.setFormId("ide_register_ts_plugin");
                param.setCustomParam("bizscriptid", (Object)scriptPlugin.get().getScriptId());
                param.setCustomParam("isOnlyViewEditor", (Object)"true");
                param.getOpenStyle().setShowType(ShowType.NewWindow);
                param.setStatus(OperationStatus.VIEW);
                this.getView().showForm(param);
            }
        }
    }
}

