/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.deploy;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.deploy.DeployParameter;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.metadata.deploy.MetaDeploy;
import kd.bos.service.metadata.IMetadataDeployService;
import kd.bos.service.metadata.MetadataDeployFile;
import kd.bos.service.metadata.MetadataDeployResult;
import kd.sdk.kingscript.lib.crypto.meta.MetaCryptoUtil;
import kd.sdk.kingscript.lib.version.ScriptVersionManager;

public class KingScriptDeployServiceImpl
implements IMetadataDeployService {
    private static final String CLASSNAME = "classname";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public MetadataDeployResult deploy(List<MetadataDeployFile> fileList) {
        MetadataDeployResult deployResult = new MetadataDeployResult();
        if (fileList.size() > 0) {
            try {
                DynamicObject obj;
                String className;
                MetadataDeployFile deployFile = fileList.get(0);
                byte[] decrypt = MetaCryptoUtil.decrypt((byte[])deployFile.getContentBytes());
                String decryptContent = new String(decrypt, StandardCharsets.UTF_8);
                DeployParameter param = new DeployParameter();
                param.setAppGroup(deployFile.getAppGroup());
                MetaDeploy metaDeploy = new MetaDeploy(param);
                metaDeploy.deployScript(decryptContent);
                DeployScript deployNew = DeployScript.create((String)decryptContent);
                List designDatas = deployNew.getScripts();
                if (!designDatas.isEmpty() && StringUtils.isNotBlank((CharSequence)(className = (obj = (DynamicObject)designDatas.get(0)).getString(CLASSNAME)))) {
                    Date modifyDate = obj.getDate("modifydate");
                    long version = System.currentTimeMillis();
                    if (modifyDate != null) {
                        version = this.dateFormat.parse(this.dateFormat.format(modifyDate)).getTime();
                    }
                    ScriptVersionManager.setVersion((String)className, (String)String.valueOf(version), null);
                }
            }
            catch (Exception e) {
                deployResult.setSuccess(false);
                deployResult.setErrorInfo(e.getMessage());
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                deployResult.setLog(sw.toString());
            }
        }
        return deployResult;
    }
}

