/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.openapi.debug;

import kd.bos.kingscript.console.RequestContextChangeException;
import kd.bos.kingscript.console.RequestContextChanged;
import kd.bos.kingscript.openapi.debug.BreakpointData;
import kd.bos.kingscript.openapi.debug.DebuggerProtocolError;
import kd.bos.kingscript.openapi.debug.ProtocolData;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.script.ProjectInitializerManager;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerDisable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerEnable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerEvaluateOnCallFrame;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGo;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerKeepAlive;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerPause;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerPrepare;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerReady;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerRemoveBreakpoint;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerResume;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointByUrl;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointsActive;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetPauseOnExceptions;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetVariableValue;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerStepInto;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerStepOut;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerStepOver;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeEnable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeGetProperties;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeRunIfWaitingForDebugger;
import kd.sdk.kingscript.debug.client.inspect.domain.type.RuntimeCallFrame;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.debug.endpoint.DebugServerEndpoint;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.log.Logs;
import org.slf4j.Logger;

@ApiController(value="kingscript-debugger-protocol", desc="kingscript-debugger-protocol")
public class DebuggerProtocolService {
    private static final Logger logger = Logs.getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/keepAlive")
    public CustomApiResult<ProtocolData> keepAlive(@ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId) {
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerKeepAlive.create());
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, -1L, -1L));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/prepare")
    public CustomApiResult<ProtocolData> prepare(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId, @ApiParam(value="\u5f15\u64ce\u540d\u79f0") @ApiParam(value="\u5f15\u64ce\u540d\u79f0") String enginePoolName, String ... scriptPaths) {
        String message;
        try {
            message = DebuggerPrepare.createForApi((long)cid, (String)enginePoolName, (String[])scriptPaths);
        }
        catch (Exception e) {
            return CustomApiResult.fail((String)"-1", (String)"Error parsing arguments");
        }
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, message);
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/onPrepared")
    public CustomApiResult<ProtocolData> onPrepared(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId) {
        if (!DebugInfoRegistry.get().hasRegistered(debugId)) {
            String errorMessage = String.format("Request not allowed for method %s, Debugger.prepare is not completed.", "onPrepared");
            return CustomApiResult.fail((String)"-1", (String)errorMessage);
        }
        long _cid = cid;
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, RuntimeEnable.createForApi((long)_cid++));
            debugServer.request(debugId, DebuggerEnable.createForApi((long)_cid++));
            debugServer.request(debugId, RuntimeRunIfWaitingForDebugger.createForApi((long)_cid++));
            debugServer.request(debugId, DebuggerReady.createForApi((long)_cid));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, _cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/setBreakpointData")
    public CustomApiResult<ProtocolData> setBreakpointData(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId, @ApiParam(value="\u65ad\u70b9\u4fe1\u606f") @ApiParam(value="\u65ad\u70b9\u4fe1\u606f") BreakpointData breakpointData) {
        long _cid = cid;
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            String setBreakpointMessage = DebuggerSetBreakpointByUrl.createForApi((long)_cid++, (String)breakpointData.getUrl(), (long)breakpointData.getLineNumber(), (long)breakpointData.getColumnNumber());
            debugServer.request(debugId, setBreakpointMessage);
            debugServer.request(debugId, DebuggerSetBreakpointsActive.createForApi((long)_cid++, (boolean)true));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, _cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/removeBreakpoint")
    public CustomApiResult<ProtocolData> removeBreakpoint(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId, @ApiParam(value="\u65ad\u70b9\u4fe1\u606f") @ApiParam(value="\u65ad\u70b9\u4fe1\u606f") String breakpointId) {
        long _cid = cid;
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            String message = DebuggerRemoveBreakpoint.createForApi((long)_cid++, (String)breakpointId);
            debugServer.request(debugId, message);
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, _cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/onScriptParsed")
    public CustomApiResult<ProtocolData> onScriptParsed(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId) {
        long _cid = cid;
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerGo.createForApi((long)_cid));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, _cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/getProperties")
    public CustomApiResult<ProtocolData> getProperties(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId, @ApiParam(value="\u53d8\u91cfiD") @ApiParam(value="\u53d8\u91cfiD") String objectId, @ApiParam(value="ownProperties") @ApiParam(value="ownProperties") boolean ownProperties, @ApiParam(value="generatePreview") @ApiParam(value="generatePreview") boolean generatePreview, @ApiParam(value="accessorPropertiesOnly") @ApiParam(value="accessorPropertiesOnly") boolean accessorPropertiesOnly, @ApiParam(value="nonIndexedPropertiesOnly") @ApiParam(value="nonIndexedPropertiesOnly") boolean nonIndexedPropertiesOnly) {
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, RuntimeGetProperties.createForApi((long)cid, (String)objectId, (boolean)accessorPropertiesOnly, (boolean)generatePreview, (boolean)nonIndexedPropertiesOnly, (boolean)ownProperties));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/setVariableValue")
    public CustomApiResult<ProtocolData> setVariableValue(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId, @ApiParam(value="scopeNumber") @ApiParam(value="scopeNumber") int scopeNumber, @ApiParam(value="variableName") @ApiParam(value="variableName") String variableName, @ApiParam(value="newValue") @ApiParam(value="newValue") RuntimeCallFrame newValue, @ApiParam(value="callFrameId") @ApiParam(value="callFrameId") String callFrameId) {
        long _cid = cid;
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerSetVariableValue.createForApi((long)_cid, (int)scopeNumber, (String)variableName, (RuntimeCallFrame)newValue, (String)callFrameId));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, _cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/evaluateOnCallFrame")
    public CustomApiResult<ProtocolData> evaluateOnCallFrame(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId, @ApiParam(value="expression") @ApiParam(value="expression") String expression, @ApiParam(value="callFrameId") @ApiParam(value="callFrameId") String callFrameId, @ApiParam(value="silent") @ApiParam(value="silent") boolean silent, @ApiParam(value="returnByValue") @ApiParam(value="returnByValue") boolean returnByValue, @ApiParam(value="generatePreview") @ApiParam(value="generatePreview") boolean generatePreview, @ApiParam(value="includeCommandLineAPI") @ApiParam(value="includeCommandLineAPI") boolean includeCommandLineAPI, @ApiParam(value="objectGroup") @ApiParam(value="objectGroup") String objectGroup) {
        long _cid = cid;
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerEvaluateOnCallFrame.createForApi((long)_cid, (String)expression, (String)callFrameId, (boolean)silent, (boolean)returnByValue, (boolean)generatePreview, (boolean)includeCommandLineAPI, (String)objectGroup));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, _cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/setPauseOnExceptions")
    public CustomApiResult<ProtocolData> setPauseOnExceptions(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId, @ApiParam(value="state") @ApiParam(value="state") String state) {
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerSetPauseOnExceptions.createForApi((long)cid, (String)state));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/stepOver")
    public CustomApiResult<ProtocolData> stepOver(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId) {
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerStepOver.createForApi((long)cid));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/stepInto")
    public CustomApiResult<ProtocolData> stepInto(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId) {
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerStepInto.createForApi((long)cid));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/stepOut")
    public CustomApiResult<ProtocolData> stepOut(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId) {
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerStepOut.createForApi((long)cid));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/pause")
    public CustomApiResult<ProtocolData> pause(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId) {
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerPause.createForApi((long)cid));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/resume")
    public CustomApiResult<ProtocolData> resume(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId) {
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerResume.createForApi((long)cid));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="kingscript/debugger/disable")
    public CustomApiResult<ProtocolData> disable(@ApiParam(value="\u5ba2\u6237\u7aefID") @ApiParam(value="\u5ba2\u6237\u7aefID") long cid, @ApiParam(value="\u8c03\u8bd5ID") @ApiParam(value="\u8c03\u8bd5ID") String debugId) {
        try (RequestContextChanged ignored = RequestContextChanged.newInstanceForVSCode();){
            DebugServerEndpoint debugServer = DebugServerEndpoint.createForVscode();
            debugServer.request(debugId, DebuggerDisable.createForApi((long)cid));
            CustomApiResult customApiResult = CustomApiResult.success((Object)new ProtocolData(debugId, cid, cid));
            return customApiResult;
        }
        catch (RequestContextChangeException e) {
            logger.warn(e.getMessage());
            return CustomApiResult.fail((String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrCode(), (String)DebuggerProtocolError.REQUESTCONTEXT_CHANGE_ERROR.getErrMessage());
        }
    }

    @ApiPostMapping(value="kingscript/debugger/mockRunScript")
    public CustomApiResult<Object> mockRunScript(@ApiParam(value="\u811a\u672c\u8def\u5f84") @ApiParam(value="\u811a\u672c\u8def\u5f84") String scriptPath) {
        KingScriptEngine scriptEngine = ProjectInitializerManager.getEngineAutoDebug((String)scriptPath);
        if (scriptEngine.isDebuggable()) {
            System.out.println("-------\u8c03\u8bd5\u5f15\u64ce\u6267\u884c-------");
        }
        scriptEngine.evalPath(scriptPath);
        System.out.println("-------\u8c03\u8bd5\u5f15\u64ce\u7ed3\u675f-------");
        return CustomApiResult.success(null);
    }
}

