/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.openapi.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.pushservice.WebSocketIdReader;
import kd.sdk.kingscript.debug.client.messagepusher.WsMessagePusher;
import org.apache.commons.lang.StringUtils;

public class VSCodePushMessageHandle
implements WsMessagePusher {
    Log logger = LogFactory.getLog(VSCodePushMessageHandle.class);

    public boolean isConnectionAlive(String debugId) {
        if (!debugId.startsWith("vscode")) {
            return true;
        }
        String identifytype = debugId.substring(7);
        String sessionId = identifytype.substring(4, identifytype.length() - 5);
        List socketIds = WebSocketIdReader.getWebSocketIds((String)RequestContext.get().getAccountId(), (String)sessionId);
        if (socketIds == null || socketIds.isEmpty()) {
            return false;
        }
        return socketIds.contains(identifytype);
    }

    public void pushMessage(String s) {
        this.logger.debug(String.format("ScriptPushMessageHandle\u6536\u5230\u6d88\u606f\uff1a%s", s));
        if (StringUtils.isBlank((String)s)) {
            return;
        }
        Map msg = (Map)SerializationUtils.fromJsonString((String)s, Map.class);
        String debugId = (String)msg.get("debugId");
        if (!debugId.startsWith("vscode")) {
            this.logger.error("VSCodePushMessageHandle.pushMessage error, debugId: " + debugId);
            return;
        }
        String identifytype = debugId.substring(7);
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(identifytype);
        PushMessage message = new PushMessage(PushMessageRange.RootPage, identifytype, (Object)s);
        PushMessagePublisher.sendPushMessage(list, (PushMessage)message);
    }
}

