/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.openapi.development;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dts.lock.Lock;
import kd.bos.dts.lock.LockFactory;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.kingscript.openapi.development.helper.ScriptDBHelper;
import kd.bos.kingscript.openapi.development.util.ZipDirectory;
import kd.bos.metadata.deploy.CustomMetaDeploy;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.metadata.deploy.DeployScriptBinder;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.dynplugin.DynamicPluginBindDesignMeta;
import kd.bos.metadata.dynplugin.DynamicPluginBindDesignMeta_Lang;
import kd.bos.metadata.dynplugin.DynamicPluginDesignMeta;
import kd.bos.metadata.dynplugin.DynamicPluginDesignMeta_Lang;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.sdk.kingscript.lib.crypto.meta.MetaCryptoUtil;
import kd.sdk.kingscript.log.Logs;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApiController(value="kingscript-publish", desc="kingscript\u811a\u672c-\u53d1\u5e03")
public class PublishService {
    private static final Logger logger = Logs.getLogger();
    private static final String UPPER_CASE_NUMBER = "Number";

    @ApiPostMapping(value="kingscript/dev/publish/xml")
    public CustomApiResult<String> publishXML(@ApiParam(value="\u7c7b\u578b:0-\u6309\u5e94\u7528 1-\u6309\u811a\u672c", required=true) @ApiParam(value="\u7c7b\u578b:0-\u6309\u5e94\u7528 1-\u6309\u811a\u672c", required=true) int type, @ApiParam(value="\u5e94\u7528\u6807\u8bc6") @ApiParam(value="\u5e94\u7528\u6807\u8bc6") String appId, @ApiParam(value="\u811a\u672c\u8def\u5f84") @ApiParam(value="\u811a\u672c\u8def\u5f84") List<String> scripts) throws IOException {
        DynamicObject[] objects;
        List<Object> scriptIds = new ArrayList();
        if (type == 0) {
            scriptIds = ScriptDBHelper.loadPrimaryScriptByBizAppId(this.convertPkIdByApp(appId));
        }
        if (type == 1) {
            scriptIds = ScriptDBHelper.loadPrimaryScriptByPaths(scripts);
        }
        if (CollectionUtils.isEmpty(scriptIds)) {
            return CustomApiResult.fail((String)"-1", (String)"No scripts found !");
        }
        ArrayList<DeployFile> deployFileList = new ArrayList<DeployFile>(10);
        for (DynamicObject o : objects = BusinessDataReader.load((Object[])scriptIds.toArray(new String[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((URL)DeployScriptBinder.class.getResource("/SystemEntity/ScriptEntity.xml")), (Boolean)false)) {
            DeployScript deploy = new DeployScript();
            String enginetype = o.getString("enginetype");
            String suffix = "1".equals(enginetype) ? ".ksc" : ".ks";
            deploy.getScripts().add(o);
            deployFileList.add(deploy.toDeployFile(o.getString(UPPER_CASE_NUMBER).toLowerCase() + suffix));
        }
        HashMap tempMap = new HashMap();
        HashMap<String, byte[]> filePathXmls = new HashMap<String, byte[]>();
        deployFileList.forEach(deployFile -> {
            String fileName = deployFile.getFileName();
            String uniqueFileName = this.getUniqueFileName(tempMap, fileName);
            String fileContent = deployFile.getFileContent();
            if (StringUtils.isNotBlank((CharSequence)fileContent) && StringUtils.endsWith((CharSequence)fileName, (CharSequence)".ksc")) {
                byte[] fileBytes = MetaCryptoUtil.encrypt((byte[])fileContent.getBytes(StandardCharsets.UTF_8));
                tempMap.put(uniqueFileName, fileContent);
                filePathXmls.put(uniqueFileName, fileBytes);
            }
        });
        String zipUrl = this.createZipAndUpload(filePathXmls, appId);
        zipUrl = EncreptSessionUtils.encryptSession((String)zipUrl);
        return CustomApiResult.success((Object)zipUrl);
    }

    private String getUniqueFileName(Map<String, String> filePathXmls, String originFileName) {
        int index = 1;
        String fileName = originFileName;
        while (filePathXmls.containsKey(fileName)) {
            int dotIndex = fileName.lastIndexOf(46);
            String name = fileName.substring(0, dotIndex);
            String extension = fileName.substring(dotIndex);
            fileName = name + "(" + index + ")" + extension;
            ++index;
        }
        return fileName;
    }

    @ApiPostMapping(value="kingscript/dev/publish/dynplugxml")
    public CustomApiResult<List<String>> publishDynpluginXML(@ApiParam(value="\u811a\u672c\u8def\u5f84") @ApiParam(value="\u811a\u672c\u8def\u5f84") List<String> scripts) {
        List<Object> fileUrls = new ArrayList(2);
        DynamicObject[] dynamicPlugins = BusinessDataServiceHelper.load((String)"bos_dynplugin", (String)"number", (QFilter[])new QFilter("number", "in", scripts).toArray());
        if (dynamicPlugins != null && dynamicPlugins.length > 0) {
            List<String> dynamicPluginIds = Arrays.stream(dynamicPlugins).map(x -> x.getPkValue().toString()).collect(Collectors.toList());
            CustomMetaDeploy dynamicPluginMetaDeploy = this.createDynPluginFileUtil();
            HashMap dynamicPluginExportResult = new HashMap(4);
            String dynamicPluginFileUrl = dynamicPluginMetaDeploy.exportUrlFile(dynamicPluginIds.toArray(new String[0]), dynamicPluginExportResult);
            fileUrls.add(dynamicPluginFileUrl);
            DynamicObject[] dynamicPluginBinds = BusinessDataServiceHelper.load((String)"bos_dynpluginbind", (String)"objecttype", (QFilter[])new QFilter("dynplugin", "in", dynamicPluginIds.stream().map(Long::parseLong).collect(Collectors.toList())).toArray());
            if (dynamicPluginBinds != null && dynamicPluginBinds.length > 0) {
                List<String> dynamicPluginBindIds = Arrays.stream(dynamicPluginBinds).map(x -> x.getPkValue().toString()).collect(Collectors.toList());
                CustomMetaDeploy dynamicPluginBindMetaDeploy = this.createDynPluginBindFileUtil();
                HashMap dynamicPluginBindExportResult = new HashMap(4);
                String dynamicPluginBindFileUrl = dynamicPluginBindMetaDeploy.exportUrlFile(dynamicPluginBindIds.toArray(new String[0]), dynamicPluginBindExportResult);
                fileUrls.add(dynamicPluginBindFileUrl);
            }
        }
        fileUrls = fileUrls.stream().map(EncreptSessionUtils::encryptSession).collect(Collectors.toList());
        return CustomApiResult.success(fileUrls);
    }

    protected CustomMetaDeploy createDynPluginFileUtil() {
        CustomMetaDeploy fileUtil = null;
        IDataEntityType designMetaType = OrmUtils.getDataEntityType(DynamicPluginDesignMeta.class);
        IDataEntityType designMetaTypeLang = OrmUtils.getDataEntityType(DynamicPluginDesignMeta_Lang.class);
        fileUtil = new CustomMetaDeploy(designMetaType, designMetaTypeLang, "dynplug");
        return fileUtil;
    }

    protected CustomMetaDeploy createDynPluginBindFileUtil() {
        CustomMetaDeploy fileUtil = null;
        IDataEntityType designMetaType = OrmUtils.getDataEntityType(DynamicPluginBindDesignMeta.class);
        IDataEntityType designMetaTypeLang = OrmUtils.getDataEntityType(DynamicPluginBindDesignMeta_Lang.class);
        fileUtil = new CustomMetaDeploy(designMetaType, designMetaTypeLang, "dynplugbind");
        return fileUtil;
    }

    private String convertPkIdByApp(String appId) {
        return AppReader.getAppIdByNumber((String)appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createZipAndUpload(Map<String, byte[]> xmls, String appNumber) throws IOException {
        File zipFile;
        String zipUrl;
        block55: {
            Throwable throwable;
            Lock lock;
            zipUrl = "";
            File dataModelFolder = null;
            zipFile = null;
            try {
                block51: {
                    String string;
                    block52: {
                        block53: {
                            block48: {
                                String string2;
                                block49: {
                                    block50: {
                                        block45: {
                                            String string3;
                                            block46: {
                                                block47: {
                                                    lock = LockFactory.create((String)"kingscript-publishsql-uploadzip");
                                                    throwable = null;
                                                    boolean isLock = lock.lock();
                                                    if (isLock) break block45;
                                                    string3 = zipUrl;
                                                    if (lock == null) break block46;
                                                    if (throwable == null) break block47;
                                                    try {
                                                        lock.close();
                                                    }
                                                    catch (Throwable throwable2) {
                                                        throwable.addSuppressed(throwable2);
                                                    }
                                                    break block46;
                                                }
                                                lock.close();
                                            }
                                            if (dataModelFolder != null) {
                                                FileUtils.deleteDirectory((File)dataModelFolder);
                                            }
                                            if (zipFile == null) return string3;
                                            if (!zipFile.exists()) return string3;
                                            if (zipFile.delete()) return string3;
                                            logger.error("Delete datamodel.zip fail.");
                                            return string3;
                                        }
                                        dataModelFolder = PublishService.createSaveDir("datamodel");
                                        if (!StringUtils.isBlank((CharSequence)appNumber)) break block48;
                                        logger.error("appNumber is empty " + appNumber);
                                        string2 = zipUrl;
                                        if (lock == null) break block49;
                                        if (throwable == null) break block50;
                                        try {
                                            lock.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        break block49;
                                    }
                                    lock.close();
                                }
                                if (dataModelFolder != null) {
                                    FileUtils.deleteDirectory((File)dataModelFolder);
                                }
                                if (zipFile == null) return string2;
                                if (!zipFile.exists()) return string2;
                                if (zipFile.delete()) return string2;
                                logger.error("Delete datamodel.zip fail.");
                                return string2;
                            }
                            AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appNumber);
                            if (appInfo != null) break block51;
                            logger.error("app is not found " + appNumber);
                            string = zipUrl;
                            if (lock == null) break block52;
                            if (throwable == null) break block53;
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            break block52;
                        }
                        lock.close();
                    }
                    if (dataModelFolder != null) {
                        FileUtils.deleteDirectory((File)dataModelFolder);
                    }
                    if (zipFile == null) return string;
                    if (!zipFile.exists()) return string;
                    if (zipFile.delete()) return string;
                    logger.error("Delete datamodel.zip fail.");
                    return string;
                }
                try {
                    AppInfo appInfoByNumber = AppMetadataCache.getAppInfoByNumber((String)appNumber);
                    String cloudNumber = appInfoByNumber.getCloudNum();
                    File appFolder = PublishService.createSaveDir("datamodel" + File.separator + cloudNumber + File.separator + "1.5" + File.separator + "main" + File.separator + appNumber + File.separator + "metadata");
                    for (Map.Entry<String, byte[]> entry : xmls.entrySet()) {
                        String scriptPath = entry.getKey();
                        byte[] scriptContent = entry.getValue();
                        PublishService.flushToLocal(scriptPath, new ByteArrayInputStream(scriptContent), appFolder);
                    }
                    zipFile = ZipDirectory.gen(dataModelFolder, "datamodel.zip");
                    try (FileInputStream zipStream = new FileInputStream(zipFile);){
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                        LocalDateTime now = LocalDateTime.now();
                        String fileName = "datamodel_" + now.format(formatter) + ".zip";
                        zipUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)zipStream, 5000);
                        break block54;
                    }
                    catch (FileNotFoundException e) {
                        logger.error("PublishService.createZipAndUpload-" + zipFile, (Throwable)e);
                    }
                    break block54;
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                if (dataModelFolder != null) {
                    FileUtils.deleteDirectory(dataModelFolder);
                }
                if (zipFile == null) throw throwable7;
                if (!zipFile.exists()) throw throwable7;
                if (zipFile.delete()) throw throwable7;
                logger.error("Delete datamodel.zip fail.");
                throw throwable7;
            }
            {
                block54: {
                    finally {
                        if (lock != null) {
                            if (throwable != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                lock.close();
                            }
                        }
                    }
                }
                if (dataModelFolder == null) break block55;
            }
            FileUtils.deleteDirectory((File)dataModelFolder);
        }
        if (zipFile == null) return zipUrl;
        if (!zipFile.exists()) return zipUrl;
        if (zipFile.delete()) return zipUrl;
        logger.error("Delete datamodel.zip fail.");
        return zipUrl;
    }

    private static File createSaveDir(String dirName) {
        String property = System.getProperty("user.home");
        String FILEPATH = kd.bos.util.FileUtils.cleanString((String)(property + File.separator + dirName));
        File saveDir = new File(FILEPATH);
        boolean mkdirsSuccess = true;
        if (!saveDir.exists()) {
            mkdirsSuccess = saveDir.mkdirs();
        }
        if (!mkdirsSuccess) {
            throw new KDBizException(new ErrorCode("", "Failed to create server temporary folder. Please check the server path permissions: " + FILEPATH), new Object[0]);
        }
        return saveDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String flushToLocal(String fileName, InputStream in, File saveDir) {
        File file = new File(saveDir, fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            int len;
            BufferedInputStream fis = new BufferedInputStream(in);
            byte[] buffer = new byte[8192];
            while ((len = fis.read(buffer)) != -1) {
                ((OutputStream)fos).write(buffer, 0, len);
            }
            String string = file.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("-1", "Exception occurred while writing XML to the metadata folder"), new Object[0]);
        }
        catch (Exception e) {
            logger.error("PublishService.flushToLocal-" + fileName, (Throwable)e);
            throw e;
        }
    }
}

