/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.openapi.development;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.tree.TreeNode;
import kd.bos.isv.ISVService;
import kd.bos.kingscript.console.plugin.KingScriptTreeViewHelper;
import kd.bos.kingscript.openapi.development.cache.ScriptCache;
import kd.bos.kingscript.openapi.development.helper.ScriptDBHelper;
import kd.bos.kingscript.openapi.development.model.SimpleScriptTreeNode;
import kd.bos.kingscript.openapi.development.util.SHA256Hasher;
import kd.bos.kingscript.vscode.DevPortalPermissionUtil;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.log.Logs;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;

@ApiController(value="kingscript-script", desc="kingscript\u811a\u672c")
public class ScriptService {
    private static final Logger logger = Logs.getLogger();
    private final KingScriptTreeViewHelper kingScriptTreeViewHelper = new KingScriptTreeViewHelper();
    private final ScriptCache scriptCache = ScriptCache.create();
    private final ScriptDBHelper scriptDBHelper = new ScriptDBHelper();

    @ApiPostMapping(value="kingscript/dev/search/tree")
    public CustomApiResult<List<SimpleScriptTreeNode>> searchTree(@ApiParam(value="\u5173\u6ce8\u5e94\u7528\u6807\u8bc6, \u7a7a\u5219\u8fd4\u56de\u6240\u6709") @ApiParam(value="\u5173\u6ce8\u5e94\u7528\u6807\u8bc6, \u7a7a\u5219\u8fd4\u56de\u6240\u6709") Set<String> followAppIds) {
        logger.info("Searching script tree for app IDs: {}", followAppIds);
        TreeNode projectNode = this.kingScriptTreeViewHelper.buildTree();
        SimpleScriptTreeNode scriptTreeNode = SimpleScriptTreeNode.convertFromTreeNode(projectNode, followAppIds);
        return CustomApiResult.success(scriptTreeNode.getChildren());
    }

    @ApiPostMapping(value="kingscript/dev/search/scripts")
    public CustomApiResult<Map<String, String>> searchScripts(@ApiParam(value="\u5e94\u7528\u7f16\u7801", required=true) @ApiParam(value="\u5e94\u7528\u7f16\u7801", required=true) String appId) {
        logger.info("Searching scripts for app ID: {}", (Object)appId);
        Map<String, String> result = ScriptDBHelper.loadScriptByBizAppId(this.convertAppId(appId));
        return CustomApiResult.success(result);
    }

    @ApiPostMapping(value="kingscript/dev/compare/scripts")
    public CustomApiResult<Map<String, String>> compareScripts(@ApiParam(value="\u7c7b\u578b:0-\u6309\u5e94\u7528 1-\u6309\u811a\u672c", required=true) @ApiParam(value="\u7c7b\u578b:0-\u6309\u5e94\u7528 1-\u6309\u811a\u672c", required=true) int type, @ApiParam(value="\u5e94\u7528\u7f16\u7801") @ApiParam(value="\u5e94\u7528\u7f16\u7801") String appId, @ApiParam(value="\u811a\u672c\u8def\u5f84") @ApiParam(value="\u811a\u672c\u8def\u5f84") List<String> scripts) {
        if (type == 0) {
            String app = this.convertAppId(appId);
            if (StringUtils.isBlank((CharSequence)app)) {
                return CustomApiResult.fail((String)"-1", (String)"appid did not exsit");
            }
            Map<String, String> result = this.scriptCache.getType(app, _appPkId -> {
                Map<String, String> scriptContexts = ScriptDBHelper.loadScriptByBizAppId(_appPkId);
                return scriptContexts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SHA256Hasher.hash((String)entry.getValue())));
            });
            return CustomApiResult.success(result);
        }
        if (type == 1) {
            Map<String, String> scriptContexts = ScriptDBHelper.loadScriptByScriptPaths(scripts);
            Map<String, String> result = scriptContexts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SHA256Hasher.hash((String)entry.getValue())));
            return CustomApiResult.success(result);
        }
        return CustomApiResult.fail((String)"-1", (String)"The parameter 'type' is invalid.");
    }

    @ApiPostMapping(value="kingscript/dev/push/scripts")
    public CustomApiResult<Boolean> pushScripts(@ApiParam(value="\u5e94\u7528\u6807\u8bc6", required=true) @ApiParam(value="\u5e94\u7528\u6807\u8bc6", required=true) String appId, @ApiParam(value="\u65b0\u589e\u811a\u672c") @ApiParam(value="\u65b0\u589e\u811a\u672c") Map<String, String> addScripts, @ApiParam(value="\u66f4\u65b0\u811a\u672c") @ApiParam(value="\u66f4\u65b0\u811a\u672c") Map<String, String> updateScripts, @ApiParam(value="\u5220\u9664\u811a\u672c") @ApiParam(value="\u5220\u9664\u811a\u672c") List<String> deleteScripts) {
        logger.info("Pushing scripts for app: {}", (Object)appId);
        this.pushScriptsInternal(appId, addScripts, updateScripts, deleteScripts, false);
        return CustomApiResult.success((Object)true);
    }

    @ApiPostMapping(value="kingscript/dev/push/scriptarr")
    public CustomApiResult<Boolean> pushScriptArr(@ApiParam(value="\u5e94\u7528\u6807\u8bc6", required=true) @ApiParam(value="\u5e94\u7528\u6807\u8bc6", required=true) String appId, @ApiParam(value="\u65b0\u589e\u811a\u672c") @ApiParam(value="\u65b0\u589e\u811a\u672c") List<Map<String, String>> addScripts, @ApiParam(value="\u66f4\u65b0\u811a\u672c") @ApiParam(value="\u66f4\u65b0\u811a\u672c") List<Map<String, String>> updateScripts, @ApiParam(value="\u5220\u9664\u811a\u672c") @ApiParam(value="\u5220\u9664\u811a\u672c") List<String> deleteScripts) {
        logger.info("Pushing script array for app: {}", (Object)appId);
        Map<String, String> addScriptMap = this.mergeScriptMaps(addScripts);
        Map<String, String> updateScriptMap = this.mergeScriptMaps(updateScripts);
        this.pushScriptsInternal(appId, addScriptMap, updateScriptMap, deleteScripts, false);
        return CustomApiResult.success((Object)true);
    }

    private Map<String, String> mergeScriptMaps(List<Map<String, String>> scriptMaps) {
        return scriptMaps.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
    }

    @Deprecated
    private void pushScriptsInternal(String appNumber, Map<String, String> addScripts, Map<String, String> updateScripts, List<String> deleteScripts, boolean isDecode) {
        logger.info("Executing pushScriptsInternal for app: {}", (Object)appNumber);
        String appId = this.convertAppId(appNumber);
        HashMap<String, Map<String, String>> addScriptsByApp = null;
        if (MapUtils.isNotEmpty(addScripts)) {
            addScriptsByApp = new HashMap<String, Map<String, String>>();
            addScriptsByApp.put(appId, addScripts);
        }
        HashMap<String, Map<String, String>> updateScriptsByApp = null;
        if (MapUtils.isNotEmpty(updateScripts)) {
            updateScriptsByApp = new HashMap<String, Map<String, String>>();
            updateScriptsByApp.put(appId, updateScripts);
        }
        HashMap<String, List<String>> deleteScriptsByApp = null;
        if (CollectionUtils.isNotEmpty(deleteScripts)) {
            deleteScriptsByApp = new HashMap<String, List<String>>();
            deleteScriptsByApp.put(appId, deleteScripts);
        }
        HashMap<String, Object> extraParam = new HashMap<String, Object>(3);
        extraParam.put("throwCompileExcept", true);
        extraParam.put("clientType", "vscode");
        extraParam.put("isDecode", isDecode);
        this.processAndPushScripts(addScriptsByApp, updateScriptsByApp, deleteScriptsByApp, extraParam);
    }

    private void processAndPushScripts(Map<String, Map<String, String>> addScriptsByApp, Map<String, Map<String, String>> updateScriptsByApp, Map<String, List<String>> deleteScriptsByApp, Map<String, Object> extraParam) {
        boolean isDecode;
        this.clearCacheForApps(addScriptsByApp, updateScriptsByApp, deleteScriptsByApp);
        Map<String, Map<String, String>> newAddScriptsByApp = addScriptsByApp;
        Map<String, Map<String, String>> newUpdateScriptsByApp = updateScriptsByApp;
        Map<String, List<String>> newDeleteScripts = deleteScriptsByApp;
        boolean bl = isDecode = extraParam.get("isDecode") != null && (Boolean)extraParam.get("isDecode") != false;
        if (!isDecode) {
            newAddScriptsByApp = this.decodeBase64AppScriptsMap(addScriptsByApp);
            newUpdateScriptsByApp = this.decodeBase64AppScriptsMap(updateScriptsByApp);
            newDeleteScripts = this.decodeBase64AppScriptsList(deleteScriptsByApp);
        }
        Map<String, ScriptGroup> groupScriptsByApp = ScriptGroup.groupScriptsByApp(newAddScriptsByApp, newUpdateScriptsByApp, newDeleteScripts);
        for (Map.Entry<String, ScriptGroup> scriptGroupEntry : groupScriptsByApp.entrySet()) {
            String appId = scriptGroupEntry.getKey();
            String appNumber = this.convertAppNumber(appId);
            ScriptGroup scriptGroup = scriptGroupEntry.getValue();
            Map result = (Map)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"ScriptService", (String)"doMsPushScripts", (Object[])new Object[]{scriptGroup.hasAddScripts() ? Collections.singletonMap(appId, scriptGroup.getAddScripts()) : null, scriptGroup.hasUpdateScripts() ? Collections.singletonMap(appId, scriptGroup.getUpdateScripts()) : null, scriptGroup.hasDeleteScripts() ? Collections.singletonMap(appId, scriptGroup.getDeleteScripts()) : null, extraParam});
            Integer statusCode = (Integer)result.get("code");
            if (statusCode == 0) continue;
            throw new ScriptException(String.valueOf(result.get("exceptionMsg")));
        }
    }

    private void clearCacheForApps(Map<String, Map<String, String>> addScriptsByApp, Map<String, Map<String, String>> updateScriptsByApp, Map<String, List<String>> deleteScriptsByApp) {
        HashSet<String> appsToInvalidate = new HashSet<String>(1);
        if (addScriptsByApp != null) {
            appsToInvalidate.addAll(addScriptsByApp.keySet());
        }
        if (updateScriptsByApp != null) {
            appsToInvalidate.addAll(updateScriptsByApp.keySet());
        }
        if (deleteScriptsByApp != null) {
            appsToInvalidate.addAll(deleteScriptsByApp.keySet());
        }
        for (String appPkId : appsToInvalidate) {
            try {
                this.scriptCache.clearType(appPkId);
            }
            catch (Exception e) {
                throw new ScriptException(ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u4e0b\u627e\u4e0d\u5230\u811a\u672c\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u76ee\u5f55\u3002", (String)"ProjectGuidPlugin_11", (String)"bos-kingscript-console", (Object[])new Object[0]));
            }
        }
    }

    @ApiPostMapping(value="kingscript/dev/push/script")
    public CustomApiResult<Boolean> pushScript(@ApiParam(value="\u65b0\u589e\u811a\u672c", required=true) @ApiParam(value="\u65b0\u589e\u811a\u672c", required=true) String appId, @ApiParam(value="\u811a\u672c\u5185\u5bb9") @ApiParam(value="\u811a\u672c\u5185\u5bb9") Map<String, String> scripts) {
        logger.info("Pushing single script for app: {}", (Object)appId);
        if (MapUtils.isEmpty(scripts)) {
            return CustomApiResult.success((Object)true);
        }
        Map<String, String> decodedScripts = this.decodeScripts(scripts);
        Set<String> existPaths = this.scriptDBHelper.collectExistPaths(new ArrayList<String>(decodedScripts.keySet()));
        Map<String, String> addScripts = this.filterScripts(decodedScripts, path -> !existPaths.contains(path));
        Map<String, String> updateScripts = this.filterScripts(decodedScripts, existPaths::contains);
        this.pushScriptsInternal(appId, addScripts, updateScripts, Collections.emptyList(), true);
        return CustomApiResult.success((Object)true);
    }

    private Map<String, String> decodeScripts(Map<String, String> scripts) {
        return scripts.entrySet().stream().collect(Collectors.toMap(script -> this.convertToUnixPath(this.decodeBase64((String)script.getKey())), script -> this.decodeBase64((String)script.getValue())));
    }

    private Map<String, String> filterScripts(Map<String, String> scripts, Predicate<String> predicate) {
        return scripts.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @ApiPostMapping(value="kingscript/dev/login/checkPermission")
    public CustomApiResult<Map<String, Object>> checkPermission(@ApiParam(value="\u624b\u673a\u53f7") @ApiParam(value="\u624b\u673a\u53f7") String phone) {
        if (EnvTypeHelper.isProductEnv()) {
            return CustomApiResult.fail((String)"102", (String)ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u662f\u751f\u4ea7\u73af\u5883\uff0c\u4e0d\u5141\u8bb8\u767b\u5f55\u3002", (String)"ProjectGuidPlugin_6", (String)"bos-kingscript-console", (Object[])new Object[0]));
        }
        boolean permission = DevPortalPermissionUtil.hasPermission("47150e89000000ac");
        String isv = ISVService.getISVInfo().getId();
        String bosVersion = "";
        String sql = "select fversion from t_bas_industry_version where fproductnumber = 'cosmic_bos';";
        try {
            bosVersion = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, resultSet -> {
                String version = null;
                while (resultSet.next()) {
                    version = resultSet.getString("fversion");
                }
                return version;
            });
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u53d1\u5e03\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)e);
        }
        int compareRes = this.compareVersion(bosVersion, "7.0.1");
        if (compareRes < 0) {
            return CustomApiResult.fail((String)"101", (String)ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528\u82cd\u7a797.0.1\u53ca\u4ee5\u4e0a\u7684\u7248\u672c\u3002", (String)"ProjectGuidPlugin_12", (String)"bos-kingscript-console", (Object[])new Object[0]));
        }
        boolean existSrc = ScriptDBHelper.isExistSrcByISV();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("hasPerm", permission);
        resultMap.put("isv", isv);
        resultMap.put("existSrc", existSrc);
        resultMap.put("version", bosVersion);
        if (permission) {
            return CustomApiResult.success(resultMap);
        }
        return CustomApiResult.fail((String)"101", (String)ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)"bos-kingscript-console", (Object[])new Object[0]));
    }

    public int compareVersion(String curVersion, String targetVersion) {
        String[] parts1 = curVersion.split("\\.");
        String[] parts2 = targetVersion.split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 == num2) continue;
            return num1 - num2;
        }
        return 0;
    }

    public void doPushScripts(Map<String, Map<String, String>> addScriptsByApp, Map<String, Map<String, String>> updateScriptsByApp, Map<String, List<String>> deleteScriptsByApp) {
        logger.info("Executing doPushScripts");
        HashMap<String, Object> extraParam = new HashMap<String, Object>(3);
        extraParam.put("throwCompileExcept", true);
        extraParam.put("clientType", "vscode");
        extraParam.put("isDecode", true);
        this.processAndPushScripts(addScriptsByApp, updateScriptsByApp, deleteScriptsByApp, extraParam);
    }

    public Map<String, Object> doMsPushScripts(Map<String, Map<String, String>> addScriptsByApp, Map<String, Map<String, String>> updateScriptsByApp, Map<String, List<String>> deleteScriptsByApp, Map<String, Object> extraParam) {
        logger.info("Executing micro-service push scripts");
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("code", 0);
        if (MapUtils.isNotEmpty(addScriptsByApp)) {
            Map<String, Object> insert = this.scriptDBHelper.insert(addScriptsByApp, extraParam);
            result.putAll(insert);
        }
        if (MapUtils.isNotEmpty(updateScriptsByApp)) {
            Map<String, Object> update = this.scriptDBHelper.update(updateScriptsByApp, extraParam);
            result.putAll(update);
        }
        if (MapUtils.isNotEmpty(deleteScriptsByApp)) {
            this.scriptDBHelper.delete(deleteScriptsByApp);
        }
        return result;
    }

    private Map<String, Map<String, String>> decodeBase64AppScriptsMap(Map<String, Map<String, String>> encodedAppScripts) {
        if (MapUtils.isEmpty(encodedAppScripts)) {
            return encodedAppScripts;
        }
        return encodedAppScripts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(script -> this.convertToUnixPath(this.decodeBase64((String)script.getKey())), script -> this.decodeBase64((String)script.getValue())))));
    }

    private Map<String, List<String>> decodeBase64AppScriptsList(Map<String, List<String>> encodedAppScripts) {
        if (MapUtils.isEmpty(encodedAppScripts)) {
            return encodedAppScripts;
        }
        return encodedAppScripts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(script -> this.convertToUnixPath(this.decodeBase64((String)script))).collect(Collectors.toList())));
    }

    public String convertAppId(String appNumber) {
        return AppReader.getAppIdByNumber((String)appNumber);
    }

    public String convertAppNumber(String appId) {
        AppInfo masterAppInfo = MetadataDao.getMasterAppInfo((String)appId);
        return masterAppInfo != null ? masterAppInfo.getNumber() : AppReader.getAppNumberById((String)appId);
    }

    private String decodeBase64(String str) {
        byte[] decode = Base64.getDecoder().decode(str);
        return new String(decode, StandardCharsets.UTF_8);
    }

    private String convertToUnixPath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace("\\", "/");
    }

    static class ScriptGroup {
        private Map<String, String> addScripts;
        private Map<String, String> updateScripts;
        private List<String> deleteScripts;

        ScriptGroup() {
        }

        public static Map<String, ScriptGroup> groupScriptsByApp(Map<String, Map<String, String>> addScriptsByApp, Map<String, Map<String, String>> updateScriptsByApp, Map<String, List<String>> deleteScriptsByApp) {
            String appId;
            HashMap<String, ScriptGroup> result = new HashMap<String, ScriptGroup>();
            if (addScriptsByApp != null) {
                for (Map.Entry<String, Map<String, String>> entry : addScriptsByApp.entrySet()) {
                    appId = entry.getKey();
                    result.computeIfAbsent(appId, k -> new ScriptGroup()).setAddScripts(entry.getValue());
                }
            }
            if (updateScriptsByApp != null) {
                for (Map.Entry<String, Object> entry : updateScriptsByApp.entrySet()) {
                    appId = entry.getKey();
                    result.computeIfAbsent(appId, k -> new ScriptGroup()).setUpdateScripts((Map)entry.getValue());
                }
            }
            if (deleteScriptsByApp != null) {
                for (Map.Entry<String, Object> entry : deleteScriptsByApp.entrySet()) {
                    appId = entry.getKey();
                    result.computeIfAbsent(appId, k -> new ScriptGroup()).setDeleteScripts((List)entry.getValue());
                }
            }
            return result;
        }

        public void setAddScripts(Map<String, String> addScripts) {
            this.addScripts = addScripts;
        }

        public void setUpdateScripts(Map<String, String> updateScripts) {
            this.updateScripts = updateScripts;
        }

        public void setDeleteScripts(List<String> deleteScripts) {
            this.deleteScripts = deleteScripts;
        }

        public boolean hasAddScripts() {
            return MapUtils.isNotEmpty(this.addScripts);
        }

        public boolean hasUpdateScripts() {
            return MapUtils.isNotEmpty(this.updateScripts);
        }

        public boolean hasDeleteScripts() {
            return CollectionUtils.isNotEmpty(this.deleteScripts);
        }

        public Map<String, String> getAddScripts() {
            return this.addScripts;
        }

        public Map<String, String> getUpdateScripts() {
            return this.updateScripts;
        }

        public List<String> getDeleteScripts() {
            return this.deleteScripts;
        }
    }
}

