/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.openapi.development.helper;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.devportal.common.kingscript.KingScriptType;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.plugin.IConvertPlugIn;
import kd.bos.entity.botp.plugin.IWriteBackPlugIn;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.plugin.IPrintPlugin;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.compile.CompileResult;
import kd.sdk.kingscript.engine.compile.CompileTool;
import kd.sdk.kingscript.lib.crypto.CryptoUtil;
import kd.sdk.kingscript.lib.version.ScriptVersionManager;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.util.Tuple;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ScriptDBHelper {
    private static final Logger logger = Logs.getLogger();
    private static final String ENTITY_NAME = "ide_pluginscript";
    private static final String ROW_KEY_NAME = "RowKey";
    private static final String SCRIPTNUMBER = "scriptnumber";
    private static final String CODE = "kingscripteditap";
    private static final String SCRIPT_NAME = "scriptName";
    private static final String DESCRIPTION = "description";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String TXT_SCRIPTNAME = "txt_scriptname";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String TXT_SCRIPTCONTENT = "txt_scriptcontext";
    private static final String TXT_SCRIPTCONTENT_TAG = "txt_scriptcontext_tag";
    private static final String TXT_SCRIPTCOMPILE_TAG = "txt_scriptcompile_tag";
    private static final String TXT_SCRIPTSRCMAP_TAG = "txt_scriptsrcmap_tag";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_BIZUNITID = "bizunitid";
    private static final String CLASSNAME = "classname";
    private static final String MODIFYDATE = "modifydate";
    private static final String MODIFIER_ID = "modifier_id";
    private static final String SCRIPTMODULE = "scriptmodule";
    private static final String ENGINETYPE = "enginetype";
    private static final String SCRIPT_TYPE = "scriptType";
    private static final String CREATER = "creater";
    private static final String CREATEDATE = "createdate";
    private static final String MODIFIER = "modifier";
    private static final String ID = "id";
    private static final String ISV = "isv";
    private static final String DATEFM = "yyyy-MM-dd HH:mm:ss";
    private static final String PLUGIN = "plugin";
    private static final String CBOX_SCRIPT_TYPE = "cbox_script_type";
    private static final String SUCCESS_OBJ = "successObj";
    private static final String STATUS_CODE = "code";
    private static final String THROW_COMPILE_EXCEPT = "throwCompileExcept";
    private static final String EXCEPTION_MSG = "exceptionMsg";
    private static final String CLIENT_TYPE = "clientType";
    private static final String EDITOR = "editor";
    private static DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm");
    private static String noSrcISV = "";
    private static String[] FIX_NO_SRC_ISV = new String[]{"kingdee", "kdxk"};
    private static String KINGSCRIPT_PUSH_NOSRC = "kingscript.push.nosrc";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public static Map<String, List<String>> loadScriptPathByBizAppIdFromCache(IPageCache pageCache) {
        String resultJson = pageCache.get("loadScriptPathByBizAppIdFromCache");
        if (StringUtils.isNotBlank((CharSequence)resultJson)) {
            return (Map)SerializationUtils.fromJsonString((String)resultJson, Map.class);
        }
        Map<String, List<String>> result = ScriptDBHelper.loadScriptPathByBizAppId();
        pageCache.put("loadScriptPathByBizAppIdFromCache", SerializationUtils.toJsonString(result));
        return result;
    }

    private static Map<String, List<String>> loadScriptPathByBizAppId() {
        QFilter[] qFilters = new QFilter(ENGINETYPE, "=", (Object)"1").toArray();
        String selectProperties = "id, classname, bizappid, enginetype, modifydate";
        DynamicObject[] pluginscripts = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)selectProperties, (QFilter[])qFilters, (String)"modifydate desc");
        HashMap<String, List<String>> allResult = new HashMap<String, List<String>>();
        if (pluginscripts != null && pluginscripts.length > 0) {
            for (DynamicObject data : pluginscripts) {
                String bizappid = data.getString(KEY_BIZAPPID);
                List result = allResult.computeIfAbsent(bizappid, s -> new ArrayList());
                String scriptPath = data.getString(CLASSNAME);
                result.add(scriptPath);
            }
        }
        return allResult;
    }

    public static Map<String, String> loadScriptByBizAppId(String bizappid) {
        QFilter[] qFilters = new QFilter(ENGINETYPE, "=", (Object)"1").and(new QFilter(KEY_BIZAPPID, "=", (Object)bizappid)).toArray();
        String selectProperties = "id, classname, txt_scriptcontext_tag, bizappid, enginetype, isv";
        Map pluginscripts = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (String)selectProperties, (QFilter[])qFilters);
        HashMap<String, String> result = new HashMap<String, String>(pluginscripts.size());
        String currentISV = ISVServiceHelper.getISVInfo().getId();
        for (DynamicObject data : pluginscripts.values()) {
            String scriptPath = data.getString(CLASSNAME);
            String scriptContext = data.getString(TXT_SCRIPTCONTENT_TAG);
            String isv = data.getString(ISV);
            if (!StringUtils.equals((CharSequence)isv, (CharSequence)currentISV)) continue;
            if (result.containsKey(scriptPath)) {
                logger.warn("warn kd.bos.kingscript.openapi.development.helper.ScriptDBHelper.loadScriptByBizAppId");
            }
            result.put(scriptPath, scriptContext);
        }
        return result;
    }

    public static Map<String, String> loadScriptByScriptPaths(List<String> scriptPaths) {
        QFilter[] qFilters = new QFilter(ENGINETYPE, "=", (Object)"1").and(new QFilter(CLASSNAME, "in", scriptPaths)).toArray();
        String selectProperties = "id, classname, txt_scriptcontext_tag, bizappid, enginetype";
        Map pluginscripts = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (String)selectProperties, (QFilter[])qFilters);
        HashMap<String, String> result = new HashMap<String, String>(pluginscripts.size());
        for (DynamicObject data : pluginscripts.values()) {
            String scriptPath = data.getString(CLASSNAME);
            String scriptContext = data.getString(TXT_SCRIPTCONTENT_TAG);
            if (result.containsKey(scriptPath)) {
                logger.warn("warn kd.bos.kingscript.openapi.development.helper.ScriptDBHelper.loadScriptByScriptPaths");
            }
            result.put(scriptPath, scriptContext);
        }
        return result;
    }

    public static Map<String, DynamicObject> loadSimpleScriptByPaths(String appPkId, List<String> scriptPaths) {
        QFilter[] qFilters = new QFilter(ENGINETYPE, "=", (Object)"1").and(new QFilter(KEY_BIZAPPID, "=", (Object)appPkId)).and(new QFilter(CLASSNAME, "in", scriptPaths)).toArray();
        Map pluginscripts = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (QFilter[])qFilters);
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(pluginscripts.size());
        for (DynamicObject data : pluginscripts.values()) {
            String scriptPath = data.getString(CLASSNAME);
            if (result.containsKey(scriptPath)) {
                logger.warn("warn kd.bos.kingscript.openapi.development.helper.ScriptDBHelper.loadSimpleScriptByPaths");
            }
            result.put(scriptPath, data);
        }
        return result;
    }

    public static List<String> loadPrimaryScriptByBizAppId(String appPkId) {
        QFilter[] qFilters = new QFilter(ENGINETYPE, "=", (Object)"1").and(new QFilter(KEY_BIZAPPID, "=", (Object)appPkId)).toArray();
        String selectProperties = ID;
        Map pluginscripts = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (String)selectProperties, (QFilter[])qFilters);
        return pluginscripts.values().stream().map(DataEntityBase::getPkValue).map(Object::toString).collect(Collectors.toList());
    }

    public static List<String> loadPrimaryScriptByPaths(List<String> scriptPaths) {
        QFilter[] qFilters = new QFilter(ENGINETYPE, "=", (Object)"1").and(new QFilter(CLASSNAME, "in", scriptPaths)).toArray();
        String selectProperties = ID;
        Map pluginscripts = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (String)selectProperties, (QFilter[])qFilters);
        return pluginscripts.values().stream().map(DataEntityBase::getPkValue).map(Object::toString).collect(Collectors.toList());
    }

    public static Set<String> loadExistScriptPaths(List<String> scriptPaths) {
        QFilter[] qFilters = new QFilter(ENGINETYPE, "=", (Object)"1").and(new QFilter(CLASSNAME, "in", scriptPaths)).toArray();
        String selectProperties = "id, classname";
        Map pluginscripts = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (String)selectProperties, (QFilter[])qFilters);
        return pluginscripts.values().stream().map(x -> x.getString(CLASSNAME)).collect(Collectors.toSet());
    }

    public static boolean isExistSrcByISV() {
        String isv = ISVService.getISVInfo().getId();
        ArrayList<String> splitISVKeys = new ArrayList<String>(Arrays.asList(FIX_NO_SRC_ISV));
        if (StringUtils.isNotBlank((CharSequence)noSrcISV)) {
            splitISVKeys.addAll(Arrays.asList(StringUtils.split((String)noSrcISV, (String)",")));
        }
        return !splitISVKeys.contains(isv);
    }

    @Deprecated
    public Map<String, Object> insert(Map<String, Map<String, String>> scriptsByAppid) {
        HashMap<String, Object> extraParam = new HashMap<String, Object>(1);
        extraParam.put(THROW_COMPILE_EXCEPT, false);
        return this.insert(scriptsByAppid, extraParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> insert(Map<String, Map<String, String>> scriptsByAppid, Map<String, Object> extraParam) {
        Object[] successObj;
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        result.put(STATUS_CODE, 0);
        if (MapUtils.isEmpty(scriptsByAppid)) {
            return result;
        }
        LinkedList<DynamicObject> datas = new LinkedList<DynamicObject>();
        for (Map.Entry<String, Map<String, String>> entry : scriptsByAppid.entrySet()) {
            if (MapUtils.isEmpty(entry.getValue())) continue;
            List<DynamicObject> datasByAppid = this.collectionNewData(entry.getKey(), entry.getValue(), extraParam);
            datas.addAll(datasByAppid);
        }
        List classPaths = datas.stream().map(x -> x.getString(CLASSNAME)).collect(Collectors.toList());
        QFilter qFilter = new QFilter(CLASSNAME, "in", classPaths);
        boolean exists = QueryServiceHelper.exists((String)"ide_pluginscript", (QFilter[])qFilter.toArray());
        if (exists) {
            result.put(STATUS_CODE, 2);
            result.put(EXCEPTION_MSG, "Data with the same script path already exists in the database. Duplicate entries are not allowed. Please check data compliance.");
            return result;
        }
        boolean throwCompileExcept = extraParam.get(THROW_COMPILE_EXCEPT) != null && (Boolean)extraParam.get(THROW_COMPILE_EXCEPT) != false;
        Tuple<Boolean, String> compileResult = this.compileScript(datas, throwCompileExcept);
        Boolean compileSuccess = (Boolean)compileResult.getKey();
        String compileException = (String)compileResult.getValue();
        String isv = ISVService.getISVInfo().getId();
        ArrayList<String> splitISVKeys = new ArrayList<String>(Arrays.asList(FIX_NO_SRC_ISV));
        if (StringUtils.isNotBlank((CharSequence)noSrcISV)) {
            splitISVKeys.addAll(Arrays.asList(StringUtils.split((String)noSrcISV, (String)",")));
        }
        if (splitISVKeys.contains(isv)) {
            datas.forEach(dynObj -> dynObj.set(TXT_SCRIPTCONTENT_TAG, (Object)""));
        }
        ArrayList<DLock> locks = new ArrayList<DLock>(classPaths.size());
        try {
            for (String path : classPaths) {
                DLock lock = DLock.create((String)("vscode_insert_" + path));
                if (!lock.tryLock(101000L)) {
                    result.put(STATUS_CODE, 2);
                    result.put(EXCEPTION_MSG, "Require locks timeout, try later please.");
                    HashMap<String, Object> hashMap = result;
                    return hashMap;
                }
                locks.add(lock);
            }
            boolean exists2 = QueryServiceHelper.exists((String)"ide_pluginscript", (QFilter[])qFilter.toArray());
            if (exists2) {
                result.put(STATUS_CODE, 2);
                result.put(EXCEPTION_MSG, "Data with the same script path already exists in the database. Duplicate entries are not allowed. Please check data compliance.");
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            successObj = SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
        }
        finally {
            locks.forEach(DLock::unlock);
        }
        if (!throwCompileExcept) {
            result.put(SUCCESS_OBJ, Arrays.asList(successObj));
        }
        if (!compileSuccess.booleanValue()) {
            result.put(STATUS_CODE, 1);
            result.put(EXCEPTION_MSG, compileException);
        }
        return result;
    }

    @Deprecated
    public Map<String, Object> update(Map<String, Map<String, String>> scriptsByAppid) {
        HashMap<String, Object> extraParam = new HashMap<String, Object>(1);
        extraParam.put(THROW_COMPILE_EXCEPT, false);
        return this.update(scriptsByAppid, extraParam);
    }

    public Map<String, Object> update(Map<String, Map<String, String>> scriptsByAppid, Map<String, Object> extraParam) {
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        result.put(STATUS_CODE, 0);
        if (MapUtils.isEmpty(scriptsByAppid)) {
            return result;
        }
        LinkedList<Map<String, DynamicObject>> datasByPathList = new LinkedList<Map<String, DynamicObject>>();
        LinkedList<DynamicObject> datas = new LinkedList<DynamicObject>();
        for (Map.Entry<String, Map<String, String>> entry : scriptsByAppid.entrySet()) {
            if (MapUtils.isEmpty(entry.getValue())) continue;
            Map<String, DynamicObject> datasByPath = ScriptDBHelper.loadSimpleScriptByPaths(entry.getKey(), new ArrayList<String>(entry.getValue().keySet()));
            datasByPathList.add(datasByPath);
            for (Map.Entry<String, DynamicObject> dataEntry : datasByPath.entrySet()) {
                String clientType;
                String scriptPath = dataEntry.getKey();
                DynamicObject data = dataEntry.getValue();
                String string = entry.getValue().get(scriptPath);
                data.set(TXT_SCRIPTCONTENT_TAG, (Object)string);
                data.set(TXT_SCRIPTCONTENT, (Object)" ");
                data.set(ENGINETYPE, (Object)"1");
                data.set(MODIFIER, (Object)Long.valueOf(RequestContext.get().getUserId()));
                data.set(MODIFYDATE, (Object)Timestamp.valueOf(new SimpleDateFormat(DATEFM).format(new Date())));
                String isv = data.getString(ISV);
                if (StringUtils.isBlank((CharSequence)isv)) {
                    isv = ISVService.getISVInfo().getId();
                    data.set(ISV, (Object)isv);
                }
                if (StringUtils.isNotBlank((CharSequence)(clientType = (String)extraParam.get(CLIENT_TYPE))) && EDITOR.equals(clientType)) {
                    data.set(TXT_SCRIPTNAME, extraParam.get(SCRIPT_NAME));
                    data.set(DESCRIPTION, extraParam.get(DESCRIPTION));
                    data.set(TXT_SCRIPTNUMBER, extraParam.get(SCRIPTNUMBER));
                }
                datas.add(data);
            }
        }
        boolean throwCompileExcept = extraParam.get(THROW_COMPILE_EXCEPT) != null && (Boolean)extraParam.get(THROW_COMPILE_EXCEPT) != false;
        Tuple<Boolean, String> compileResult = this.compileScript(datas, throwCompileExcept);
        Boolean compileSuccess = (Boolean)compileResult.getKey();
        String compileException = (String)compileResult.getValue();
        String isv = ISVService.getISVInfo().getId();
        ArrayList<String> splitISVKeys = new ArrayList<String>(Arrays.asList(FIX_NO_SRC_ISV));
        if (StringUtils.isNotBlank((CharSequence)noSrcISV)) {
            splitISVKeys.addAll(Arrays.asList(StringUtils.split((String)noSrcISV, (String)",")));
        }
        if (splitISVKeys.contains(isv)) {
            datas.forEach(dynObj -> dynObj.set(TXT_SCRIPTCONTENT_TAG, (Object)""));
        }
        SaveServiceHelper.update((DynamicObject[])datas.toArray(new DynamicObject[0]));
        if (!throwCompileExcept) {
            result.put(SUCCESS_OBJ, datas);
        }
        if (!compileSuccess.booleanValue()) {
            result.put(STATUS_CODE, 1);
            result.put(EXCEPTION_MSG, compileException);
        }
        for (Map map : datasByPathList) {
            for (Map.Entry dataEntry : map.entrySet()) {
                String scriptPath = (String)dataEntry.getKey();
                DynamicObject data = (DynamicObject)dataEntry.getValue();
                Date modifyDate = data.getDate(MODIFYDATE);
                long version = System.currentTimeMillis();
                if (modifyDate != null) {
                    try {
                        version = this.dateFormat.parse(this.dateFormat.format(modifyDate)).getTime();
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                ScriptVersionManager.setVersion((String)scriptPath, (String)String.valueOf(version), null);
            }
        }
        return result;
    }

    public void delete(Map<String, List<String>> scriptsByAppid) {
        if (MapUtils.isEmpty(scriptsByAppid)) {
            return;
        }
        LinkedList<Object> pkIds = new LinkedList<Object>();
        ArrayList<String> scriptPaths = new ArrayList(10);
        for (Map.Entry<String, List<String>> entry : scriptsByAppid.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            scriptPaths = entry.getValue();
            Map<String, DynamicObject> datasByPath = ScriptDBHelper.loadSimpleScriptByPaths(entry.getKey(), scriptPaths);
            for (DynamicObject data : datasByPath.values()) {
                pkIds.add(data.getPkValue());
            }
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ide_pluginscript"), (Object[])pkIds.toArray(new Object[0]));
        for (String scriptPath : scriptPaths) {
            ScriptVersionManager.clearVersion((String)scriptPath, null);
        }
    }

    private List<DynamicObject> collectionNewData(String appPkId, Map<String, String> scripts, Map<String, Object> extraParam) {
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(scripts.size());
        for (Map.Entry<String, String> entry : scripts.entrySet()) {
            DynamicObject data = this.buildNewData(appPkId, entry.getKey(), entry.getValue(), extraParam);
            datas.add(data);
        }
        return datas;
    }

    private Tuple<Boolean, String> compileScript(List<DynamicObject> datas, boolean throwCompileExcept) {
        String scriptPath2;
        Object scriptContext;
        Tuple result = new Tuple((Object)Boolean.FALSE, (Object)"");
        HashMap<String, Object> tsSourceMap = new HashMap<String, Object>(10);
        HashMap<String, DynamicObject> saveDynObjDict = new HashMap<String, DynamicObject>(10);
        for (DynamicObject data : datas) {
            scriptContext = data.getString(TXT_SCRIPTCONTENT_TAG);
            scriptPath2 = data.getString(CLASSNAME);
            if (!StringUtils.isNotBlank((CharSequence)scriptPath2) || !StringUtils.isNotBlank((CharSequence)scriptContext)) continue;
            tsSourceMap.put(scriptPath2, scriptContext);
            saveDynObjDict.put(scriptPath2, data);
        }
        if (tsSourceMap.isEmpty()) {
            result.setValue((Object)"No source find to compile.");
            return result;
        }
        Map compileResultMap = new HashMap(10);
        try {
            KingScriptEngine engine = ProjectInitializerManager.getEngine((boolean)false);
            scriptContext = null;
            try {
                if (engine != null) {
                    compileResultMap = CompileTool.compile((KingScriptEngine)engine, tsSourceMap);
                }
            }
            catch (Throwable scriptPath2) {
                scriptContext = scriptPath2;
                throw scriptPath2;
            }
            finally {
                if (engine != null) {
                    if (scriptContext != null) {
                        try {
                            engine.close();
                        }
                        catch (Throwable scriptPath2) {
                            ((Throwable)scriptContext).addSuppressed(scriptPath2);
                        }
                    } else {
                        engine.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            if (throwCompileExcept) {
                throw t;
            }
            result.setValue((Object)t.toString());
            return result;
        }
        for (Map.Entry entry : compileResultMap.entrySet()) {
            scriptPath2 = (String)entry.getKey();
            CompileResult compileResult = (CompileResult)compileResultMap.get(scriptPath2);
            Map exports = compileResult.getExports();
            DynamicObject scriptObj = (DynamicObject)saveDynObjDict.get(scriptPath2);
            scriptObj.set(CBOX_SCRIPT_TYPE, (Object)KingScriptType.getScriptType((Map)exports));
            String compiledScript = compileResult.getTarget();
            if (StringUtils.isNotBlank((CharSequence)compiledScript)) {
                String encryptedScript = CryptoUtil.encrypt((String)"default", (String)compiledScript);
                scriptObj.set(TXT_SCRIPTCOMPILE_TAG, (Object)encryptedScript);
            }
            if (!StringUtils.isNotBlank((CharSequence)compileResult.getSourceMapping())) continue;
            scriptObj.set(TXT_SCRIPTSRCMAP_TAG, (Object)compileResult.getSourceMapping());
        }
        result.setKey((Object)Boolean.TRUE);
        return result;
    }

    private String getScriptType(Map<String, Object> exports) {
        if (exports.get(PLUGIN) == null) {
            return "6";
        }
        Class<?> clazz = exports.get(PLUGIN).getClass();
        if (IBillPlugin.class.isAssignableFrom(clazz)) {
            return "2";
        }
        if (IListPlugin.class.isAssignableFrom(clazz)) {
            return "3";
        }
        if (IOperationServicePlugIn.class.isAssignableFrom(clazz)) {
            return "4";
        }
        if (IConvertPlugIn.class.isAssignableFrom(clazz)) {
            return "10";
        }
        if (IWriteBackPlugIn.class.isAssignableFrom(clazz)) {
            return "11";
        }
        if (IPrintPlugin.class.isAssignableFrom(clazz)) {
            return "12";
        }
        if (IImportDataPlugin.class.isAssignableFrom(clazz)) {
            return "13";
        }
        if (IFormPlugin.class.isAssignableFrom(clazz)) {
            return "1";
        }
        return "6";
    }

    private DynamicObject buildNewData(String appId, String scriptPath, String scriptContext, Map<String, Object> extraParam) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ide_pluginscript");
        dynamicObject.set(ENGINETYPE, (Object)"1");
        dynamicObject.set(ID, (Object)Uuid8.generateShortUuid());
        dynamicObject.set(TXT_SCRIPTNAME, (Object)ScriptDBHelper.extractScriptName(scriptPath));
        dynamicObject.set(TXT_SCRIPTNUMBER, (Object)ScriptDBHelper.extractScriptName(scriptPath));
        dynamicObject.set(DESCRIPTION, (Object)"");
        dynamicObject.set(SCRIPTMODULE, (Object)this.extractScriptModule(scriptPath));
        dynamicObject.set(CBOX_SCRIPT_TYPE, (Object)"6");
        dynamicObject.set(KEY_BIZUNITID, (Object)"");
        String clientType = (String)extraParam.get(CLIENT_TYPE);
        if (StringUtils.isNotBlank((CharSequence)clientType) && EDITOR.equals(clientType)) {
            dynamicObject.set(TXT_SCRIPTNAME, extraParam.get(SCRIPT_NAME));
            dynamicObject.set(DESCRIPTION, extraParam.get(DESCRIPTION));
            dynamicObject.set(TXT_SCRIPTNUMBER, extraParam.get(SCRIPTNUMBER));
            dynamicObject.set(SCRIPTMODULE, extraParam.get(SCRIPTMODULE));
            dynamicObject.set(CBOX_SCRIPT_TYPE, extraParam.get(SCRIPT_TYPE));
            dynamicObject.set(KEY_BIZUNITID, extraParam.get(KEY_BIZUNITID));
        }
        dynamicObject.set(KEY_BIZAPPID, (Object)appId);
        dynamicObject.set(CLASSNAME, (Object)scriptPath);
        dynamicObject.set(TXT_SCRIPTCONTENT_TAG, (Object)scriptContext);
        dynamicObject.set(TXT_SCRIPTCONTENT, (Object)" ");
        dynamicObject.set(CREATER, (Object)Long.valueOf(RequestContext.get().getUserId()));
        dynamicObject.set(CREATEDATE, (Object)Timestamp.valueOf(new SimpleDateFormat(DATEFM).format(new Date())));
        dynamicObject.set(MODIFIER, (Object)Long.valueOf(RequestContext.get().getUserId()));
        dynamicObject.set(MODIFYDATE, (Object)Timestamp.valueOf(new SimpleDateFormat(DATEFM).format(new Date())));
        String isv = dynamicObject.getString(ISV);
        if (StringUtils.isBlank((CharSequence)isv)) {
            isv = ISVService.getISVInfo().getId();
            dynamicObject.set(ISV, (Object)isv);
        }
        return dynamicObject;
    }

    private static String extractScriptName(String scriptPath) {
        int lastSlashIndex = scriptPath.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            return scriptPath;
        }
        String scriptName = scriptPath.substring(lastSlashIndex + 1);
        int dotIndex = scriptName.lastIndexOf(46);
        if (dotIndex > 0) {
            return scriptName.substring(0, dotIndex);
        }
        return scriptName;
    }

    private String extractScriptModule(String scriptPath) {
        int secondSlashIndex;
        int lastSlashIndex = scriptPath.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            return "";
        }
        String scriptModule = scriptPath.substring(0, lastSlashIndex);
        if (scriptModule.startsWith("@") && (secondSlashIndex = scriptModule.indexOf(47, 1)) != -1) {
            return scriptModule.substring(0, secondSlashIndex);
        }
        return "";
    }

    public Set<String> collectExistPaths(List<String> scriptPaths) {
        return ScriptDBHelper.loadExistScriptPaths(scriptPaths);
    }

    static {
        String tenantId = RequestContext.get().getTenantId();
        noSrcISV = SystemPropertyUtils.getProptyByTenant((String)KINGSCRIPT_PUSH_NOSRC, (String)tenantId);
        ConfigurationUtil.observeChange((String)KINGSCRIPT_PUSH_NOSRC, (key, newValue) -> {
            noSrcISV = SystemPropertyUtils.getProptyByTenant((String)KINGSCRIPT_PUSH_NOSRC, (String)tenantId);
        });
    }

    public static class SimpleScriptInfo {
        private String bizappid;
        private String scriptPath;
        private String modifytime;

        public void setBizappid(String bizappid) {
            this.bizappid = bizappid;
        }

        public void setScriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        public void setModifytime(String modifytime) {
            this.modifytime = modifytime;
        }

        public String getBizappid() {
            return this.bizappid;
        }

        public String getScriptPath() {
            return this.scriptPath;
        }

        public String getModifytime() {
            return this.modifytime;
        }
    }
}

