/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.openapi.development.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SimpleScriptTreeNode
implements Serializable {
    private String id;
    private String label;
    private String nodeData;
    private String level;
    protected List<SimpleScriptTreeNode> children = new LinkedList<SimpleScriptTreeNode>();

    public static SimpleScriptTreeNode convertFromTreeNode(TreeNode treeNode, Set<String> followAppIds) {
        Set<String> appIds = SimpleScriptTreeNode.collectionAppIdsByTreeNode(treeNode);
        Map<String, String> appNumByIdsContent = SimpleScriptTreeNode.buildAppNumbersMap(appIds);
        SimpleScriptTreeNode rootNode = new SimpleScriptTreeNode();
        rootNode.label = treeNode.getText();
        rootNode.id = treeNode.getId();
        int level = 1;
        rootNode.level = "" + level;
        SimpleScriptTreeNode.recursionChildNode(appNumByIdsContent, followAppIds, rootNode, treeNode, level + 1);
        return rootNode;
    }

    private static Set<String> collectionAppIdsByTreeNode(TreeNode treeNode) {
        HashSet<String> appIds = new HashSet<String>();
        List cloudTreeNodes = treeNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)cloudTreeNodes)) {
            return appIds;
        }
        for (TreeNode cloudTreeNode : cloudTreeNodes) {
            List appTreeNodes = cloudTreeNode.getChildren();
            if (!CollectionUtils.isNotEmpty((Collection)appTreeNodes)) continue;
            appIds.addAll(appTreeNodes.stream().map(TreeNode::getId).collect(Collectors.toList()));
        }
        return appIds;
    }

    private static Map<String, String> buildAppNumbersMap(Set<String> appIds) {
        BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_devportal_bizapp");
        HashSet<String> properties = new HashSet<String>();
        properties.add(dataEntityType.getPrimaryKey().getName());
        properties.add(dataEntityType.getNumberProperty());
        EntityType subEntityType = dataEntityType.getSubEntityType(properties);
        DynamicObject[] datas = BusinessDataServiceHelper.load((Object[])appIds.toArray(new Object[0]), (DynamicObjectType)subEntityType);
        if (datas == null || datas.length == 0) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> result = new HashMap<String, String>(datas.length);
        for (DynamicObject data : datas) {
            result.put(data.getPkValue().toString(), data.getString("number"));
        }
        return result;
    }

    private static List<SimpleScriptTreeNode> recursionChildNode(Map<String, String> appNumByIdsContent, Set<String> followAppIds, SimpleScriptTreeNode parentNode, TreeNode parentTreeNode, int level) {
        if (CollectionUtils.isEmpty((Collection)parentTreeNode.getChildren())) {
            return null;
        }
        ArrayList<SimpleScriptTreeNode> childNodes = new ArrayList<SimpleScriptTreeNode>(parentTreeNode.getChildren().size());
        for (TreeNode tmpNode : parentTreeNode.getChildren()) {
            SimpleScriptTreeNode node = new SimpleScriptTreeNode();
            node.label = tmpNode.getText();
            node.id = tmpNode.getId();
            node.level = "" + level;
            if (level == 3) {
                String appNumber = appNumByIdsContent.get(node.id);
                if (StringUtils.isNotBlank((CharSequence)appNumber)) {
                    node.nodeData = appNumber;
                }
                if (CollectionUtils.isNotEmpty(followAppIds) && StringUtils.isNotBlank((CharSequence)node.nodeData) && !followAppIds.contains(node.nodeData)) continue;
            }
            childNodes.add(node);
            List<SimpleScriptTreeNode> _childNodes = SimpleScriptTreeNode.recursionChildNode(appNumByIdsContent, followAppIds, node, tmpNode, level + 1);
            if (level == 2 && !CollectionUtils.isNotEmpty(_childNodes)) continue;
            parentNode.addChild(node);
        }
        return childNodes;
    }

    private void addChild(SimpleScriptTreeNode scriptTreeNode) {
        this.children.add(scriptTreeNode);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public List<SimpleScriptTreeNode> getChildren() {
        return this.children;
    }

    public String getNodeData() {
        return this.nodeData;
    }

    public String getLevel() {
        return this.level;
    }
}

