/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.scriptlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.kingscript.scriptlet.ScriptletNode;
import kd.bos.kingscript.scriptlet.ScriptletTree;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.kingscript.scriptlet.ScriptletInfoJson;
import kd.sdk.kingscript.scriptlet.ScriptletService;
import kd.sdk.kingscript.scriptlet.ScriptletTreeJson;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ScriptletServiceImpl
extends ScriptletService {
    public List<ScriptletTreeJson> getCodeEditorFragmentTree() {
        QFilter scriptletQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Map bosScripletGroups = BusinessDataServiceHelper.loadFromCache((String)"bos_scriptlet_group", (String)"id, name, parent", null);
        Map bosScriplets = BusinessDataServiceHelper.loadFromCache((String)"bos_scriptlet", (String)"id, name, script_title, script_import_code, group", (QFilter[])scriptletQFilter.toArray());
        ArrayList<ScriptletTree> tops = new ArrayList<ScriptletTree>(1);
        tops.add(new ScriptletTree(0L, "All", null));
        HashMap<Long, ScriptletTree> record = new HashMap<Long, ScriptletTree>();
        this.buildTree(bosScripletGroups, tops, record);
        this.buildNode(bosScriplets, record);
        return this.convertJsons(tops);
    }

    public List<ScriptletInfoJson> getCodeEditorFragment(String[] ids) {
        if (ids == null || ids.length == 0) {
            return Collections.emptyList();
        }
        Object[] pkIds = (Long[])Arrays.stream(ids).map(Long::valueOf).toArray(x -> new Long[ids.length]);
        Map bosScriplets = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)"bos_scriptlet");
        if (bosScriplets == null) {
            return Collections.emptyList();
        }
        ArrayList<ScriptletInfoJson> result = new ArrayList<ScriptletInfoJson>(ids.length);
        for (DynamicObject value : bosScriplets.values()) {
            ScriptletNode scriptletNode = this.convertNode(value);
            ScriptletInfoJson json = new ScriptletInfoJson("" + scriptletNode.getId(), scriptletNode.getContext());
            result.add(json);
        }
        return result;
    }

    private void buildTree(Map<Object, DynamicObject> bosScripletGroups, List<ScriptletTree> tops, Map<Long, ScriptletTree> record) {
        for (ScriptletTree top : tops) {
            record.put(top.getId(), top);
        }
        for (DynamicObject bosScripletGroup : bosScripletGroups.values()) {
            ScriptletTree scriptletTree = this.convertTree(bosScripletGroup);
            record.put(scriptletTree.getId(), scriptletTree);
        }
        for (ScriptletTree scriptletTree : record.values()) {
            if (scriptletTree.getId() == 0L) continue;
            ScriptletTree parentTree = record.get(0L);
            if (scriptletTree.getParent() != null) {
                parentTree = record.get(((DynamicObject)scriptletTree.getParent()).getPkValue());
            }
            parentTree.addChildTree(scriptletTree);
        }
    }

    private void buildNode(Map<Object, DynamicObject> bosScriplets, Map<Long, ScriptletTree> recordTrees) {
        ArrayList<ScriptletNode> recordNodes = new ArrayList<ScriptletNode>(bosScriplets.size());
        for (DynamicObject bosScriplet : bosScriplets.values()) {
            ScriptletNode scriptletNode = this.convertNode(bosScriplet);
            recordNodes.add(scriptletNode);
            Object pkId = 0L;
            if (scriptletNode.getGroup() != null) {
                pkId = ((DynamicObject)scriptletNode.getGroup()).getPkValue();
            }
            ScriptletTree scriptletTree = recordTrees.get(pkId);
            scriptletTree.addChildNode(scriptletNode);
        }
        this.tryAppendCodeToScriptNode(recordNodes);
    }

    private void tryAppendCodeToScriptNode(List<ScriptletNode> recordNodes) {
        if (CollectionUtils.isEmpty(recordNodes)) {
            return;
        }
        String[] nodeIds = (String[])recordNodes.stream().filter(node -> StringUtils.isNotBlank((CharSequence)node.getImportCode())).map(node -> String.valueOf(node.getId())).toArray(String[]::new);
        List<ScriptletInfoJson> scriptletInfoJsons = this.getCodeEditorFragment(nodeIds);
        if (CollectionUtils.isEmpty(recordNodes)) {
            return;
        }
        Map<String, String> nodeIdCodes = scriptletInfoJsons.stream().collect(Collectors.toMap(ScriptletInfoJson::getId, ScriptletInfoJson::getData));
        for (ScriptletNode recordNode : recordNodes) {
            String code = nodeIdCodes.get(String.valueOf(recordNode.getId()));
            if (!StringUtils.isNotBlank((CharSequence)code)) continue;
            recordNode.setContext(code);
        }
    }

    private ScriptletTree convertTree(DynamicObject dynamicObject) {
        long id = (Long)dynamicObject.getPkValue();
        String name = dynamicObject.getString("name");
        Object parent = dynamicObject.get("parent");
        return new ScriptletTree(id, name, parent);
    }

    private ScriptletNode convertNode(DynamicObject dynamicObject) {
        long id = (Long)dynamicObject.getPkValue();
        String name = dynamicObject.getString("name");
        String title = dynamicObject.getString("script_title");
        String importCode = dynamicObject.getString("script_import_code");
        Object group = dynamicObject.get("group");
        String context = "";
        if (dynamicObject.containsProperty("script_context_tag")) {
            context = dynamicObject.getString("script_context_tag");
        }
        return new ScriptletNode(id, name, title, importCode, context, group);
    }

    private List<ScriptletTreeJson> convertJsons(List<ScriptletTree> scriptletTrees) {
        ArrayList<ScriptletTreeJson> scriptletTreeJsons = new ArrayList<ScriptletTreeJson>(scriptletTrees.size());
        for (ScriptletTree scriptletTree : scriptletTrees) {
            ScriptletTreeJson scriptletTreeJson = ScriptletServiceImpl.convertJson(scriptletTree);
            scriptletTreeJsons.add(scriptletTreeJson);
            this.recursionJsonChild(scriptletTreeJson, scriptletTree.getTrees(), scriptletTree.getNodes());
        }
        return scriptletTreeJsons;
    }

    private static ScriptletTreeJson convertJson(ScriptletTree tree) {
        return new ScriptletTreeJson("" + tree.getId(), tree.getName(), "", 0);
    }

    private static ScriptletTreeJson convertJson(ScriptletNode node) {
        ScriptletTreeJson scriptletTreeJson = new ScriptletTreeJson("" + node.getId(), node.getName(), node.getImportCode(), 1);
        if (StringUtils.isNotBlank((CharSequence)node.getContext())) {
            scriptletTreeJson.setCode(node.getContext());
        }
        return scriptletTreeJson;
    }

    private void recursionJsonChild(ScriptletTreeJson scriptletTreeJson, List<ScriptletTree> trees, List<ScriptletNode> nodes) {
        ScriptletTreeJson treeJson;
        for (ScriptletTree tree : trees) {
            treeJson = ScriptletServiceImpl.convertJson(tree);
            scriptletTreeJson.addChild(treeJson);
            this.recursionJsonChild(treeJson, tree.getTrees(), tree.getNodes());
        }
        for (ScriptletNode node : nodes) {
            treeJson = ScriptletServiceImpl.convertJson(node);
            scriptletTreeJson.addChild(treeJson);
        }
    }
}

