/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.scriptlet.plugin;

import dm.jdbc.util.IDGenerator;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import org.apache.commons.lang3.StringUtils;

public class ScriptNodePlugin
extends AbstractBasePlugIn {
    private static final String CHILD_PAGEID = "child_pageid";

    public void afterCreateNewData(EventObject e) {
        this.showCodeEditor("");
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String context = this.loadContextToCodeEditor();
        this.showCodeEditor(context);
    }

    private String loadContextToCodeEditor() {
        return this.getModel().getValue("script_context_tag").toString();
    }

    private void showCodeEditor(String scriptContext) {
        FormShowParameter flexFormParameter = new FormShowParameter();
        flexFormParameter.setFormId("bos_script_editor");
        flexFormParameter.setPageId(this.getChildPageId());
        flexFormParameter.getOpenStyle().setTargetKey("kingscriptframe");
        flexFormParameter.getOpenStyle().setShowType(ShowType.InContainer);
        flexFormParameter.getOpenStyle().setInlineStyleCss(new StyleCss());
        flexFormParameter.getOpenStyle().getInlineStyleCss().setHeight("100%");
        flexFormParameter.setCustomParam("editTitle", (Object)String.valueOf(Boolean.FALSE));
        flexFormParameter.setCustomParam("isOnlyCodeEditor", (Object)String.valueOf(Boolean.TRUE));
        flexFormParameter.setCustomParam("scriptContext", (Object)scriptContext);
        this.getView().showForm(flexFormParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IFormView childFormView = this.getChildFormView();
        if (childFormView != null) {
            String codeNow = this.getCodeNow(childFormView);
            this.getModel().setValue("script_context_tag", (Object)codeNow);
        }
    }

    private String getChildPageId() {
        String childPageId = this.getPageCache().get(CHILD_PAGEID);
        if (StringUtils.isNotBlank((CharSequence)childPageId)) {
            return childPageId;
        }
        childPageId = IDGenerator.generateStrId();
        this.getPageCache().put(CHILD_PAGEID, childPageId);
        return childPageId;
    }

    private IFormView getChildFormView() {
        IFormView childFormView = this.getView().getView(this.getChildPageId());
        if (childFormView == null) {
            return null;
        }
        return childFormView;
    }

    private String getCodeNow(IFormView formView) {
        KingScriptEdit codeEdit = (KingScriptEdit)formView.getControl("kingscripteditap");
        String content = codeEdit.getText();
        if (content == null) {
            content = this.loadContextToCodeEditor();
        }
        return content;
    }
}

