/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.HashMap;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.mservice.result.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.dynplugin.DynPlugin;
import kd.bos.service.dynplugin.DynPluginBind;
import kd.bos.servicehelper.dynplugin.DynamicPluginServiceHelper;

public class BindOpPlugin
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        this.handleBind(dataEntities);
    }

    private void handleBind(DynamicObject[] dataEntities) {
        String formId = this.getOption().getVariableValue("formid");
        String selectRowStr = this.getOption().getVariableValue("selectrows");
        String selectSubStr = selectRowStr.substring(1, selectRowStr.length() - 1);
        if (StringUtils.isBlank((CharSequence)selectSubStr)) {
            return;
        }
        String[] selectedRowIndex = selectSubStr.split(",");
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("entryentity");
            String[] className = new String[selectedRowIndex.length];
            int index = 0;
            for (String row : selectedRowIndex) {
                DynamicObject dyn = (DynamicObject)dynamicObjects.get(Integer.parseInt(row));
                className[index] = dyn.getString("plugin");
                ++index;
            }
            Map result = BusinessDataReader.loadFromCache((String)"bos_dynplugin", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)className), new QFilter("eventmethod", "=", (Object)"ALL"), new QFilter("bizapp", "=", (Object)this.getOption().getVariableValue("curapp"))});
            HashMap<String, Long> classNameIdMap = new HashMap<String, Long>(result.values().size());
            for (DynamicObject dynamicObject1 : result.values()) {
                classNameIdMap.put(dynamicObject1.getString("number"), dynamicObject1.getLong("id"));
            }
            for (String row : selectedRowIndex) {
                DynamicObject dyn = (DynamicObject)dynamicObjects.get(Integer.parseInt(row));
                long dynPluginId = this.saveDynPlugin(dyn, classNameIdMap);
                this.saveDynPluginBind(dynPluginId, dyn, formId);
            }
        }
    }

    private long saveDynPlugin(DynamicObject dynamicObject, Map<String, Long> classNameIdMap) {
        Object data;
        long dynPluginId;
        String className = dynamicObject.getString("plugin");
        DynPlugin dynPlugin = new DynPlugin();
        if (!classNameIdMap.isEmpty() && (dynPluginId = classNameIdMap.get(className).longValue()) != 0L) {
            dynPlugin.setFid(dynPluginId);
        }
        dynPlugin.setEventmethod("ALL");
        dynPlugin.setBizapp(this.getOption().getVariableValue("curapp"));
        dynPlugin.setInterfacetype(dynamicObject.getString("plugintype"));
        dynPlugin.setCodeType("4");
        dynPlugin.setClient("1");
        dynPlugin.setClassName((String)dynamicObject.get("plugin"));
        ApiResult result = DynamicPluginServiceHelper.saveDynPlugin((DynPlugin)dynPlugin);
        if (result.isStatus() && (data = result.getData()) instanceof Long) {
            return (Long)data;
        }
        return (Long)DynamicPluginServiceHelper.loadDynPluginID((DynPlugin)dynPlugin).get(0);
    }

    private void saveDynPluginBind(long dynPluginId, DynamicObject dynamicObject, String formId) {
        DynPluginBind dynPluginBind = new DynPluginBind();
        dynPluginBind.setDynpluginId(dynPluginId);
        dynPluginBind.setFid(dynamicObject.getLong("dybindid"));
        dynPluginBind.setOperationkey(dynamicObject.getString("opcode"));
        String enable = dynamicObject.getString("enable");
        dynPluginBind.setEnable("false".equals(enable) ? "0" : "1");
        dynPluginBind.setObjecttype(formId);
        ApiResult result = DynamicPluginServiceHelper.saveDynPluginBind((DynPluginBind)dynPluginBind);
        if (!result.isStatus()) {
            this.getOption().setVariableValue("bindresult", "false");
            this.getOption().setVariableValue("failmsg", result.getMessage());
        }
    }
}

