/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.kingscript.vscode.DevPortalPermissionUtil;
import kd.bos.kingscript.vscode.IvsCodeListener;
import kd.bos.kingscript.vscode.PushContent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.dynplugin.DynPlugin;
import kd.bos.service.dynplugin.DynPluginBind;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.dynplugin.DynamicPluginServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;

public class BindTsPlugin
extends AbstractFormPlugin
implements ItemClickListener,
TreeNodeClickListener,
TreeNodeQueryListener,
IvsCodeListener,
SearchEnterListener {
    private static final Log LOG = LogFactory.getLog(BindTsPlugin.class);
    private static final String BOS_KINGSCRIPT_CONSOLE = "bos-kingscript-console";
    private static final String KEY_OPERATION = "opcode";

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.addItemClickListeners(new String[]{"bind", "unbind", "dynamicbind", "optoolbar"});
        this.addClickListeners(new String[]{KEY_OPERATION});
    }

    public void afterCreateNewData(EventObject e) {
        PushContent pushContent = new PushContent();
        pushContent.setAction("get_applist");
        pushContent.setPushClass("BindPlugin");
        pushContent.setPageId(this.getView().getPageId());
        pushContent.pushMessage(this.getView());
    }

    private void renderTree(Set<String> appNumbers) {
        TreeNode cloudTreeRoot = this.getCloudAndAppTree(appNumbers);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.setMulti(false);
        treeView.addNode(cloudTreeRoot);
        this.getPageCache().put("treeCache", SerializationUtils.toJsonString((Object)cloudTreeRoot));
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "opcode": {
                Object objecttypeid;
                TreeView treeView = (TreeView)this.getControl("treeviewap");
                Map foccusNodeMap = treeView.getTreeState().getFocusNode();
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int focusRow = entryGrid.getEntryState().getFocusRow();
                if (focusRow == -1 || foccusNodeMap.isEmpty() || (objecttypeid = foccusNodeMap.get("text")) == null) break;
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("bos_vsselectop");
                parameter.setCustomParam("entityId", (Object)((String)objecttypeid));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_vsselectop"));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bind".equals(key)) {
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            Map focusNodeMap = treeView.getTreeState().getFocusNode();
            if (focusNodeMap == null || focusNodeMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7ed1\u5b9a\u7684\u8868\u5355", (String)"BindTsPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                return;
            }
            String focusApp = (String)focusNodeMap.get("parentid");
            String focusForm = (String)focusNodeMap.get("id");
            TreeNode treeNodeRoot = this.getTreeNodeRoot();
            if (StringUtils.isBlank((CharSequence)focusForm) || Objects.requireNonNull(treeNodeRoot).getTreeNode(focusForm) == null || !"formNode".equals(treeNodeRoot.getTreeNode(focusForm).getType())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7ed1\u5b9a\u7684\u8868\u5355", (String)"BindTsPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_vsbindplugin");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("curapp", (Object)focusApp);
            formShowParameter.setCustomParam("formid", (Object)focusForm);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_vsbindplugin"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        if (e.getReturnData() == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "bos_vsselectop": {
                Map ruleMap = (Map)e.getReturnData();
                if (ruleMap.get("returnDataSelectedOperation") == null) break;
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int focusRow = entryGrid.getEntryState().getFocusRow();
                this.getModel().setValue(KEY_OPERATION, ruleMap.get("returnDataSelectedOperation"), focusRow);
                break;
            }
            case "bos_vsbindplugin": {
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)e.getReturnData();
                this.fillTable(dynamicObjects);
                break;
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String session = (String)e.getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String session = (String)this.getView().getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (!this.isFormNode(formOperate)) {
            args.setCancel(true);
            return;
        }
        int[] selectRows = ((EntryGrid)this.getControl("entryentity")).getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"BindTsPlugin_2", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        formOperate.getOption().setVariableValue("selectrows", SerializationUtils.toJsonString((Object)selectRows));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (("bind".equals(opKey) || "unbind".equals(opKey)) && this.isFormNode(formOperate)) {
            this.fillTable(formOperate.getOption().getVariableValue("formid"));
        }
        if ("dynamicbind".equals(opKey)) {
            OperateOption option = formOperate.getOption();
            if (option.containsVariable("bindresult") && "false".equals(option.getVariableValue("bindresult"))) {
                String failMsg = formOperate.getOption().getVariableValue("failmsg");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0 %s", (String)"BindTsPlugin_4", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]), failMsg));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BindTsPlugin_3", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                if (this.isFormNode(formOperate)) {
                    this.fillTable(formOperate.getOption().getVariableValue("formid"));
                }
            }
        }
    }

    private TreeNode getCloudAndAppTree(Set<String> bizAppNumbers) {
        ArrayList<String> bizAppIdList = new ArrayList<String>();
        if (!bizAppNumbers.isEmpty()) {
            List apps = AppUtils.getApps((QFilter[])new QFilter[]{new QFilter("number", "in", bizAppNumbers)}, (boolean)false);
            for (DynamicObject dynamicObject : apps) {
                bizAppIdList.add(dynamicObject.getString("id"));
            }
        }
        String[] bizAppIds = null;
        if (!bizAppIdList.isEmpty()) {
            bizAppIds = bizAppIdList.toArray(new String[bizAppIdList.size()]);
        }
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, (String[])bizAppIds, null, (String)"app", (boolean)false, (boolean)true, (boolean)true);
        for (TreeNode cloudNode : treeRoot.getChildren()) {
            for (TreeNode appNode : cloudNode.getChildren()) {
                appNode.setChildren(new ArrayList(0));
            }
        }
        return treeRoot;
    }

    private TreeNode getTreeNodeRoot() {
        String cache = this.getPageCache().get("treeCache");
        if (StringUtils.isBlank((CharSequence)cache)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        TreeView tree = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        TreeNode treeNodeRoot = this.getTreeNodeRoot();
        if (treeNodeRoot == null) {
            return;
        }
        TreeNode node = treeNodeRoot.getTreeNode(nodeId, 5);
        if (node == null) {
            return;
        }
        Set<String> loadedAppSet = this.getLoadedAppSet();
        String data = String.valueOf(node.getData());
        if (StringUtils.equals((CharSequence)String.valueOf(data), (CharSequence)"app") && !loadedAppSet.contains(nodeId)) {
            String appId = node.getId();
            Map<String, List<TreeNode>> childrenMap = this.getChildrenMapByAppIds(new Object[]{appId});
            node.setChildren((List)childrenMap.getOrDefault(appId, new ArrayList(0)));
            this.getPageCache().put("treeCache", SerializationUtils.toJsonString((Object)treeNodeRoot));
            tree.updateNode(node);
            tree.expand(nodeId);
            return;
        }
        tree.expand(nodeId);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        TreeNode treeNodeRoot = this.getTreeNodeRoot();
        if (treeNodeRoot != null) {
            Set<String> loadedAppSet = this.getLoadedAppSet();
            TreeNode currNode = treeNodeRoot.getTreeNode(nodeId);
            if (StringUtils.equals((CharSequence)String.valueOf(currNode.getData()), (CharSequence)"app")) {
                this.getPageCache().put("curapp", currNode.getId());
                if (!loadedAppSet.contains(currNode.getId())) {
                    String appId = currNode.getId();
                    Map<String, List<TreeNode>> childrenMap = this.getChildrenMapByAppIds(new Object[]{appId});
                    currNode.setChildren((List)childrenMap.getOrDefault(appId, new ArrayList(0)));
                    this.getPageCache().put("treeCache", SerializationUtils.toJsonString((Object)treeNodeRoot));
                    TreeView tree = (TreeView)this.getView().getControl("treeviewap");
                    tree.updateNode(currNode);
                    loadedAppSet.add(currNode.getId());
                    this.getPageCache().put("LOADED_APP_ID_SET", SerializationUtils.toJsonString(loadedAppSet));
                }
            }
            if (StringUtils.equals((CharSequence)String.valueOf(currNode.getType()), (CharSequence)"formNode")) {
                this.getPageCache().put("curform", currNode.getId());
            }
            if (!StringUtils.equals((CharSequence)String.valueOf(currNode.getData()), (CharSequence)"app") && !StringUtils.equals((CharSequence)String.valueOf(currNode.getData()), (CharSequence)"cloud")) {
                this.fillTable(nodeId);
            }
        }
    }

    private void fillTable(String nodeId) {
        DynPluginBind bind = new DynPluginBind();
        bind.setObjecttype(nodeId);
        DynPlugin dynPlugin = new DynPlugin();
        dynPlugin.setEventmethod("ALL");
        List dynPlugins = DynamicPluginServiceHelper.loadDynPluginBind((DynPlugin)dynPlugin, (DynPluginBind)bind);
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (!dynPlugins.isEmpty()) {
            int[] rowKeys = model.batchCreateNewEntryRow("entryentity", dynPlugins.size());
            int row = 0;
            for (DynamicObject dyPlugin : dynPlugins) {
                DynamicObject ksPlugin = dyPlugin.getDynamicObject("dynplugin");
                model.setValue("dybindid", dyPlugin.get("id"), rowKeys[row]);
                model.setValue("plugin", ksPlugin.get("number"), rowKeys[row]);
                model.setValue("plugindesc", (Object)ksPlugin.getString("plugindesc"), rowKeys[row]);
                model.setValue("plugintype", ksPlugin.get("interfacetype"), rowKeys[row]);
                model.setValue(KEY_OPERATION, (Object)dyPlugin.getString("operationkey"), rowKeys[row]);
                model.setValue("enable", dyPlugin.get("enable"), rowKeys[row]);
                ++row;
            }
            if (row > 0) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bind", "unbind"});
            }
        }
    }

    private void fillTable(DynamicObjectCollection dynamicObjects) {
        int size = dynamicObjects.size();
        if (size != 0) {
            IDataModel model = this.getModel();
            int length = model.getEntryEntity("entryentity").size();
            int[] rowKeys = model.batchCreateNewEntryRow("entryentity", size);
            int row = 0;
            for (DynamicObject dyPlugin : dynamicObjects) {
                model.setValue("plugin", dyPlugin.get("plugin"), length + row);
                model.setValue("plugintype", (Object)"1", length + row);
                model.setValue("enable", (Object)"1", length + row);
                ++row;
            }
        }
    }

    private Set<String> getLoadedAppSet() {
        Set<String> loadedAppSet = new LinkedHashSet<String>(16);
        String loadAppIdSetJson = this.getPageCache().get("LOADED_APP_ID_SET");
        if (StringUtils.isNotBlank((CharSequence)loadAppIdSetJson)) {
            loadedAppSet = (Set)SerializationUtils.fromJsonString((String)loadAppIdSetJson, Set.class);
        }
        return loadedAppSet;
    }

    private Map<String, List<TreeNode>> getChildrenMapByAppIds(Object[] appIds) {
        if (appIds == null || appIds.length == 0) {
            return new HashMap<String, List<TreeNode>>(0);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select t.FID, t.FBIZAPPID,t.FNUMBER, tl.FNAME, tp.fmasterid from T_META_FORMDESIGN as t ", new Object[0]).append("left join T_META_FORMDESIGN_L as tl on t.FID=tl.FID ", new Object[0]).append("left join t_meta_bizapp as tp on  t.fbizappid = tp.fid ", new Object[0]).append(" where (", new Object[0]).appendIn("t.fbizappid", appIds).append(")", new Object[0]).append(" and t.FISTEMPLATE = '0' and tl.FLOCALEID='" + RequestContext.get().getLang().name() + "' and ", new Object[0]).append("t.FMODELTYPE in ('BaseFormModel','BillFormModel','DynamicFormModel')", new Object[0]);
        String sqlStrEntityId = RunModeServiceHelper.getEntityNumFromBlacklist();
        if (StringUtils.isNotEmpty((CharSequence)sqlStrEntityId)) {
            sqlBuilder.append(" and t.FID not in (" + sqlStrEntityId + ")", new Object[0]);
        }
        ResultSetHandler action = rs -> {
            HashMap<String, List> appNodesMap = new HashMap<String, List>(16);
            while (rs.next()) {
                String fid = rs.getString(1);
                String bizAppId = rs.getString(2);
                if (StringUtils.isBlank((CharSequence)fid)) continue;
                TreeNode node = new TreeNode();
                String number = rs.getString(3);
                String name = rs.getString(4) == null ? "" : rs.getString(4);
                node.setText(name + "(" + number + ")");
                node.setParentid(bizAppId);
                node.setId(fid);
                node.setType("formNode");
                List treeNodes = appNodesMap.getOrDefault(node.getParentid(), new ArrayList(10));
                treeNodes.add(node);
                appNodesMap.put(node.getParentid(), treeNodes);
            }
            for (Map.Entry entry : appNodesMap.entrySet()) {
                List treeNodes = (List)entry.getValue();
                treeNodes.sort(Comparator.comparing(TreeNode::getText).thenComparing(TreeNode::getId));
            }
            return appNodesMap;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
    }

    @Override
    public void doAction(PushContent pushContent) {
        switch (pushContent.getAction()) {
            case "get_applist": {
                this.extractAppNumber(pushContent.getPropValue());
            }
        }
    }

    private void extractAppNumber(Map<String, Object> appParam) {
        if (appParam == null || appParam.isEmpty()) {
            return;
        }
        HashSet<String> appNumberSet = new HashSet<String>();
        Object appList = appParam.get("appinfo");
        if (appList != null) {
            for (Map app : (List)appList) {
                appNumberSet.add((String)app.get("number"));
            }
        }
        this.renderTree(appNumberSet);
    }

    public void search(SearchEnterEvent evt) {
        evt.getSource();
    }

    private boolean isFormNode(FormOperate formOperate) {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        Map focusNodeMap = treeView.getTreeState().getFocusNode();
        if (focusNodeMap == null || focusNodeMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7ed1\u5b9a\u7684\u8868\u5355", (String)"BindTsPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return false;
        }
        String focusApp = (String)focusNodeMap.get("parentid");
        String focusForm = (String)focusNodeMap.get("id");
        TreeNode treeNodeRoot = this.getTreeNodeRoot();
        if (StringUtils.isBlank((CharSequence)focusForm) || Objects.requireNonNull(treeNodeRoot).getTreeNode(focusForm) == null || !"formNode".equals(treeNodeRoot.getTreeNode(focusForm).getType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7ed1\u5b9a\u7684\u8868\u5355", (String)"BindTsPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return false;
        }
        formOperate.getOption().setVariableValue("curapp", focusApp);
        this.getPageCache().put("curapp", focusApp);
        formOperate.getOption().setVariableValue("formid", focusForm);
        return true;
    }
}

