/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.kingscript.vscode.CacheTree;

public class CacheTreeManager {
    private String cacheKey;
    private IPageCache pageCache;
    private List<CacheTree> cacheTrees = new ArrayList<CacheTree>(16);
    private Map<String, CacheTree> cacheTreeMap = new HashMap<String, CacheTree>(16);

    public CacheTreeManager(String cacheKey, IPageCache pageCache) {
        this.cacheKey = cacheKey;
        String s = pageCache.get(cacheKey);
        if (s != null) {
            this.cacheTrees = SerializationUtils.fromJsonStringToList((String)s, CacheTree.class);
            this.cacheTrees.forEach(o -> this.cacheTreeMap.put(o.getId(), (CacheTree)o));
        }
        this.pageCache = pageCache;
    }

    public static void initCacheTreeManager(String cacheKey, IPageCache pageCache, TreeNode treeNode) {
        ArrayList<CacheTree> cacheTrees = new ArrayList<CacheTree>(16);
        CacheTreeManager.fillCacheTree(cacheTrees, treeNode);
        pageCache.put(cacheKey, SerializationUtils.toJsonString(cacheTrees));
    }

    private static void fillCacheTree(List<CacheTree> list, TreeNode treeNode) {
        CacheTree cacheTree = new CacheTree(treeNode.getId(), treeNode.getText(), treeNode.getParentid(), treeNode.getData());
        list.add(cacheTree);
        List children = treeNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                CacheTreeManager.fillCacheTree(list, child);
            }
        }
    }

    public List<CacheTree> getList() {
        return this.cacheTrees;
    }

    public List<CacheTree> getSelectedList() {
        ArrayList<CacheTree> list = new ArrayList<CacheTree>(16);
        this.cacheTrees.forEach(o -> {
            if (o.isSelected()) {
                list.add((CacheTree)o);
            }
        });
        return list;
    }

    public TreeNode getSelectedTreeNode(String rootId, String rootText) {
        TreeNode treeNode;
        TreeNode rootNode;
        CacheTree cacheTree = this.cacheTreeMap.get(rootId);
        if (cacheTree == null) {
            rootNode = new TreeNode("", rootId, rootText);
        } else {
            rootNode = cacheTree.toTreeNode();
            rootNode.setText(rootText);
        }
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(16);
        treeNodeMap.put(rootId, rootNode);
        List<CacheTree> selectedList = this.getSelectedList();
        for (CacheTree tree : selectedList) {
            if (tree.getId().equals(rootId)) continue;
            treeNode = tree.toTreeNode();
            if (tree.isExists() && "app".equals(tree.getData())) {
                treeNode.setDisabled(true);
                treeNode.setCheckable(false);
            }
            treeNodeMap.put(treeNode.getId(), treeNode);
        }
        for (CacheTree tree : selectedList) {
            treeNode = (TreeNode)treeNodeMap.get(tree.getId());
            TreeNode treeParentNode = (TreeNode)treeNodeMap.get(tree.getParentId());
            if (treeParentNode == null) continue;
            treeParentNode.addChild(treeNode);
        }
        return rootNode;
    }

    public void save() {
        this.pageCache.put(this.cacheKey, SerializationUtils.toJsonString(this.cacheTrees));
    }

    public CacheTree get(String id) {
        return this.cacheTreeMap.get(id);
    }
}

