/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.pushservice.WebSocketIdReader;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;

public class DebugKeepAlivePlugin
extends AbstractFormPlugin {
    public static final String DEBUG_IS_END = "debug is end";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String identifytype = (String)this.getView().getFormShowParameter().getCustomParam("identifytype");
        if (identifytype != null) {
            String sessionId = identifytype.substring(4, identifytype.length() - 5);
            SessionDAO sessionDAOTmp = SessionDAOFactory.getSessionDAO((String)sessionId);
            sessionDAOTmp.setAttribute("pcSessionId", RequestContext.get().getGlobalSessionId());
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("method", "debugSetPCSession");
            map.put("v", "-1");
            if (this.sendMsg(map)) {
                this.getView().addClientCallBack("keepalive", Integer.valueOf(1000));
            } else {
                this.getModel().setValue("txtvalue", (Object)DEBUG_IS_END);
            }
        } else {
            this.getModel().setValue("txtvalue", (Object)DEBUG_IS_END);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String value = (String)this.getModel().getValue("txtvalue");
        long currentValue = 1L;
        if (StringUtils.isNotBlank((CharSequence)value) && !DEBUG_IS_END.equals(value)) {
            currentValue = Long.parseLong(value);
            ++currentValue;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("method", "debugSetPCSession");
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getUserName());
        map.put("v", String.valueOf(currentValue));
        if (this.sendMsg(map)) {
            this.getModel().setValue("txtvalue", (Object)currentValue);
            if (((FormDataModel)this.getModel()).getMainEntityType().findProperty("userinfo") != null) {
                this.getModel().setValue("userinfo", (Object)sb.toString());
            }
            this.getView().addClientCallBack("keepalive", Integer.valueOf(1000));
        } else {
            this.getModel().setValue("txtvalue", (Object)DEBUG_IS_END);
            this.getView().close();
        }
    }

    private boolean sendMsg(Map<String, String> msg) {
        String identifytype = (String)this.getView().getFormShowParameter().getCustomParam("identifytype");
        if (identifytype != null) {
            String sessionId = identifytype.substring(4, identifytype.length() - 5);
            List socketIds = WebSocketIdReader.getWebSocketIds((String)RequestContext.get().getAccountId(), (String)sessionId);
            if (socketIds == null || socketIds.isEmpty()) {
                return false;
            }
            if (!socketIds.contains(identifytype)) {
                return false;
            }
            PushMessage message = new PushMessage(PushMessageRange.RootPage, identifytype, msg);
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(identifytype);
            PushMessagePublisher.sendPushMessage(list, (PushMessage)message);
        }
        return true;
    }
}

