/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DefineAndRegisterPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String focusApp = (String)this.getView().getFormShowParameter().getCustomParam("curapp");
        if (StringUtils.isNotBlank((CharSequence)focusApp)) {
            this.fillEntryData(focusApp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate;
        String opKey;
        Object source = args.getSource();
        if (source instanceof FormOperate && "bind".equals(opKey = (formOperate = (FormOperate)source).getOperateKey())) {
            formOperate.getOption().setVariableValue("formid", (String)this.getView().getFormShowParameter().getCustomParam("formid"));
            int[] selectRows = ((EntryGrid)this.getControl("entryentity")).getSelectRows();
            formOperate.getOption().setVariableValue("selectrows", SerializationUtils.toJsonString((Object)selectRows));
            String focusApp = this.getView().getParentView().getPageCache().get("curapp");
            formOperate.getOption().setVariableValue("curapp", focusApp);
        }
    }

    private void fillEntryData(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        List<Map<String, Object>> entryDatas = this.getAllKingScriptByAppId(new Object[]{appId});
        if (entryDatas.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        int[] rowKeys = model.batchCreateNewEntryRow("entryentity", entryDatas.size());
        int row = 0;
        for (Map<String, Object> record : entryDatas) {
            model.setValue("plugin", record.get("classname"), rowKeys[row]);
            model.setValue("form", record.get("formnumber"), rowKeys[row]);
            model.setValue("scriptname", record.get("scriptname"), rowKeys[row]);
            model.setValue("scriptnumber", record.get("scriptnumber"), rowKeys[row]);
            model.setValue("dynpluginid", record.get("dynplugin_id"), rowKeys[row]);
            model.setValue("dynpluginbindid", record.get("dynpluginbind_id"), rowKeys[row]);
            model.setValue("formid", record.get("formid"), rowKeys[row]);
            ++row;
        }
        this.getView().updateView("entryentity");
    }

    private List<Map<String, Object>> getAllKingScriptByAppId(Object[] appIds) {
        if (appIds == null || appIds.length == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select pls.FID, pls.FSCRIPTNAME, pls.FSCRIPTNUMBER, pls.FBIZAPPID, dyp.FID, pls.FCLASSNAME, fd.FNUMBER, dpb.FID, dpb.FOBJECTTYPEID from T_META_PLUGINSCRIPT as pls ", new Object[0]).append("left join T_META_DYNPLUGIN as dyp on pls.FCLASSNAME = dyp.FCLASSNAME", new Object[0]).append("left join T_META_DYNPLUGINBIND as dpb on dpb.FDYNPLUGINID = dyp.FID ", new Object[0]).append("left join T_META_FORMDESIGN as fd on fd.FID = dpb.FOBJECTTYPEID", new Object[0]).append(" where ", new Object[0]).appendIn("pls.fbizappid", appIds);
        ResultSetHandler action = rs -> {
            ArrayList result = new ArrayList(16);
            while (rs.next()) {
                String className = rs.getString(6);
                if (StringUtils.isBlank((CharSequence)className) || !className.trim().endsWith(".ts")) continue;
                String formNumber = rs.getString(7);
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put("entry_id", rs.getString(1));
                record.put("scriptname", rs.getString(2));
                record.put("scriptnumber", rs.getString(3));
                record.put("classname", className);
                record.put("dynplugin_id", rs.getLong(5));
                record.put("formnumber", formNumber);
                record.put("dynpluginbind_id", rs.getLong(8));
                record.put("formid", rs.getString(9));
                result.add(record);
            }
            return result;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        DynamicObjectCollection returnDynamicCollection = new DynamicObjectCollection();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRowIndex = entryGrid.getSelectRows();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        for (int row : selectRowIndex) {
            returnDynamicCollection.add(dynamicObjects.get(row));
        }
        this.getView().returnDataToParent((Object)returnDynamicCollection);
        this.getView().close();
    }
}

