/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.kingscript.openapi.development.ScriptService;
import kd.bos.kingscript.vscode.DevPortalPermissionUtil;
import kd.bos.kingscript.vscode.IvsCodeListener;
import kd.bos.kingscript.vscode.PushContent;
import kd.bos.kingscript.vscode.TreeViewUtil;
import kd.bos.kingscript.vscode.download.AppAndFileData;
import kd.bos.kingscript.vscode.download.CompareResult;
import kd.bos.kingscript.vscode.download.DownloadTreeManager;
import kd.bos.kingscript.vscode.download.DownloadUtil;
import kd.bos.kingscript.vscode.download.FileInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.CollectionUtils;

public class DownloadTsPlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener,
SearchEnterListener,
IvsCodeListener {
    private static final String BOS_KINGSCRIPT_CONSOLE = "bos-kingscript-console";
    public static final String UPDATE_KINGSCRIPT = "updateKingscript";
    public static final String GET_TREEDATA = "get_treedata";
    private final String TREEVIEWAP = "treeviewap";
    private final String TREE_KEY = "tree_data";
    private final String SEARCH_TREE_KEY = "search_tree";
    private final String SHOW_MODIFIED = "show_unmodified";
    private final String SHOW_NUM = "shownum";
    private final String BTNOK = "btnok";
    private final String REFRESH = "refresh";
    private static final Log logger = LogFactory.getLog(DownloadTsPlugin.class);
    private ScriptService scriptService = (ScriptService)ServiceFactory.getService((String)"ScriptService");
    private static final String VSCODE_FINISHED = "VSCodeFinished";

    public void registerListener(EventObject e) {
        Button downloadBtn = (Button)this.getView().getControl("btnok");
        Button refreshBtn = (Button)this.getView().getControl("refresh");
        Search search = (Search)this.getView().getControl("searchap");
        downloadBtn.addClickListener((ClickListener)this);
        refreshBtn.addClickListener((ClickListener)this);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        Boolean showModified = (Boolean)this.getModel().getValue("show_unmodified");
        Boolean showNum = (Boolean)this.getModel().getValue("shownum");
        TreeNode treeNode = null;
        try {
            String treeJsonString = this.getPageCache().get("tree_data");
            treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treeJsonString, TreeNode.class);
        }
        catch (Exception exception) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u83b7\u53d6\u9875\u9762\u7f13\u5b58\u51fa\u9519\uff01", (String)"DownloadTsPlugin_01", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]), exception.getMessage());
        }
        if (treeNode != null) {
            DownloadTreeManager.removeUnmodifiedNode(treeNode, showModified);
            this.filterTreeNode(treeNode, text);
            TreeViewUtil.convertTreeNodeTextWithNumber(treeNode, showNum);
            treeView.deleteAllNodes();
            treeNode.setIsOpened(Boolean.TRUE.booleanValue());
            treeView.addNode(treeNode);
            this.getPageCache().put("search_tree", SerializationUtils.toJsonString((Object)treeNode));
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String session = (String)e.getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String key;
        String session = (String)this.getView().getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return;
        }
        Control source = (Control)evt.getSource();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        switch (key = source.getKey()) {
            case "btnok": {
                List<Map<String, Object>> selectedNodes = DownloadTsPlugin.getSelectedNodes(treeView);
                if (CollectionUtils.isEmpty(selectedNodes)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DownloadTsPlugin_08", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                    return;
                }
                String str = ResManager.loadKDString((String)"\u4e0b\u8f7d\u4f1a\u66f4\u6539\u4ee5\u4e0b\u6587\u4ef6: ", (String)"DownloadTsPlugin_06", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]) + "\n";
                StringBuilder stringBuffer = new StringBuilder();
                stringBuffer.append(str);
                for (Map<String, Object> selectedNode : selectedNodes) {
                    String text = selectedNode.get("text") + "\n";
                    stringBuffer.append(text);
                }
                stringBuffer.append(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DownloadTsPlugin_02", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                ConfirmCallBackListener operateConfirmCallBackListener = new ConfirmCallBackListener("operate", (IFormPlugin)this);
                this.getView().showConfirm(stringBuffer.toString(), MessageBoxOptions.OKCancel, operateConfirmCallBackListener);
                break;
            }
            case "refresh": {
                treeView.deleteAllNodes();
                this.sendGetTreeMessage();
            }
        }
    }

    private static List<Map<String, Object>> getSelectedNodes(TreeView treeView) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List selectedNodes = treeView.getTreeState().getSelectedNodes();
        for (Map selectedNode : selectedNodes) {
            if (((Boolean)selectedNode.get("isParent")).booleanValue()) continue;
            result.add(selectedNode);
        }
        return result;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "operate": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                this.disableDownloadButton();
                this.sendDownloadFileMessage();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        Boolean showUnmodified = (Boolean)this.getModel().getValue("show_unmodified");
        Boolean showNum = (Boolean)this.getModel().getValue("shownum");
        treeView.deleteAllNodes();
        try {
            String treeJsonString = this.getPageCache().get("search_tree");
            if (StringUtils.isBlank((CharSequence)treeJsonString)) {
                treeJsonString = this.getPageCache().get("tree_data");
            }
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)treeJsonString, TreeNode.class);
            DownloadTreeManager.removeUnmodifiedNode(rootNode, showUnmodified);
            TreeViewUtil.convertTreeNodeTextWithNumber(rootNode, showNum);
            treeView.addNode(rootNode);
        }
        catch (Exception exception) {
            logger.error("Switch SHOW_MODIFIED status error:", (Throwable)exception);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.sendGetTreeMessage();
    }

    private void sendGetTreeMessage() {
        PushContent pushContent = new PushContent();
        pushContent.setAction(GET_TREEDATA);
        pushContent.setPushClass(UPDATE_KINGSCRIPT);
        pushContent.setPageId(this.getView().getPageId());
        pushContent.setPropVaule(new HashMap<String, Object>());
        pushContent.pushMessage(this.getView());
    }

    @Override
    public void doAction(PushContent pushContent) {
        switch (pushContent.getAction()) {
            case "get_treedata": {
                this.renderTreeData(pushContent);
                break;
            }
            case "VSCodeFinished": {
                this.enableDownloadButton();
            }
        }
    }

    private void renderTreeData(PushContent pushContent) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        Map<String, Object> propValue = pushContent.getPropValue();
        List treeData = (List)propValue.get("treeData");
        List<AppAndFileData> appAndFileDataList = DownloadUtil.convertTreeData(treeData);
        Map<String, AppAndFileData> idEntityIndex = DownloadUtil.buildIdEntityIndex(appAndFileDataList);
        String[] appIds = idEntityIndex.keySet().toArray(new String[0]);
        String isv = ISVServiceHelper.getISVInfo().getId();
        Map apps = BusinessDataReader.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("isv", "=", (Object)isv).and("id", "in", (Object)appIds)});
        Set fids = apps.keySet();
        if (fids.isEmpty()) {
            logger.info(String.format("isv:%s data is empty", isv));
            return;
        }
        TreeNode rootNode = (TreeNode)BizAppServiceHelp.getSubsysTree(null, (String[])fids.toArray(new String[0]), null, (String)"app", (boolean)false, (boolean)true, (boolean)true);
        this.buildFileNode(rootNode, idEntityIndex);
        Boolean onlyShowModified = (Boolean)this.getModel().getValue("show_unmodified");
        Boolean showNumber = (Boolean)this.getModel().getValue("shownum");
        TreeViewUtil.convertTreeNodeTextWithNumber(rootNode, showNumber);
        this.getPageCache().put("tree_data", SerializationUtils.toJsonString((Object)rootNode));
        DownloadTreeManager.removeUnmodifiedNode(rootNode, onlyShowModified);
        treeView.addNode(rootNode);
        treeView.setMulti(true);
    }

    private void buildFileNode(TreeNode rootNode, Map<String, AppAndFileData> idEntityIndex) {
        for (TreeNode cloudNode : rootNode.getChildren()) {
            Iterator appNodeIterator = cloudNode.getChildren().iterator();
            while (appNodeIterator.hasNext()) {
                TreeNode appNode = (TreeNode)appNodeIterator.next();
                this.addFileNode(appNode, idEntityIndex);
                List children = appNode.getChildren();
                if (!CollectionUtils.isEmpty((Collection)children)) continue;
                appNodeIterator.remove();
            }
        }
    }

    private void addFileNode(TreeNode appNode, Map<String, AppAndFileData> idEntityIndex) {
        String appId = appNode.getId();
        this.compareAppScript(appId, idEntityIndex);
        AppAndFileData appAndFileData = idEntityIndex.get(appId);
        String appNumber = appAndFileData.getNumber();
        List<FileInfo> files = appAndFileData.getFiles();
        DownloadTreeManager.addFileNode(appNode, files, appNumber, appId);
    }

    private void filterFileNode(Iterator<TreeNode> fileNodeIterator, String text) {
        while (fileNodeIterator.hasNext()) {
            TreeNode node = fileNodeIterator.next();
            Object data = node.getData();
            if ("folder".equals(data)) {
                List children = node.getChildren();
                if (children != null) {
                    Iterator<TreeNode> iterator = children.iterator();
                    this.filterFileNode(iterator, text);
                }
                if (CollectionUtils.isEmpty((Collection)children)) {
                    fileNodeIterator.remove();
                    continue;
                }
            }
            if ("folder".equals(data) || node.getText().contains(text)) continue;
            fileNodeIterator.remove();
        }
    }

    private void filterTreeNode(TreeNode treeNode, String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            Iterator iterator = treeNode.getChildren().iterator();
            while (iterator.hasNext()) {
                Boolean isQueryScript = Boolean.TRUE;
                TreeNode cloudNode = (TreeNode)iterator.next();
                cloudNode.setIsOpened(Boolean.TRUE.booleanValue());
                List appChild = cloudNode.getChildren();
                Iterator appNodeIterator = appChild.iterator();
                for (TreeNode node : appChild) {
                    String nodeText = node.getText();
                    int index = nodeText.indexOf(40);
                    if (index != -1) {
                        String appName = nodeText.substring(0, index);
                        String appNumber = nodeText.substring(index + 1, nodeText.length() - 1);
                        if (text.equals(appName) || text.equals(appNumber)) {
                            isQueryScript = Boolean.FALSE;
                            break;
                        }
                    }
                    if (!nodeText.equals(text)) continue;
                    isQueryScript = Boolean.FALSE;
                    break;
                }
                while (appNodeIterator.hasNext()) {
                    TreeNode appNode = (TreeNode)appNodeIterator.next();
                    List fileNodeList = appNode.getChildren();
                    if (fileNodeList == null) continue;
                    if (isQueryScript.booleanValue()) {
                        this.filterFileNode(fileNodeList.iterator(), text);
                    }
                    if (CollectionUtils.isEmpty((Collection)fileNodeList)) {
                        appNodeIterator.remove();
                        continue;
                    }
                    appNode.setIsOpened(Boolean.TRUE.booleanValue());
                }
                if (CollectionUtils.isNotEmpty((Collection)appChild)) {
                    if (isQueryScript.booleanValue()) continue;
                    appChild.removeIf(o -> !o.getText().contains(text));
                    if (CollectionUtils.isEmpty((Collection)appChild)) {
                        iterator.remove();
                        continue;
                    }
                    for (TreeNode node : appChild) {
                        node.setIsOpened(Boolean.TRUE.booleanValue());
                    }
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private void compareAppScript(String appId, Map<String, AppAndFileData> idEntityIndex) {
        List<String> filePaths = DownloadUtil.getFilePathByAppId(appId, idEntityIndex);
        String appNumber = idEntityIndex.get(appId).getNumber();
        CustomApiResult<Map<String, String>> customApiResult = this.scriptService.compareScripts(0, appNumber, filePaths);
        if (customApiResult.isStatus()) {
            Map data = (Map)customApiResult.getData();
            Set cloudFilePathSet = data.keySet();
            Iterator iterator = cloudFilePathSet.iterator();
            AppAndFileData appAndFileData = idEntityIndex.get(appId);
            List<FileInfo> files = appAndFileData.getFiles();
            while (iterator.hasNext()) {
                String cloudFilePath = (String)iterator.next();
                for (FileInfo file2 : files) {
                    if (!cloudFilePath.equals(file2.getFilePath())) continue;
                    String cloudContent = (String)data.get(cloudFilePath);
                    if (cloudContent.equals(file2.getContent())) {
                        file2.setCompareResult(CompareResult.UNMODIFIED);
                    } else {
                        file2.setCompareResult(CompareResult.MODIFIED);
                    }
                    iterator.remove();
                }
            }
            if (cloudFilePathSet.size() > 0) {
                for (String cloudFilePath : cloudFilePathSet) {
                    FileInfo fileInfo = new FileInfo();
                    fileInfo.setFileName(DownloadUtil.extractFileName(cloudFilePath));
                    fileInfo.setFilePath(cloudFilePath);
                    fileInfo.setCompareResult(CompareResult.ADD);
                    files.add(fileInfo);
                }
            }
            files.removeIf(file -> file.getCompareResult() == null);
        } else {
            System.out.println(ResManager.loadKDString((String)"\u83b7\u53d6\u811a\u672c\u6bd4\u5bf9\u7ed3\u679c\u51fa\u9519\uff01", (String)"DownloadTsPlugin_04", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            System.out.println(customApiResult.getErrorCode() + "\n" + customApiResult.getMessage());
        }
    }

    private void sendDownloadFileMessage() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List<Map<String, Object>> selectedNodes = DownloadTsPlugin.getSelectedNodes(treeView);
        if (selectedNodes.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4e0b\u8f7d\u7684\u811a\u672c\uff01", (String)"DownloadTsPlugin_05", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
        PushContent pushContent = this.getPushContent(selectedNodes);
        pushContent.pushMessage(this.getView());
    }

    private PushContent getPushContent(List<Map<String, Object>> selectedNodes) {
        ArrayList<String> appIds = new ArrayList<String>(selectedNodes.size());
        ArrayList<String> fileNames = new ArrayList<String>(selectedNodes.size());
        for (Map<String, Object> selectedNode : selectedNodes) {
            if (((Boolean)selectedNode.get("isParent")).booleanValue()) continue;
            String parentid = DownloadUtil.convertParentId((String)selectedNode.get("parentid"));
            appIds.add(parentid);
            fileNames.add((String)selectedNode.get("text"));
        }
        List<String> appNumbers = DownloadUtil.getAppNumberById(appIds);
        List<Map<String, String>> toBeModifiFiles = this.getToBeModifiFiles(appNumbers, fileNames);
        HashMap<String, Object> propValue = new HashMap<String, Object>();
        propValue.put("files", toBeModifiFiles);
        PushContent pushContent = new PushContent();
        pushContent.setPushClass(UPDATE_KINGSCRIPT);
        pushContent.setAction("write_file");
        pushContent.setPageId(this.getView().getPageId());
        pushContent.setPropVaule(propValue);
        return pushContent;
    }

    private List<Map<String, String>> getToBeModifiFiles(List<String> appNumbers, List<String> fileNames) {
        ArrayList<Map<String, String>> toBeModifieFiles = new ArrayList<Map<String, String>>();
        for (String appNumber : appNumbers) {
            CustomApiResult<Map<String, String>> apiResult = this.scriptService.searchScripts(appNumber);
            if (apiResult.isStatus()) {
                Map data = (Map)apiResult.getData();
                HashMap<String, String> fileNameIndex = new HashMap<String, String>(data.size());
                for (String cloudFilePath : data.keySet()) {
                    String fileName = cloudFilePath.substring(cloudFilePath.lastIndexOf(47) + 1);
                    fileNameIndex.put(fileName, cloudFilePath);
                }
                for (String fileName : fileNames) {
                    String filePath = (String)fileNameIndex.get(fileName);
                    HashMap<String, String> fileData = new HashMap<String, String>();
                    if (data.get(filePath) == null) continue;
                    fileData.put("filePath", filePath);
                    fileData.put("content", (String)data.get(filePath));
                    toBeModifieFiles.add(fileData);
                }
                continue;
            }
            System.out.println("\u83b7\u53d6\u811a\u672c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return toBeModifieFiles;
    }

    private void enableDownloadButton() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"btnok"});
    }

    private void disableDownloadButton() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
    }
}

