/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.kingscript.openapi.development.PublishService;
import kd.bos.kingscript.openapi.development.helper.ScriptDBHelper;
import kd.bos.kingscript.vscode.CacheTree;
import kd.bos.kingscript.vscode.CacheTreeManager;
import kd.bos.kingscript.vscode.DevPortalPermissionUtil;
import kd.bos.kingscript.vscode.IvsCodeListener;
import kd.bos.kingscript.vscode.PushContent;
import kd.bos.kingscript.vscode.TreeViewUtil;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.util.ConfigurationUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ExportScriptMetadataPlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener,
IvsCodeListener {
    private static final String BOS_KINGSCRIPT_CONSOLE = "bos-kingscript-console";
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";
    public static final String PROJECT = "ExportMetaData";
    public static final String INIT = "init";
    public static final String ROOTNODE = "rootNode";
    public static final String TREE_CACHE = "treeCache";
    private static final String DCS_AUTO_GIT = "kingscript.dcs.autogit";
    private static boolean disable = Boolean.getBoolean("kingscript.dcs.autogit");
    private PublishService publishService = new PublishService();

    private static void loadConfig(Object value) {
        Boolean _disable = null;
        try {
            _disable = Boolean.parseBoolean(value.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_disable != null) {
            disable = _disable;
        }
    }

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView selectedTree = (TreeView)this.getView().getControl("selectedtree");
        selectedTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"create", "btnadd", "btndel"});
        Search searchsrc = (Search)this.getControl("searchsrc");
        searchsrc.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent evt) {
                String text = evt.getText();
                TreeNode cloudTreeRoot = ExportScriptMetadataPlugin.this.getCloudAndAppTree(ExportScriptMetadataPlugin.this.getBizAppIds());
                ExportScriptMetadataPlugin.this.filterTreeNode(cloudTreeRoot, text);
                TreeView treeView = (TreeView)ExportScriptMetadataPlugin.this.getView().getControl("treeviewap");
                treeView.setMulti(true);
                treeView.deleteAllNodes();
                treeView.addNode(cloudTreeRoot);
            }
        });
        Search searchdist = (Search)this.getControl("searchdist");
        searchdist.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent evt) {
                String text = evt.getText();
                CacheTreeManager cacheTreeManager = new CacheTreeManager(ExportScriptMetadataPlugin.TREE_CACHE, ExportScriptMetadataPlugin.this.getPageCache());
                TreeNode treeNode = cacheTreeManager.getSelectedTreeNode(ExportScriptMetadataPlugin.ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009", (String)"ExportScriptMetadataPlugin_1", (String)ExportScriptMetadataPlugin.BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                ExportScriptMetadataPlugin.this.filterTreeNode(treeNode, text);
                TreeView treeView = (TreeView)ExportScriptMetadataPlugin.this.getView().getControl("selectedtree");
                treeView.setMulti(true);
                treeView.deleteAllNodes();
                treeView.addNode(treeNode);
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String session = (String)e.getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        this.doSendVSCode(INIT, null);
    }

    private void loadTreeData(String[] bizAppIds) {
        TreeNode cloudTreeRoot = this.getCloudAndAppTree(bizAppIds);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.setMulti(true);
        treeView.addNode(cloudTreeRoot);
        CacheTreeManager.initCacheTreeManager(TREE_CACHE, this.getPageCache(), cloudTreeRoot);
        TreeNode selectedTreeRoot = this.renderSelectTreeRoot(null);
        TreeView selectedTreeView = (TreeView)this.getView().getControl("selectedtree");
        selectedTreeView.addNode(selectedTreeRoot);
    }

    private void doSendVSCode(String action, Map<String, Object> propValue) {
        PushContent pushContent = new PushContent();
        pushContent.setAction(action);
        pushContent.setPushClass(PROJECT);
        pushContent.setPageId(this.getView().getPageId());
        if (propValue != null) {
            pushContent.setPropVaule(propValue);
        }
        pushContent.pushMessage(this.getView());
    }

    public void click(EventObject evt) {
        String key;
        String session = (String)this.getView().getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return;
        }
        Object source = evt.getSource();
        switch (key = ((Control)source).getKey()) {
            case "create": {
                try {
                    this.doSendVSCode("upload_script_metadata", this.uploadScriptMetadata());
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            case "btnadd": {
                TreeView tree = (TreeView)this.getView().getControl("treeviewap");
                List selectedNodes = tree.getTreeState().getSelectedNodes();
                if (!selectedNodes.isEmpty()) {
                    this.addSelectedNode(selectedNodes);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u3002", (String)"ExportScriptMetadataPlugin_2", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                break;
            }
            case "btndel": {
                CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
                TreeView selectedTreeView = (TreeView)this.getView().getControl("selectedtree");
                List selectedNodes = selectedTreeView.getTreeState().getSelectedNodes();
                ArrayList<String> treeNodeList = new ArrayList<String>(10);
                if (!selectedNodes.isEmpty()) {
                    for (Map node : selectedNodes) {
                        String id = (String)node.get("id");
                        CacheTree tree = cacheTreeManager.get(id);
                        if (ROOTNODE.equals(id) || tree.isExists()) continue;
                        tree.setSelected(false);
                        treeNodeList.add(id);
                    }
                }
                if (treeNodeList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u3002", (String)"ExportScriptMetadataPlugin_2", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                } else {
                    selectedTreeView.deleteNodes(treeNodeList);
                }
                cacheTreeManager.save();
                break;
            }
        }
    }

    private Map<String, Object> uploadScriptMetadata() throws IOException {
        String tenantCode;
        CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
        List<CacheTree> selectedNodes = cacheTreeManager.getSelectedList();
        if (CollectionUtils.isEmpty(selectedNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DownloadTsPlugin_08", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return new HashMap<String, Object>(1);
        }
        Map<String, List<CacheTree>> selectedNodesByApp = selectedNodes.stream().filter(x -> "ts".equals(x.getData())).collect(Collectors.groupingBy(CacheTree::getParentId));
        if (MapUtils.isEmpty(selectedNodesByApp)) {
            return new HashMap<String, Object>(1);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.uploadTs(selectedNodesByApp, result);
        RequestContext ctx = RequestContext.get();
        if (ctx != null && (tenantCode = ctx.getTenantCode()) != null && !tenantCode.isEmpty()) {
            StringBuilder sb = new StringBuilder(tenantCode).append("_").append(DCS_AUTO_GIT);
            disable = Boolean.getBoolean(sb.toString());
        }
        result.put("autoGit", disable);
        return result;
    }

    private void uploadTs(Map<String, List<CacheTree>> selectedNodesByApp, Map<String, Object> result) throws IOException {
        for (Map.Entry<String, List<CacheTree>> entry : selectedNodesByApp.entrySet()) {
            String appId = entry.getKey();
            List<CacheTree> nodes = entry.getValue();
            String appNumber = AppReader.getAppNumberById((String)appId);
            CustomApiResult<String> apiResult = this.publishService.publishXML(1, appNumber, nodes.stream().map(CacheTree::getId).collect(Collectors.toList()));
            if (!apiResult.isStatus()) {
                Object errors = result.computeIfAbsent("error", s -> new ArrayList());
                if (!(errors instanceof List)) continue;
                ((List)errors).add(apiResult.getErrorCode() + " - " + apiResult.getMessage());
                continue;
            }
            List scripts = nodes.stream().map(CacheTree::getId).collect(Collectors.toList());
            result.put("uploadts", scripts);
            Object datas = result.computeIfAbsent("data", s -> new ArrayList());
            if (!(datas instanceof List)) continue;
            ((List)datas).add(apiResult.getData());
        }
    }

    private void uploadDynplugin(Map<String, List<CacheTree>> selectedNodesByApp, Map<String, Object> result) {
        for (Map.Entry<String, List<CacheTree>> entry : selectedNodesByApp.entrySet()) {
            String appId = entry.getKey();
            List<CacheTree> nodes = entry.getValue();
            CustomApiResult<List<String>> apiResult = this.publishService.publishDynpluginXML(nodes.stream().map(CacheTree::getId).collect(Collectors.toList()));
            if (!apiResult.isStatus()) {
                Object errors = result.computeIfAbsent("bind_error", s -> new ArrayList());
                if (!(errors instanceof List)) continue;
                ((List)errors).add(apiResult.getErrorCode() + " - " + apiResult.getMessage());
                continue;
            }
            Object datas = result.computeIfAbsent("bind_data", s -> new ArrayList());
            if (!(datas instanceof List)) continue;
            ((List)datas).addAll((Collection)apiResult.getData());
        }
    }

    private void addSelectedNode(List<Map<String, Object>> selectedNodes) {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
        for (Map<String, Object> node : selectedNodes) {
            CacheTree parentNode;
            String id = (String)node.get("id");
            if (ROOTNODE.equals(id)) continue;
            Object parentNodeId = node.get("parentid");
            if (parentNodeId != null && (parentNode = cacheTreeManager.get((String)parentNodeId)) != null) {
                CacheTree topNode = cacheTreeManager.get((String)parentNode.get("parentid"));
                if (topNode != null) {
                    topNode.setSelected(true);
                    treeNodeList.add(topNode.toTreeNode());
                }
                parentNode.setSelected(true);
                treeNodeList.add(parentNode.toTreeNode());
            }
            CacheTree cacheTree = cacheTreeManager.get(id);
            cacheTree.setSelected(true);
            TreeNode treeNode = new TreeNode((String)parentNodeId, (String)node.get("id"), (String)node.get("text"));
            treeNodeList.add(treeNode);
        }
        TreeView selectedTreeView = (TreeView)this.getView().getControl("selectedtree");
        selectedTreeView.addNodes(treeNodeList);
        selectedTreeView.checkNodes(treeNodeList);
        cacheTreeManager.save();
    }

    private void pushWebsocketMessage(String content) {
        String session = (String)this.getView().getFormShowParameter().getCustomParam("session");
        PushMessage message = new PushMessage(PushMessageRange.Session, session, (Object)content);
        PushServiceHelper.push((PushMessage)message);
    }

    @Override
    public void doAction(PushContent content) {
        switch (content.getAction()) {
            case "init": {
                boolean isProject = (Boolean)content.getPropValue().get("isProject");
                if (!isProject) break;
                List list = (List)content.getPropValue().get("applist");
                String[] numbers = new String[list.size()];
                int i = 0;
                for (Map appMode : list) {
                    numbers[i++] = (String)appMode.get("number");
                }
                if (numbers.length <= 0) break;
                String[] bizAppIds = (String[])Arrays.stream(numbers).map(AppReader::getAppIdByNumber).toArray(String[]::new);
                this.putBizAppIds(bizAppIds);
                this.loadTreeData(bizAppIds);
            }
        }
    }

    private void putBizAppIds(String[] bizAppIds) {
        if (bizAppIds == null) {
            bizAppIds = new String[]{};
        }
        this.getPageCache().put("bizAppIds", SerializationUtils.toJsonString((Object)bizAppIds));
    }

    private String[] getBizAppIds() {
        String bizAppIdStr = this.getPageCache().get("bizAppIds");
        String[] bizAppIds = (String[])SerializationUtils.fromJsonString((String)bizAppIdStr, String[].class);
        if (bizAppIds == null) {
            bizAppIds = new String[]{};
        }
        return bizAppIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("shownum")) {
            TreeNode cloudTreeRoot = this.getCloudAndAppTree(this.getBizAppIds());
            TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
            treeView.setMulti(true);
            treeView.deleteAllNodes();
            treeView.addNode(cloudTreeRoot);
            CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
            TreeNode selectTreeRoot = cacheTreeManager.getSelectedTreeNode(ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009", (String)"ExportScriptMetadataPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            TreeViewUtil.convertTreeNodeTextWithNumber(selectTreeRoot, (Boolean)this.getModel().getValue("shownum"));
            TreeView selectedtree = (TreeView)this.getView().getControl("selectedtree");
            selectedtree.deleteAllNodes();
            selectedtree.addNode(selectTreeRoot);
        }
    }

    private TreeNode getCloudAndAppTree(String[] bizAppIds) {
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, (String[])bizAppIds, null, (String)"app", (boolean)false, (boolean)true, (boolean)true);
        if (treeRoot != null) {
            if (((Boolean)this.getModel().getValue("shownum")).booleanValue() && ((Boolean)this.getModel().getValue("shownum")).booleanValue()) {
                TreeViewUtil.convertTreeNodeTextWithNumber(treeRoot);
            }
            treeRoot.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ExportScriptMetadataPlugin_3", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            Map<String, List<String>> scriptInfosByAppId = ScriptDBHelper.loadScriptPathByBizAppIdFromCache(this.getPageCache());
            List cloudNodes = treeRoot.getChildren();
            for (TreeNode cloudNode : cloudNodes) {
                List appNodes = cloudNode.getChildren();
                if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
                for (TreeNode appNode : appNodes) {
                    String nodeAppId = appNode.getId();
                    List<String> scriptPaths = scriptInfosByAppId.get(nodeAppId);
                    if (CollectionUtils.isEmpty(scriptPaths)) continue;
                    for (String scriptPath : scriptPaths) {
                        TreeNode tsNode = new TreeNode();
                        tsNode.setId(scriptPath);
                        tsNode.setText(this.convertSimpleScriptPath(scriptPath));
                        tsNode.setParentid(nodeAppId);
                        tsNode.setData((Object)"ts");
                        appNode.addChild(tsNode);
                    }
                }
            }
        }
        return treeRoot;
    }

    private String convertSimpleScriptPath(String scriptPath) {
        int lastSlashIndex = scriptPath.lastIndexOf(47);
        return scriptPath.substring(lastSlashIndex + 1);
    }

    private void filterTreeNode(TreeNode treeRoot, String searchText) {
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            Iterator iterator = treeRoot.getChildren().iterator();
            while (iterator.hasNext()) {
                List appChild = ((TreeNode)iterator.next()).getChildren();
                if (appChild == null) continue;
                appChild.removeIf(o -> !o.getText().contains(searchText));
                if (appChild.size() != 0) continue;
                iterator.remove();
            }
        }
    }

    private void disableAllNode(TreeNode treeNode) {
        if (treeNode != null && CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode child : treeNode.getChildren()) {
                if (child.getData().equals("app")) {
                    child.setDisabled(true);
                    child.setCheckable(false);
                }
                this.disableAllNode(child);
            }
        }
    }

    private TreeNode renderSelectTreeRoot(String[] selectAppIds) {
        TreeNode root = null;
        if (selectAppIds != null && selectAppIds.length > 0) {
            root = (TreeNode)BizAppServiceHelp.getSubsysTree(null, (String[])selectAppIds, null, (String)"app", (boolean)false, (boolean)true, (boolean)true);
            if (root != null && CollectionUtils.isNotEmpty((Collection)root.getChildren())) {
                this.disableAllNode(root);
            }
            if (((Boolean)this.getModel().getValue("shownum")).booleanValue()) {
                TreeViewUtil.convertTreeNodeTextWithNumber(root);
            }
        }
        if (root == null) {
            root = new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009", (String)"ExportScriptMetadataPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
        root.setIsOpened(true);
        root.setId(ROOTNODE);
        root.setText(ResManager.loadKDString((String)"\u5df2\u9009", (String)"ExportScriptMetadataPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        return root;
    }

    static {
        ConfigurationUtil.observeChange((String)DCS_AUTO_GIT, (key, newValue) -> ExportScriptMetadataPlugin.loadConfig(newValue));
    }
}

