/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.kingscript.vscode.CacheTree;
import kd.bos.kingscript.vscode.CacheTreeManager;
import kd.bos.kingscript.vscode.DevPortalPermissionUtil;
import kd.bos.kingscript.vscode.IvsCodeListener;
import kd.bos.kingscript.vscode.PushContent;
import kd.bos.kingscript.vscode.TreeViewUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;

public class ProjectGuidPlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener,
TabSelectListener,
IvsCodeListener {
    private static final Log logger = LogFactory.getLog(ProjectGuidPlugin.class);
    private static final String BOS_KINGSCRIPT_CONSOLE = "bos-kingscript-console";
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";
    public static final String CREATE_PROJECT = "CreateProject";
    public static final String INIT = "init";
    public static final String GET_LOCALPATH = "get_localpath";
    public static final String ROOTNODE = "rootNode";
    public static final String TREE_CACHE = "treeCache";
    private static final String FILENAME_PATTERN = "^[^\\s\\.].*[^\\s]$";
    public static final String TEMP_TREE_CACHE = "tempTreeCache";
    private static final String VSCODE_FINISHED = "VSCodeFinished";

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView selectedTree = (TreeView)this.getView().getControl("selectedtree");
        selectedTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"previous", "next", "create", "localpath", "btnadd", "btndel"});
        Search searchsrc = (Search)this.getControl("searchsrc");
        searchsrc.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent evt) {
                String text = evt.getText();
                TreeNode cloudTreeRoot = ProjectGuidPlugin.this.getCloudAndAppTree();
                ProjectGuidPlugin.this.filterTreeNode(cloudTreeRoot, text);
                TreeView treeView = (TreeView)ProjectGuidPlugin.this.getView().getControl("treeviewap");
                treeView.setMulti(true);
                treeView.deleteAllNodes();
                treeView.addNode(cloudTreeRoot);
            }
        });
        Search searchdist = (Search)this.getControl("searchdist");
        searchdist.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent evt) {
                String text = evt.getText();
                CacheTreeManager cacheTreeManager = new CacheTreeManager(ProjectGuidPlugin.TREE_CACHE, ProjectGuidPlugin.this.getPageCache());
                TreeNode treeNode = cacheTreeManager.getSelectedTreeNode(ProjectGuidPlugin.ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009", (String)"ProjectGuidPlugin_1", (String)ProjectGuidPlugin.BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                ProjectGuidPlugin.this.filterTreeNode(treeNode, text);
                treeNode.setIsOpened(true);
                TreeView treeView = (TreeView)ProjectGuidPlugin.this.getView().getControl("selectedtree");
                treeView.setMulti(true);
                treeView.deleteAllNodes();
                treeView.addNode(treeNode);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("projectname", (Object)"ks");
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"previous", "create"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"projectname"});
        this.loadTreeData();
        TextEdit control = (TextEdit)this.getView().getControl("localpath");
        control.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u5730\u8def\u5f84\uff08\u5982\u9700\u4f7f\u7528DCS\uff0c\u8bf7\u9009\u62e9DCS\u505a\u4e3a\u6839\u76ee\u5f55\uff09", (String)"ProjectGuidPlugin_13", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0])));
        this.getView().addClientCallBack(INIT);
        Listbox listboxap = (Listbox)this.getView().getControl("listboxap");
        ListboxItem item = new ListboxItem();
        item.setContent(ResManager.loadKDString((String)"\u521b\u5efa\u5de5\u7a0b\u5411\u5bfc", (String)"ProjectGuidPlugin_2", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        ArrayList<ListboxItem> list = new ArrayList<ListboxItem>(16);
        list.add(item);
        listboxap.addItems(list);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e.getName().equals(INIT)) {
            this.doSendVSCode(INIT, null);
        }
    }

    private void loadTreeData() {
        TreeNode cloudTreeRoot = this.getCloudAndAppTree();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.setMulti(true);
        treeView.addNode(cloudTreeRoot);
        CacheTreeManager.initCacheTreeManager(TREE_CACHE, this.getPageCache(), cloudTreeRoot);
        TreeNode selectedTreeRoot = this.renderSelectTreeRoot(null);
        TreeView selectedTreeView = (TreeView)this.getView().getControl("selectedtree");
        selectedTreeView.setMulti(true);
        selectedTreeView.addNode(selectedTreeRoot);
    }

    private void reloadTreeData() {
        String id;
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        TreeView selectedTreeView = (TreeView)this.getView().getControl("selectedtree");
        CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
        List<CacheTree> cacheTreeList = cacheTreeManager.getList();
        TreeNode cloudTreeRoot = this.getCloudAndAppTree();
        if (cloudTreeRoot == null) {
            this.getPageCache().put(TREE_CACHE, null);
            treeView.deleteAllNodes();
            return;
        }
        CacheTreeManager.initCacheTreeManager(TEMP_TREE_CACHE, this.getPageCache(), cloudTreeRoot);
        CacheTreeManager tempCacheTreeManager = new CacheTreeManager(TEMP_TREE_CACHE, this.getPageCache());
        List<CacheTree> tempCacheTreeList = tempCacheTreeManager.getList();
        for (CacheTree tempCacheTree : tempCacheTreeList) {
            TreeNode treeNode;
            id = tempCacheTree.getId();
            CacheTree cacheTree = cacheTreeManager.get(id);
            if (cacheTree != null || (treeNode = cloudTreeRoot.getTreeNode(id)) == null) continue;
            treeView.addNode(treeNode);
            cacheTreeList.add(new CacheTree(treeNode.getId(), treeNode.getText(), treeNode.getParentid(), treeNode.getData()));
        }
        cacheTreeManager.save();
        for (int i = cacheTreeList.size() - 1; i >= 0; --i) {
            CacheTree cacheTree = cacheTreeList.get(i);
            id = cacheTree.getId();
            CacheTree tempCurCacheTree = tempCacheTreeManager.get(id);
            if (tempCurCacheTree != null) continue;
            treeView.deleteNode(id);
            selectedTreeView.deleteNode(id);
            cacheTreeList.remove(i);
        }
        cacheTreeManager.save();
        this.getPageCache().remove(TEMP_TREE_CACHE);
    }

    private void doSendVSCode(String action, Map<String, Object> propValue) {
        PushContent pushContent = new PushContent();
        pushContent.setAction(action);
        pushContent.setPushClass(CREATE_PROJECT);
        pushContent.setPageId(this.getView().getPageId());
        if (propValue != null) {
            pushContent.setPropVaule(propValue);
        }
        pushContent.pushMessage(this.getView());
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String session = (String)e.getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String key;
        String session = (String)this.getView().getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return;
        }
        Object source = evt.getSource();
        switch (key = ((Control)source).getKey()) {
            case "localpath": {
                this.doSendVSCode(GET_LOCALPATH, null);
                break;
            }
            case "create": {
                Map<String, Object> projectInfo = this.getProjectInfo();
                if (projectInfo.isEmpty()) break;
                this.disableCreateButton();
                this.doSendVSCode("creat_project", projectInfo);
                break;
            }
            case "next": {
                this.next();
                break;
            }
            case "previous": {
                this.previous();
                break;
            }
            case "btnadd": {
                TreeView tree = (TreeView)this.getView().getControl("treeviewap");
                List selectedNodes = tree.getTreeState().getSelectedNodes();
                if (!selectedNodes.isEmpty()) {
                    this.addSelectedNode(selectedNodes);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u3002", (String)"ProjectGuidPlugin_3", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                break;
            }
            case "btndel": {
                CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
                TreeView selectedTreeView = (TreeView)this.getView().getControl("selectedtree");
                List selectedNodes = selectedTreeView.getTreeState().getSelectedNodes();
                ArrayList<String> treeNodeList = new ArrayList<String>(10);
                if (!selectedNodes.isEmpty()) {
                    for (Map node : selectedNodes) {
                        String id = (String)node.get("id");
                        CacheTree tree = cacheTreeManager.get(id);
                        if (ROOTNODE.equals(id) || tree.isExists()) continue;
                        tree.setSelected(false);
                        treeNodeList.add(id);
                    }
                }
                if (treeNodeList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u3002", (String)"ProjectGuidPlugin_3", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                } else {
                    selectedTreeView.deleteNodes(treeNodeList);
                }
                cacheTreeManager.save();
                break;
            }
        }
    }

    private void addSelectedNode(List<Map<String, Object>> selectedNodes) {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
        for (Map<String, Object> node : selectedNodes) {
            CacheTree cacheTree;
            CacheTree parentNode;
            String id = (String)node.get("id");
            if (ROOTNODE.equals(id)) continue;
            Object parentNodeId = node.get("parentid");
            if (parentNodeId != null && (parentNode = cacheTreeManager.get((String)parentNodeId)) != null) {
                parentNode.setSelected(true);
                treeNodeList.add(parentNode.toTreeNode());
            }
            if ((cacheTree = cacheTreeManager.get(id)) == null) continue;
            cacheTree.setSelected(true);
            TreeNode treeNode = new TreeNode((String)parentNodeId, (String)node.get("id"), (String)node.get("text"));
            treeNodeList.add(treeNode);
        }
        TreeView selectedTreeView = (TreeView)this.getView().getControl("selectedtree");
        selectedTreeView.addNodes(treeNodeList);
        selectedTreeView.checkNodes(treeNodeList);
        cacheTreeManager.save();
    }

    private void pushWebsocketMessage(String content) {
        String session = (String)this.getView().getFormShowParameter().getCustomParam("session");
        PushMessage message = new PushMessage(PushMessageRange.Session, session, (Object)content);
        PushServiceHelper.push((PushMessage)message);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.setVisibleByTabKey(tabKey);
    }

    @Override
    public void doAction(PushContent content) {
        switch (content.getAction()) {
            case "get_localpath": {
                this.getModel().setValue("localpath", content.getPropValue().get("localPath"));
                break;
            }
            case "init": {
                boolean isProject = (Boolean)content.getPropValue().get("isProject");
                if (!isProject) break;
                this.getView().setEnable(Boolean.FALSE, new String[]{"localpath", "projectname"});
                this.getModel().setValue("localpath", content.getPropValue().get("localpath"));
                this.getModel().setValue("projectname", content.getPropValue().get("projectname"));
                logger.info("set Value:{} {}", content.getPropValue().get("localpath"), content.getPropValue().get("projectname"));
                List list = (List)content.getPropValue().get("applist");
                String[] numbers = new String[list.size()];
                int i = 0;
                for (Map appMode : list) {
                    numbers[i++] = (String)appMode.get("number");
                }
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_devportal_bizapp");
                QFilter qFilter = new QFilter("number", "in", (Object)numbers);
                Map appDatas = BusinessDataReader.loadFromCache((DynamicObjectType)dataEntityType, (QFilter[])new QFilter[]{qFilter});
                CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
                String[] ids = new String[appDatas.size()];
                i = 0;
                for (Object o : appDatas.keySet()) {
                    String bizAppId;
                    CacheTree appTree;
                    ids[i++] = (String)o;
                    CacheTree cacheTree = cacheTreeManager.get((String)o);
                    if (cacheTree == null) continue;
                    cacheTree.setExists(true);
                    cacheTree.setSelected(true);
                    DynamicObject bizApp = (DynamicObject)appDatas.get(o);
                    DynamicObject bizcloud = bizApp.getDynamicObject("bizcloud");
                    if (bizcloud == null || (appTree = cacheTreeManager.get(bizAppId = bizcloud.getString("id"))) == null) continue;
                    appTree.setExists(true);
                    appTree.setSelected(true);
                }
                cacheTreeManager.save();
                TreeNode selectedTreeRoot = this.renderSelectTreeRoot(ids);
                TreeView selectedTreeView = (TreeView)this.getView().getControl("selectedtree");
                selectedTreeView.setMulti(true);
                selectedTreeView.deleteAllNodes();
                selectedTreeView.addNode(selectedTreeRoot);
                break;
            }
            case "VSCodeFinished": {
                this.enableCreateButton();
            }
        }
    }

    private Map<String, Object> getProjectInfo() {
        IDataModel model = this.getView().getModel();
        Object projectName = model.getValue("projectname");
        Object localpath = model.getValue("localpath");
        TreeView selectedTree = (TreeView)this.getControl("selectedtree");
        CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
        List<CacheTree> selectedNodes = cacheTreeManager.getSelectedList();
        HashedMap projectInfo = new HashedMap();
        projectInfo.put("projectname", projectName);
        projectInfo.put("localpath", localpath);
        projectInfo.put("appmodule", this.loadSelectApps(selectedNodes));
        boolean result = this.validate((Map<String, Object>)projectInfo);
        if (!result) {
            return Collections.emptyMap();
        }
        return projectInfo;
    }

    private List<Map<String, String>> loadSelectApps(List<CacheTree> selectedNodes) {
        Object[] ids = new Object[selectedNodes.size()];
        int i = 0;
        for (CacheTree selectedNode : selectedNodes) {
            ids[i++] = selectedNode.getId();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_devportal_bizapp");
        Map rows = BusinessDataReader.loadFromCache((Object[])ids, (DynamicObjectType)dataEntityType);
        ArrayList<String> masterIds = new ArrayList<String>(16);
        for (Map.Entry kv : rows.entrySet()) {
            if (!"2".equals(((DynamicObject)kv.getValue()).getString("type"))) continue;
            masterIds.add(((DynamicObject)kv.getValue()).getString("masterid"));
        }
        Map masterRows = BusinessDataReader.loadFromCache((Object[])masterIds.toArray(new Object[0]), (DynamicObjectType)dataEntityType);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(selectedNodes.size());
        for (Map.Entry kv : rows.entrySet()) {
            DynamicObject masterBizApp;
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("number", ((DynamicObject)kv.getValue()).getString("number"));
            map.put("name", ((DynamicObject)kv.getValue()).getString("name"));
            if ("2".equals(((DynamicObject)kv.getValue()).getString("type")) && (masterBizApp = (DynamicObject)masterRows.get(((DynamicObject)kv.getValue()).getString("masterid"))) != null) {
                map.put("masternumber", masterBizApp.getString("number"));
            }
            DynamicObject bizcloud = ((DynamicObject)kv.getValue()).getDynamicObject("bizcloud");
            map.put("cloudnumber", bizcloud.getString("number"));
            result.add(map);
        }
        return result;
    }

    private String getTabStatus() {
        Tab tab = (Tab)this.getControl("tabap");
        return tab.getCurrentTab();
    }

    private void changeTab(String key) {
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(key);
    }

    private boolean validate(Map<String, Object> projectInfo) {
        if (StringUtils.isBlank((Object)projectInfo.get("localpath"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u672c\u5730\u8def\u5f84\u3002", (String)"ProjectGuidPlugin_7", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((Object)projectInfo.get("projectname"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5de5\u7a0b\u540d\u79f0\u3002", (String)"ProjectGuidPlugin_8", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return false;
        }
        String projectName = (String)projectInfo.get("projectname");
        Pattern pattern = Pattern.compile(FILENAME_PATTERN);
        Matcher matcher = pattern.matcher(projectName);
        if (!matcher.matches()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u7a0b\u540d\u79f0\u4e0d\u5408\u6cd5\uff0c\u53ef\u4ee5\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u548c\u70b9\uff0c\u4f46\u4e0d\u80fd\u4ee5\u70b9\u5f00\u5934\uff0c\u4e5f\u4e0d\u80fd\u4ee5\u7a7a\u683c\u7ed3\u5c3e\u3002", (String)"ProjectGuidPlugin_9", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return false;
        }
        List appmodule = (List)projectInfo.get("appmodule");
        if (appmodule == null || appmodule.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5e94\u7528\u3002", (String)"ProjectGuidPlugin_10", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void next() {
        String tabKey = this.getTabStatus();
        if ("projectconfig".equals(tabKey)) {
            this.changeTab("appmodule");
        }
    }

    private void previous() {
        String tabKey = this.getTabStatus();
        if ("appmodule".equals(tabKey)) {
            this.changeTab("projectconfig");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("shownum")) {
            TreeNode cloudTreeRoot = this.getCloudAndAppTree();
            TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
            treeView.setMulti(true);
            treeView.deleteAllNodes();
            treeView.addNode(cloudTreeRoot);
            CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
            TreeNode selectTreeRoot = cacheTreeManager.getSelectedTreeNode(ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009", (String)"ProjectGuidPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            selectTreeRoot.setIsOpened(true);
            TreeViewUtil.convertTreeNodeTextWithNumber(selectTreeRoot, (Boolean)this.getModel().getValue("shownum"));
            TreeView selectedtree = (TreeView)this.getView().getControl("selectedtree");
            selectedtree.setMulti(true);
            selectedtree.deleteAllNodes();
            selectedtree.addNode(selectTreeRoot);
        }
    }

    private void setVisibleByTabKey(String tabKey) {
        switch (tabKey) {
            case "projectconfig": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"previous", "create"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"next"});
                break;
            }
            case "appmodule": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"next"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"previous", "create"});
                this.reloadTreeData();
            }
        }
    }

    private TreeNode getCloudAndAppTree() {
        Map apps;
        Set fids;
        String isv = ISVServiceHelper.getISVInfo().getId();
        ArrayList<String> isvs = new ArrayList<String>(10);
        isvs.add("kingdee");
        isvs.add("kdxk");
        if (isv != null && !isvs.contains(isv)) {
            isvs.add(isv);
        }
        if ((fids = (apps = BusinessDataReader.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("isv", "in", isvs)})).keySet()).isEmpty()) {
            logger.info(String.format("isv:%s data is empty", isv));
            TreeNode root = new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ProjectGuidPlugin_4", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]), (Object)"root");
            root.setIsOpened(true);
            return root;
        }
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, (String[])fids.toArray(new String[0]), null, (String)"app", (boolean)false, (boolean)true, (boolean)true);
        if (treeRoot != null) {
            if (((Boolean)this.getModel().getValue("shownum")).booleanValue() && ((Boolean)this.getModel().getValue("shownum")).booleanValue()) {
                TreeViewUtil.convertTreeNodeTextWithNumber(treeRoot);
            }
            treeRoot.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ProjectGuidPlugin_4", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
        return treeRoot;
    }

    private void filterTreeNode(TreeNode treeRoot, String searchText) {
        CacheTreeManager cacheTreeManager = new CacheTreeManager(TREE_CACHE, this.getPageCache());
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String s = searchText.toLowerCase();
            Iterator iterator = treeRoot.getChildren().iterator();
            while (iterator.hasNext()) {
                List appChild;
                TreeNode cloudNode = (TreeNode)iterator.next();
                cloudNode.setIsOpened(true);
                if (cloudNode.getText() != null && cloudNode.getText().toLowerCase().contains(s)) {
                    if (cacheTreeManager.get(cloudNode.getId()) == null) {
                        iterator.remove();
                        continue;
                    }
                    appChild = cloudNode.getChildren();
                    if (appChild == null) continue;
                    appChild.removeIf(o -> cacheTreeManager.get(o.getId()) == null);
                    continue;
                }
                appChild = cloudNode.getChildren();
                if (appChild == null) continue;
                appChild.removeIf(o -> o.getText() == null || !o.getText().toLowerCase().contains(s) || cacheTreeManager.get(o.getId()) == null);
                if (appChild.size() == 0) {
                    iterator.remove();
                    continue;
                }
                appChild.forEach(o -> o.setIsOpened(true));
            }
        }
    }

    private void disableAllNode(TreeNode treeNode) {
        if (treeNode != null && CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode child : treeNode.getChildren()) {
                if (child.getData().equals("app")) {
                    child.setDisabled(true);
                    child.setCheckable(false);
                }
                this.disableAllNode(child);
            }
        }
    }

    private TreeNode renderSelectTreeRoot(String[] selectAppIds) {
        TreeNode root = null;
        if (selectAppIds != null && selectAppIds.length > 0) {
            root = (TreeNode)BizAppServiceHelp.getSubsysTree(null, (String[])selectAppIds, null, (String)"app", (boolean)false, (boolean)true, (boolean)true);
            if (root != null && CollectionUtils.isNotEmpty((Collection)root.getChildren())) {
                this.disableAllNode(root);
            }
            if (((Boolean)this.getModel().getValue("shownum")).booleanValue()) {
                TreeViewUtil.convertTreeNodeTextWithNumber(root);
            }
        }
        if (root == null) {
            root = new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009", (String)"ProjectGuidPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
        root.setIsOpened(true);
        root.setId(ROOTNODE);
        root.setText(ResManager.loadKDString((String)"\u5df2\u9009", (String)"ProjectGuidPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        return root;
    }

    private void enableCreateButton() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"create"});
    }

    private void disableCreateButton() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"create"});
    }
}

