/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SelectOpPlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRYKEY = "operation_list";
    protected static final String SELOPERATEPAGE_RETURNDATA = "returnDataSelectedOperation";

    public void initialize() {
        Button saveButton = (Button)this.getControl("btnok");
        saveButton.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                SelectOpPlugin.this.returnData(true);
            }
        });
        Button cancelButton = (Button)this.getControl("btncancel");
        cancelButton.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                SelectOpPlugin.this.returnData(false);
            }
        });
        EntryGrid operationList = (EntryGrid)this.getControl(KEY_ENTRYKEY);
        operationList.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
            }

            public void entryRowDoubleClick(RowClickEvent evt) {
                SelectOpPlugin.this.returnData(true);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.refreshList(customParams.get("entityId") + "");
    }

    private void refreshList(String entityId) {
        List allOperates = EntityMetadataCache.getDataEntityOperate((String)entityId);
        for (Map operate : allOperates) {
            String opTypeId = operate.get("type") == null ? "" : (String)operate.get("type");
            if (!StringUtils.isNotBlank((CharSequence)opTypeId) || !OperationTypeCache.isEntityOperation((String)opTypeId)) continue;
            int newRowIndex = this.getModel().createNewEntryRow(KEY_ENTRYKEY);
            this.getModel().setEntryCurrentRowIndex(KEY_ENTRYKEY, newRowIndex);
            Map operationNameMap = (Map)operate.get("name");
            LocaleString operationLocaleName = (LocaleString)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)operationNameMap), LocaleString.class);
            this.getModel().setValue("operation_code", operate.get("key"), newRowIndex);
            this.getModel().setValue("operation_name", (Object)operationLocaleName.getLocaleValue(), newRowIndex);
            this.getModel().setValue("operation_type", (Object)opTypeId, newRowIndex);
        }
    }

    private void returnData(boolean save) {
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("returnDataResult", save ? "returnDataSave" : "returnDataCancel");
        if (save) {
            IDataModel iDataModel = this.getModel();
            int currentOperationListIndex = iDataModel.getEntryCurrentRowIndex(KEY_ENTRYKEY);
            String operationKey = (String)this.getModel().getValue("operation_code", currentOperationListIndex);
            returnData.put(SELOPERATEPAGE_RETURNDATA, operationKey);
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

