/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;

class TreeViewUtil {
    TreeViewUtil() {
    }

    static void convertTreeNodeTextWithNumber(TreeNode treeNode) {
        TreeViewUtil.convertTreeNodeTextWithNumber(treeNode, Boolean.TRUE);
    }

    static void convertTreeNodeTextWithNumber(TreeNode treeNode, Boolean showNum) {
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(16);
        TreeViewUtil.fillTreeToMap(treeNodeMap, treeNode);
        Object[] idCloud = new Object[treeNodeMap.size()];
        Object[] idApp = new Object[treeNodeMap.size()];
        int i = 0;
        int k = 0;
        for (Map.Entry kv : treeNodeMap.entrySet()) {
            Object data = ((TreeNode)kv.getValue()).getData();
            if ("cloud".equals(data)) {
                idCloud[i++] = kv.getKey();
                continue;
            }
            if (!"app".equals(data)) continue;
            idApp[k++] = kv.getKey();
        }
        TreeViewUtil.fillNameWithNumber(treeNodeMap, Arrays.copyOf(idCloud, i), "bos_devportal_bizcloud", showNum);
        TreeViewUtil.fillNameWithNumber(treeNodeMap, Arrays.copyOf(idApp, k), "bos_devportal_bizapp", showNum);
    }

    private static void fillTreeToMap(Map<String, TreeNode> treeNodeMap, TreeNode treeNode) {
        treeNodeMap.put(treeNode.getId(), treeNode);
        List children = treeNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                TreeViewUtil.fillTreeToMap(treeNodeMap, child);
            }
        }
    }

    private static void fillNameWithNumber(Map<String, TreeNode> treeNodeMap, Object[] ids, String formId, Boolean showNum) {
        MainEntityType cloudType = EntityMetadataCache.getDataEntityType((String)formId);
        Map mapData = BusinessDataReader.loadFromCache((Object[])ids, (DynamicObjectType)cloudType);
        for (Map.Entry<String, TreeNode> kv : treeNodeMap.entrySet()) {
            DynamicObject data = (DynamicObject)mapData.get(kv.getKey());
            if (data == null) continue;
            if (showNum.booleanValue()) {
                kv.getValue().setText(data.getString("name") + "(" + data.getString("number") + ")");
                continue;
            }
            kv.getValue().setText(data.getString("name"));
        }
    }
}

