/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.session.SystemPropertyUtils;

public class TsPluginSearchPlugin
extends AbstractFormPlugin {
    private static final String BOS_KINGSCRIPT_CONSOLE = "bos-kingscript-console";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"unbind", "optoolbar"});
    }

    public void afterCreateNewData(EventObject e) {
        String searchContent = (String)this.getView().getFormShowParameter().getCustomParam("searchcontent");
        int count = this.search(searchContent);
        Label searchTitle = (Label)this.getView().getControl("labelap");
        searchTitle.setText(String.format(ResManager.loadKDString((String)"\u4ee5\u4e3a\u60a8\u67e5\u8be2\u5230 %d\u5904\uff0c\u5173\u8054\u201c%s\u201d\u63d2\u4ef6 \uff1a", (String)"TsPluginSearchPlugin_0", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]), count, searchContent));
    }

    private int search(String searchContent) {
        List<Map<String, String>> searchResult = this.getSearchDynPlugin(searchContent);
        if (!searchResult.isEmpty()) {
            return this.fillEntry(searchResult);
        }
        return 0;
    }

    private int fillEntry(List<Map<String, String>> searchResult) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        int[] rowKeys = model.batchCreateNewEntryRow("entryentity", searchResult.size());
        int row = 0;
        for (Map<String, String> record : searchResult) {
            String cloudNumber = record.get("cloudnumber");
            String cloudName = record.get("cloudname");
            model.setValue("cloud", (Object)String.format("%s(%s)", cloudName, cloudNumber), rowKeys[row]);
            String appName = record.get("appName");
            String appNumber = record.get("appNumber");
            model.setValue("app", (Object)String.format("%s(%s)", appName, appNumber), rowKeys[row]);
            String formName = record.get("formName");
            String formNumber = record.get("formNumber");
            model.setValue("form", (Object)String.format("%s(%s)", formName, formNumber), rowKeys[row]);
            model.setValue("plugin", (Object)record.get("classname"), rowKeys[row]);
            model.setValue("plugindesc", (Object)record.get("desc"), rowKeys[row]);
            model.setValue("plugintype", (Object)record.get("interfaceType"), rowKeys[row]);
            model.setValue("enable", (Object)record.get("bindEnable"), rowKeys[row]);
            model.setValue("pluginbindid", (Object)record.get("bindId"), rowKeys[row]);
            model.setValue("pluginid", (Object)record.get("dynpluginId"), rowKeys[row]);
            model.setValue("formid", (Object)record.get("bindFormId"), rowKeys[row]);
            ++row;
        }
        this.getView().updateView("entryentity");
        return searchResult.size();
    }

    private List<Map<String, String>> getSearchDynPlugin(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return Collections.EMPTY_LIST;
        }
        StringBuilder selectSql = new StringBuilder();
        String cp = this.getCP();
        String localid = Lang.get().toString();
        selectSql.append("select dpb.FID, dp.FID, ps.fscriptname, ps.fscriptnumber, ps.fclassname, bp.fnumber, bpl.fname, fd.fnumber, fdl.fname, dpb.fenable, dpb.FOBJECTTYPEID, dp.FINTERFACETYPE,dp.FPLUGINDESC_TAG, bc.FNUMBER, bcl.FNAME from T_META_DYNPLUGINBIND as dpb,  ").append("T_META_DYNPLUGIN as dp, T_META_PLUGINSCRIPT as ps, T_META_BIZAPP as bp, T_META_BIZAPP_L as bpl, T_META_FORMDESIGN as fd,T_META_FORMDESIGN_L as fdl,T_META_BIZCLOUD as bc, T_META_BIZCLOUD_L as bcl ").append(" where dp.FID = dpb.fdynpluginid and ps.FCLASSNAME = dp.FCLASSNAME and bp.FID = ps.FBIZAPPID and fd.FID = dpb.FOBJECTTYPEID and bp.FID=bpl.FID and fd.FID=fdl.FID and ").append(" bp.FBIZCLOUDID = bc.FID and bc.FID = bcl.FID and ").append(String.format("fdl.flocaleid ='%s' and bpl.flocaleid ='%s' and bCl.flocaleid ='%s' ", localid, localid, localid)).append(String.format(" and (ps.fscriptname %s ? or ps.fscriptnumber %s ? or ps.fclassname %s ? or bp.fnumber %s ? or bpl.fname %s ? or fd.fnumber %s ? or fdl.fname %s ? )", cp, cp, cp, cp, cp, cp, cp));
        Object[] params = new SqlParameter[]{new SqlParameter(":ps.fscriptname", 12, (Object)("%" + content + "%")), new SqlParameter(":ps.fscriptnumber", 12, (Object)("%" + content + "%")), new SqlParameter(":ps.fclassname", 12, (Object)("%" + content + "%")), new SqlParameter(":bp.fnumber", 12, (Object)("%" + content + "%")), new SqlParameter(":bpl.fname", 12, (Object)("%" + content + "%")), new SqlParameter(":fd.fnumber", 12, (Object)("%" + content + "%")), new SqlParameter(":fdl.fname", 12, (Object)("%" + content + "%"))};
        ResultSetHandler result = rs -> {
            ArrayList resultList = new ArrayList(16);
            while (rs.next()) {
                HashMap<String, String> res = new HashMap<String, String>(16);
                String bindId = rs.getString(1);
                String dynpluginId = rs.getString(2);
                String scriptName = rs.getString(3);
                String scriptNumber = rs.getString(4);
                String classname = rs.getString(5);
                if (StringUtils.isBlank((CharSequence)classname) || !classname.endsWith(".ts")) continue;
                String appNumber = rs.getString(6);
                String appName = rs.getString(7);
                String formNumber = rs.getString(8);
                String formName = rs.getString(9);
                String bindEnable = rs.getString(10);
                String bindFormId = rs.getString(11);
                String interFaceType = rs.getString(12);
                String desc = rs.getString(13);
                String cloudNumber = rs.getString(14);
                String cloudName = rs.getString(15);
                res.put("bindId", bindId);
                res.put("dynpluginId", dynpluginId);
                res.put("scriptName", scriptName);
                res.put("scriptNumber", scriptNumber);
                res.put("classname", classname);
                res.put("appNumber", appNumber);
                res.put("appName", appName);
                res.put("formNumber", formNumber);
                res.put("formName", formName);
                res.put("bindEnable", bindEnable);
                res.put("bindFormId", bindFormId);
                res.put("interfaceType", interFaceType);
                Object descObj = null;
                if (StringUtils.isBlank((CharSequence)desc)) {
                    desc = "";
                } else {
                    Map descMap = (Map)SerializationUtils.fromJsonString((String)desc, Map.class);
                    descObj = descMap.get("text");
                }
                res.put("desc", descObj != null && descObj instanceof String ? (String)descObj : "");
                res.put("cloudnumber", cloudNumber);
                res.put("cloudname", cloudName);
                resultList.add(res);
            }
            return resultList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)selectSql.toString(), (Object[])params, (ResultSetHandler)result);
    }

    private String getCP() {
        String cp = "like";
        String tenantId = RequestContext.get().getTenantId();
        if (DB.getDBType((DBRoute)DBRoute.meta) == DBType.PostgreSQL && "true".equalsIgnoreCase(SystemPropertyUtils.getProptyByTenant((String)"orm.opt.pg.ignorecase", (String)tenantId))) {
            cp = "ilike";
        }
        return cp;
    }
}

