/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kingscript.openapi.development.ScriptService;
import kd.bos.kingscript.openapi.development.helper.ScriptDBHelper;
import kd.bos.kingscript.vscode.IvsCodeListener;
import kd.bos.kingscript.vscode.PushContent;
import kd.bos.kingscript.vscode.VsCodeUtil;
import kd.bos.kingscript.vscode.download.CompareResult;
import kd.bos.kingscript.vscode.download.FileInfo;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.service.ServiceFactory;
import kd.sdk.kingscript.exception.ScriptException;

public class TsUtil
implements IvsCodeListener {
    private static final String BOS_KINGSCRIPT_CONSOLE = "bos-kingscript-console";

    @Override
    public CustomApiResult<String> doActionWithPage(PushContent pushContent) {
        switch (pushContent.getAction()) {
            case "uploadOneTs": {
                return TsUtil.uploadOneTs(pushContent);
            }
            case "downloadOneTs": {
                return TsUtil.downloadOneTs(pushContent);
            }
            case "getmetadata": {
                return this.getMetdata(pushContent);
            }
            case "isPluginDebuggable": {
                return this.isPluginDebuggable(pushContent);
            }
        }
        return CustomApiResult.fail((String)"999", (String)("invalid action:" + pushContent.getAction()));
    }

    private CustomApiResult<String> isPluginDebuggable(PushContent content) {
        Map<String, Object> propValue = content.getPropValue();
        if (propValue == null || propValue.isEmpty()) {
            return CustomApiResult.fail((String)"003", (String)"propValue can't be null");
        }
        Map fileInfoMap = (Map)propValue.get("fileinfo");
        if (fileInfoMap == null || fileInfoMap.isEmpty()) {
            return CustomApiResult.fail((String)"004", (String)"fileInfoMap can't be null");
        }
        String fileRawContent = (String)fileInfoMap.get("rawContent");
        if (fileRawContent == null) {
            return CustomApiResult.fail((String)"005", (String)"fileRawContent can't be null");
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("AbstractTask", ResManager.loadKDString((String)"\u8c03\u5ea6", (String)"TsUtil_04", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        map.put("WorkflowPlugin", ResManager.loadKDString((String)"\u6d41\u7a0b", (String)"TsUtil_05", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        for (Map.Entry plugin : map.entrySet()) {
            String pluginClass = (String)plugin.getKey();
            String pluginName = (String)plugin.getValue();
            String regex = "import\\s*\\{.*?" + pluginClass + ".*?as\\s+(\\w+)?\\s*\\}[\\S\\s]*?class\\s+(\\w+)\\s+extends\\s+(\\1)\\s*\\{|class\\s+(\\w+)\\s+extends\\s+" + pluginClass + "\\s*\\{";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(fileRawContent);
            if (!matcher.find()) continue;
            return CustomApiResult.fail((String)"006", (String)ResManager.loadKDString((String)"%s\u63d2\u4ef6\u6682\u4e0d\u652f\u6301\u8c03\u8bd5\u3002", (String)"TsUtil_03", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[]{pluginName}));
        }
        return CustomApiResult.success((Object)"OK");
    }

    private CustomApiResult<String> getMetdata(PushContent pushContent) {
        String className = (String)pushContent.getPropValue().get("classname");
        if (StringUtils.isBlank((CharSequence)className)) {
            return CustomApiResult.fail((String)"1001", (String)"classname can't be null");
        }
        String formId = (String)DB.query((DBRoute)DBRoute.meta, (String)"select fnumber  from t_meta_formdesign tmd\nwhere tmd.fdata like ? ", (Object[])new Object[]{"%" + className + "%"}, rs -> {
            if (rs.next()) {
                return rs.getString("fnumber");
            }
            return "";
        });
        if (StringUtils.isBlank((CharSequence)formId)) {
            formId = (String)pushContent.getPropValue().get("formid");
        }
        HashMap<String, Object> mapResult = new HashMap<String, Object>(16);
        mapResult.put("formid", formId);
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
            ArrayList list = new ArrayList(16);
            for (ControlAp item : formMetadata.getItems()) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("key", item.getKey());
                map.put("name", item.getName().toString());
                map.put("type", item instanceof EntryAp ? "grid" : (item instanceof FieldAp ? "entity" : "form"));
                list.add(map);
            }
            mapResult.put("items", list);
        }
        return CustomApiResult.success((Object)SerializationUtils.toJsonString(mapResult));
    }

    public static CustomApiResult<String> uploadOneTs(PushContent content) {
        Map<String, Object> propValue = content.getPropValue();
        Map fileInfoMap = (Map)propValue.get("fileinfo");
        String path = (String)fileInfoMap.get("path");
        String hash = (String)fileInfoMap.get("content");
        String fileContent = (String)fileInfoMap.get("rawContent");
        if (StringUtils.isNotBlank((CharSequence)path)) {
            path = path.replace("\\", "/");
            String[] dirs = path.split("/");
            int index = -1;
            for (int i = 0; i < dirs.length; ++i) {
                if (!"src".equals(dirs[i]) || i + 1 >= dirs.length) continue;
                index = path.indexOf(dirs[i + 1]);
            }
            if (index == -1) {
                return CustomApiResult.fail((String)"1001", (String)("error path:" + path));
            }
            String subfixFilePath = path.substring(index);
            String[] filePath = subfixFilePath.split("/");
            String appNumber = "";
            if (filePath.length > 2) {
                appNumber = filePath[2];
            }
            ArrayList<String> scriptList = new ArrayList<String>();
            scriptList.add(subfixFilePath);
            ScriptService scriptService = (ScriptService)ServiceFactory.getService((String)"ScriptService");
            CustomApiResult<Map<String, String>> apiResult = scriptService.compareScripts(1, "", scriptList);
            if (apiResult.isStatus()) {
                String appId = scriptService.convertAppId(appNumber);
                Map data = (Map)apiResult.getData();
                HashMap<String, Map<String, String>> scriptsMap = new HashMap<String, Map<String, String>>();
                HashMap<String, String> scripts = new HashMap<String, String>();
                scripts.put(subfixFilePath, fileContent);
                scriptsMap.put(appId, scripts);
                Object session = propValue.get("session");
                try {
                    if (data.isEmpty()) {
                        if (session != null) {
                            VsCodeUtil.recordUserAction((String)session, scripts, null, null);
                        }
                        scriptService.doPushScripts(scriptsMap, null, null);
                    } else {
                        String hashInDb = (String)data.get(subfixFilePath);
                        if (!hash.equals(hashInDb)) {
                            if (session != null) {
                                VsCodeUtil.recordUserAction((String)session, null, scripts, null);
                            }
                            scriptService.doPushScripts(null, scriptsMap, null);
                        }
                    }
                }
                catch (ScriptException e) {
                    return CustomApiResult.fail((String)"002", (String)String.format(ResManager.loadKDString((String)"\u7f16\u8bd1\u5931\u8d25\uff1a%s", (String)"TsUtil_02", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]), e.getMessage()));
                }
            }
        }
        return CustomApiResult.success((Object)"OK");
    }

    public static CustomApiResult<String> downloadOneTs(PushContent content) {
        Map<String, Object> propValue = content.getPropValue();
        Map fileInfoMap = (Map)propValue.get("fileinfo");
        FileInfo fileInfo = TsUtil.convertDownloadFileInfo(fileInfoMap);
        TsUtil.compareFile(fileInfo);
        if (fileInfo.getCompareResult() != null) {
            String fileRawContnet = TsUtil.getFileRawContnet(fileInfo);
            return CustomApiResult.success((Object)fileRawContnet);
        }
        return CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u672a\u627e\u5230\u5f53\u524d\u7684\u6587\u4ef6\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"TsUtil_01", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
    }

    private static FileInfo convertDownloadFileInfo(Map<String, String> fileData) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFilePath(fileData.get("path"));
        fileInfo.setContent(fileData.get("content"));
        return fileInfo;
    }

    private static void compareFile(FileInfo fileInfo) {
        ScriptService scriptService = (ScriptService)ServiceFactory.getService((String)"ScriptService");
        String filePath = fileInfo.getFilePath();
        ArrayList<String> scriptPath = new ArrayList<String>();
        scriptPath.add(filePath);
        CustomApiResult<Map<String, String>> customApiResult = scriptService.compareScripts(1, "", scriptPath);
        if (customApiResult.isStatus()) {
            Map data = (Map)customApiResult.getData();
            String cloudFileContent = (String)data.get(filePath);
            String localFileContent = fileInfo.getContent();
            if (cloudFileContent != null && localFileContent != null) {
                if (localFileContent.equals(cloudFileContent)) {
                    fileInfo.setCompareResult(CompareResult.UNMODIFIED);
                } else {
                    fileInfo.setCompareResult(CompareResult.MODIFIED);
                }
            }
        }
    }

    private static String getFileRawContnet(FileInfo fileInfo) {
        String filePath = fileInfo.getFilePath();
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.add(filePath);
        Map<String, String> map = ScriptDBHelper.loadScriptByScriptPaths(filePaths);
        return map.get(filePath);
    }
}

