/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.kingscript.openapi.development.ScriptService;
import kd.bos.kingscript.vscode.AppInfo;
import kd.bos.kingscript.vscode.DevPortalPermissionUtil;
import kd.bos.kingscript.vscode.IvsCodeListener;
import kd.bos.kingscript.vscode.PushContent;
import kd.bos.kingscript.vscode.TreeViewUtil;
import kd.bos.kingscript.vscode.TsFile;
import kd.bos.kingscript.vscode.VsCodeUtil;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;
import kd.sdk.kingscript.exception.ScriptException;

public class UploadKingScriptPlugin
extends AbstractFormPlugin
implements TabSelectListener,
IvsCodeListener {
    private static final String BOS_KINGSCRIPT_CONSOLE = "bos-kingscript-console";
    private static final String VSCODE_FINISHED = "VSCodeFinished";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btncancel", "btnok", "refresh"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        this.push("get_filelist");
        Listbox listboxap = (Listbox)this.getView().getControl("listboxap");
        ListboxItem item = new ListboxItem();
        item.setContent(ResManager.loadKDString((String)"\u4e0a\u4f20\u811a\u672c", (String)"UploadKingScriptPlugin_0", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        ArrayList<ListboxItem> list = new ArrayList<ListboxItem>(16);
        list.add(item);
        listboxap.addItems(list);
    }

    @Override
    public void doAction(PushContent pushContent) {
        if ("get_filelist".equals(pushContent.getAction())) {
            Object appObjects = pushContent.getPropValue().get("appinfo");
            Map<String, Map<String, AppInfo>> cloudAppMap = this.generateCloudAppMap(appObjects);
            Object fileObject = pushContent.getPropValue().get("fileinfo");
            Map<String, Map<String, Map<String, TsFile>>> filtedFilesMap = this.filterFileByPath(cloudAppMap, fileObject);
            this.compareAndUploadScript(filtedFilesMap);
            this.renderTree(filtedFilesMap);
            this.enableUploadButton();
        } else if (VSCODE_FINISHED.equals(pushContent.getAction())) {
            this.enableUploadButton();
        }
    }

    private void push(String action) {
        PushContent pushContent = new PushContent();
        pushContent.setAction(action);
        pushContent.setPushClass("UploadKingScript");
        pushContent.setPageId(this.getView().getPageId());
        pushContent.pushMessage(this.getView());
    }

    public void click(EventObject evt) {
        String key;
        String session = (String)this.getView().getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return;
        }
        Object source = evt.getSource();
        switch (key = ((Button)source).getKey()) {
            case "btnok": {
                this.disableUploadButton();
                this.uploadScript();
                this.push("get_filelist");
                break;
            }
            case "refresh": {
                this.push("get_filelist");
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("shownum".equals(propName)) {
            Boolean showNum = (Boolean)this.getModel().getValue("shownum");
            TreeNode treeNode = this.renderCacheTree();
            if (treeNode != null) {
                TreeViewUtil.convertTreeNodeTextWithNumber(treeNode, showNum);
                this.updateTreeView(treeNode);
            }
        }
    }

    private void uploadScript() {
        int successNumber = 0;
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List selectedNodes = treeView.getTreeState().getSelectedNodes();
        if (CollectionUtils.isEmpty((Collection)selectedNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DownloadTsPlugin_08", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
            return;
        }
        ArrayList<String> selectNodeId = new ArrayList<String>(selectedNodes.size());
        for (Map node : selectedNodes) {
            selectNodeId.add((String)node.get("id"));
        }
        String treeNodeCache = this.getPageCache().get("treenode");
        TreeNode treeNodes = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCache, TreeNode.class);
        HashMap allAppFiles = new HashMap();
        for (String nodeId : selectNodeId) {
            TreeNode node = treeNodes.getTreeNode(nodeId);
            if (node == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DownloadTsPlugin_08", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
                return;
            }
            if ("rootNode".equals(nodeId) || "rootNode".equals(node.getParentid()) || "folder".equals(node.getType())) continue;
            if ("app".equals(node.getData())) {
                HashMap<String, Cloneable> singleAppFiles = (HashMap<String, Cloneable>)allAppFiles.get(nodeId);
                if (singleAppFiles != null) continue;
                singleAppFiles = new HashMap<String, Cloneable>();
                singleAppFiles.put("addScripts", new HashMap());
                singleAppFiles.put("updateScripts", new HashMap());
                singleAppFiles.put("deleteScripts", new ArrayList());
                allAppFiles.put(nodeId, singleAppFiles);
                continue;
            }
            TreeNode currentParentNode = treeNodes.getTreeNode(node.getParentid());
            String appId = "";
            int cycleTime = 0;
            while (!"app".equals(currentParentNode.getData()) && (currentParentNode = treeNodes.getTreeNode(currentParentNode.getParentid())) != null && ++cycleTime <= 20) {
            }
            if (currentParentNode == null) continue;
            appId = currentParentNode.getId();
            HashMap<String, Cloneable> singleAppFiles = (HashMap<String, Cloneable>)allAppFiles.get(appId);
            if (singleAppFiles == null) {
                singleAppFiles = new HashMap<String, Cloneable>();
                singleAppFiles.put("addScripts", new HashMap());
                singleAppFiles.put("updateScripts", new HashMap());
                singleAppFiles.put("deleteScripts", new ArrayList());
                allAppFiles.put(appId, singleAppFiles);
            }
            Map addScriptMap = (Map)singleAppFiles.get("addScripts");
            Map updateScriptList = (Map)singleAppFiles.get("updateScripts");
            List deleteScriptList = (List)singleAppFiles.get("deleteScripts");
            String type = node.getType();
            if (type == null) continue;
            switch (type) {
                case "add": {
                    addScriptMap.put(nodeId, (String)node.getData());
                    break;
                }
                case "delete": {
                    deleteScriptList.add(nodeId);
                    break;
                }
                case "update": {
                    updateScriptList.put(nodeId, (String)node.getData());
                    break;
                }
            }
        }
        ScriptService scriptService = (ScriptService)ServiceFactory.getService((String)"ScriptService");
        for (Map.Entry entry : allAppFiles.entrySet()) {
            String appNumer = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            Map addScripts = (Map)value.get("addScripts");
            Map updateScripts = (Map)value.get("updateScripts");
            List deleteScripts = (List)((Map)entry.getValue()).get("deleteScripts");
            HashMap<String, Map<String, String>> addScriptsMap = new HashMap<String, Map<String, String>>();
            addScriptsMap.put(appNumer, addScripts);
            HashMap<String, Map<String, String>> updateScriptsMap = new HashMap<String, Map<String, String>>();
            updateScriptsMap.put(appNumer, updateScripts);
            HashMap<String, List<String>> deleteScriptsMap = new HashMap<String, List<String>>();
            deleteScriptsMap.put(appNumer, deleteScripts);
            VsCodeUtil.recordUserAction((String)this.getView().getFormShowParameter().getCustomParam("session"), addScripts, updateScripts, deleteScripts);
            try {
                scriptService.doPushScripts(addScriptsMap, updateScriptsMap, deleteScriptsMap);
            }
            catch (ScriptException e) {
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            successNumber += addScripts.size() + updateScripts.size() + deleteScripts.size();
        }
        if (successNumber > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\uff08%s\u4e2a\u6587\u4ef6\uff09\u3002", (String)"UploadKingScriptPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[]{successNumber}));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DownloadTsPlugin_08", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
    }

    private Map<String, Map<String, AppInfo>> generateCloudAppMap(Object appObjects) {
        if (!(appObjects instanceof List)) {
            return Collections.emptyMap();
        }
        List applist = (List)appObjects;
        HashSet<String> allCloudNumber = new HashSet<String>(applist.size());
        HashSet<String> allAppNumber = new HashSet<String>(applist.size());
        HashMap<String, Map<String, AppInfo>> cloudappMap = new HashMap<String, Map<String, AppInfo>>();
        for (Map app : applist) {
            String cloudNumber = (String)app.get("cloudnumber");
            if (StringUtils.isBlank((CharSequence)cloudNumber)) continue;
            allCloudNumber.add(cloudNumber);
            Map cloudApps = cloudappMap.computeIfAbsent(cloudNumber, k -> new HashMap());
            String number = (String)app.get("number");
            if (StringUtils.isBlank((CharSequence)number)) continue;
            allAppNumber.add(number);
            AppInfo appInfo = (AppInfo)cloudApps.get(number);
            if (appInfo != null) continue;
            appInfo = new AppInfo();
            appInfo.setCloudnumber(cloudNumber);
            appInfo.setNumber(number);
            appInfo.setName((String)app.get("name"));
            cloudApps.put(number, appInfo);
        }
        Map<String, String> cloudNumberId = this.loadIdByNumber("bos_devportal_bizcloud", allCloudNumber);
        this.getPageCache().put("cloudnumberid", SerializationUtils.toJsonString(cloudNumberId));
        Map<String, String> appNumberId = this.loadIdByNumber("bos_devportal_bizapp", allAppNumber);
        this.getPageCache().put("appnumberid", SerializationUtils.toJsonString(appNumberId));
        return cloudappMap;
    }

    private Map<String, String> loadIdByNumber(String formId, Set<String> numbers) {
        Map result = BusinessDataReader.loadFromCache((String)formId, (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        HashMap<String, String> numberIdMap = new HashMap<String, String>(result.size());
        for (DynamicObject dynamicObject : result.values()) {
            numberIdMap.put(dynamicObject.getString("number"), dynamicObject.getString("id"));
        }
        return numberIdMap;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String session = (String)e.getFormShowParameter().getCustomParam("session");
        if (!DevPortalPermissionUtil.hasViewPermission(session)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectGuidPlugin_5", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        }
    }

    private Map<String, Map<String, Map<String, TsFile>>> filterFileByPath(Map<String, Map<String, AppInfo>> cloudAppMap, Object fileObject) {
        if (!(fileObject instanceof List)) {
            return Collections.emptyMap();
        }
        List filesMap = (List)fileObject;
        HashMap<String, Map<String, Map<String, TsFile>>> cloudAppFileMap = new HashMap<String, Map<String, Map<String, TsFile>>>();
        for (Map file : filesMap) {
            Map appFileMap;
            Map fileMap;
            TsFile fileInfo;
            String appNumber;
            AppInfo app;
            String cloudNumber;
            Map<String, AppInfo> cloud;
            String subfixFilePath;
            String[] filePath;
            String fileName = (String)file.get("fileName");
            String newFileName = fileName.replace("\\", "/");
            String[] dirs = newFileName.split("/");
            int index = -1;
            for (int i = 0; i < dirs.length; ++i) {
                if (!"src".equals(dirs[i]) || i + 1 >= dirs.length) continue;
                index = newFileName.indexOf(dirs[i + 1]);
            }
            if (index == -1 || (filePath = (subfixFilePath = newFileName.substring(index)).split("/")).length <= 2 || (cloud = cloudAppMap.get(cloudNumber = filePath[1])) == null || cloud.isEmpty() || (app = cloud.get(appNumber = filePath[2])) == null || (fileInfo = (TsFile)(fileMap = (appFileMap = cloudAppFileMap.computeIfAbsent(cloudNumber, k -> new HashMap())).computeIfAbsent(appNumber, k -> new HashMap())).get(subfixFilePath)) != null) continue;
            fileInfo = new TsFile(file);
            fileMap.put(subfixFilePath, fileInfo);
        }
        return cloudAppFileMap;
    }

    private void compareAndUploadScript(Map<String, Map<String, Map<String, TsFile>>> filtedFilesMap) {
        ScriptService scriptService = (ScriptService)ServiceFactory.getService((String)"ScriptService");
        for (Map<String, Map<String, TsFile>> singCloudMap : filtedFilesMap.values()) {
            for (Map.Entry<String, Map<String, TsFile>> entry : singCloudMap.entrySet()) {
                String appNumber = entry.getKey();
                Map<String, TsFile> fileInOneApp = entry.getValue();
                CustomApiResult<Map<String, String>> apiResult = scriptService.compareScripts(0, appNumber, new ArrayList<String>());
                if (apiResult.isStatus()) {
                    TsFile tsFile;
                    Map data = (Map)apiResult.getData();
                    for (Map.Entry<String, TsFile> singleFile : fileInOneApp.entrySet()) {
                        String fileName = singleFile.getKey();
                        tsFile = singleFile.getValue();
                        if (!data.containsKey(fileName)) {
                            tsFile.setType("add");
                            continue;
                        }
                        String content = tsFile.getContent();
                        if (!((String)data.get(fileName)).equals(content)) {
                            tsFile.setType("update");
                            continue;
                        }
                        tsFile.setType("unchange");
                    }
                    Set<String> allFileNamesInCurrentApp = fileInOneApp.keySet();
                    for (String tsFileName : data.keySet()) {
                        if (allFileNamesInCurrentApp.contains(tsFileName)) continue;
                        tsFile = new TsFile(tsFileName, "delete");
                        fileInOneApp.put(tsFileName, tsFile);
                    }
                    continue;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6%s\u5e94\u7528\u7684\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c\u4e0d\u80fd\u63d0\u4ea4\u8be5\u5e94\u7528\u7684\u6587\u4ef6\u3002", (String)"UploadKingScriptPlugin_1", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]), appNumber));
                singCloudMap.remove(appNumber);
            }
        }
    }

    private void renderTree(Map<String, Map<String, Map<String, TsFile>>> filtedFilesMap) {
        TreeNode rootNode = new TreeNode("", "rootNode", ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"UploadKingScriptPlugin_2", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]));
        String cloudNumberId = this.getPageCache().get("cloudnumberid");
        String appNumberId = this.getPageCache().get("appnumberid");
        Map cloudNumberIdMap = StringUtils.isNotBlank((CharSequence)cloudNumberId) ? (Map)SerializationUtils.fromJsonString((String)cloudNumberId, Map.class) : Collections.emptyMap();
        Map appNumberIdMap = StringUtils.isNotBlank((CharSequence)cloudNumberId) ? (Map)SerializationUtils.fromJsonString((String)appNumberId, Map.class) : Collections.emptyMap();
        for (Map.Entry<String, Map<String, Map<String, TsFile>>> singleCloud : filtedFilesMap.entrySet()) {
            String cloudNumber = singleCloud.getKey();
            String cloudId = (String)cloudNumberIdMap.get(cloudNumber);
            if (StringUtils.isBlank((CharSequence)cloudId)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u4e91id\u4e3a\u7a7a", (String)"UploadKingScriptPlugin_3", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]), cloudNumber));
                return;
            }
            TreeNode cloudNode = new TreeNode("rootNode", cloudId, cloudNumber, (Object)"cloud");
            rootNode.addChild(cloudNode);
            cloudNode.setIsOpened(true);
            cloudNode.setExpend(true);
            Map<String, Map<String, TsFile>> allAppInOneCloud = singleCloud.getValue();
            for (Map.Entry<String, Map<String, TsFile>> singleApp : allAppInOneCloud.entrySet()) {
                String appNumber = singleApp.getKey();
                String appId = (String)appNumberIdMap.get(appNumber);
                Map<String, TsFile> allTsFilesInOneApp = singleApp.getValue();
                if (StringUtils.isBlank((CharSequence)appId)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e94\u7528id\u4e3a\u7a7a", (String)"UploadKingScriptPlugin_4", (String)BOS_KINGSCRIPT_CONSOLE, (Object[])new Object[0]), appNumber));
                    return;
                }
                TreeNode appNode = new TreeNode(cloudNumber, appId, appNumber, (Object)"app");
                cloudNode.addChild(appNode);
                appNode.setExpend(true);
                appNode.setIsOpened(true);
                Set<String> allclasNameInOneApp = this.getAllDynDefiniteByAppId(appId);
                for (Map.Entry<String, TsFile> tsfile : allTsFilesInOneApp.entrySet()) {
                    String tsFileName = tsfile.getKey();
                    TsFile tsFileValue = tsfile.getValue();
                    String[] paths = tsFileName.split("/");
                    String parentId = appId;
                    for (int i = 3; i < paths.length; ++i) {
                        TreeNode node;
                        String content = paths[i];
                        if (content.endsWith(".ts")) {
                            node = new TreeNode(parentId, tsFileName, paths[paths.length - 1]);
                            String type = tsFileValue.getType();
                            if (allclasNameInOneApp.contains(tsFileName) && "delete".equals(type)) {
                                node.setDisabled(true);
                                node.setColor(this.getColorByType("binded"));
                            } else {
                                node.setColor(this.getColorByType(type));
                            }
                            node.setExpend(true);
                            node.setIsOpened(true);
                            node.setLeaf(true);
                            node.setType(type);
                            if ("unchange".equals(type)) continue;
                            node.setData((Object)tsFileValue.getRawContent());
                            rootNode.getTreeNode(parentId).addChild(node);
                        } else {
                            String id = content + i;
                            node = rootNode.getTreeNode(id);
                            if (node == null) {
                                node = new TreeNode(parentId, id, content);
                                node.setLeaf(false);
                                rootNode.getTreeNode(parentId).addChild(node);
                            }
                        }
                        parentId = content + i;
                    }
                }
            }
        }
        this.getPageCache().put("treenode", SerializationUtils.toJsonString((Object)rootNode));
        TreeViewUtil.convertTreeNodeTextWithNumber(rootNode, true);
        this.updateTreeView(rootNode);
    }

    private Set<String> getAllDynDefiniteByAppId(String appId) {
        Map result = BusinessDataReader.loadFromCache((String)"bos_dynplugin", (QFilter[])new QFilter[]{new QFilter("eventmethod", "=", (Object)"ALL"), new QFilter("bizapp", "=", (Object)appId)});
        HashSet<String> classNames = new HashSet<String>(10);
        for (DynamicObject dynamicObject : result.values()) {
            classNames.add(dynamicObject.getString("number"));
        }
        return classNames;
    }

    private void updateTreeView(TreeNode treeNode) {
        TreeView selectedTreeView = (TreeView)this.getView().getControl("treeviewap");
        selectedTreeView.deleteAllNodes();
        selectedTreeView.addNode(treeNode);
        selectedTreeView.setMulti(true);
        selectedTreeView.expand("rootNode");
        this.getView().updateView("treeviewap");
    }

    private TreeNode renderCacheTree() {
        String treeNodeStr = this.getPageCache().get("treenode");
        TreeNode treeNode = null;
        if (StringUtils.isNotBlank((CharSequence)treeNodeStr)) {
            treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeStr, TreeNode.class);
        }
        return treeNode;
    }

    private String getColorByType(String type) {
        String color = "#701df0";
        if (StringUtils.isBlank((CharSequence)type)) {
            return color;
        }
        switch (type) {
            case "add": {
                color = "#1BA854";
                break;
            }
            case "delete": {
                color = "#FF0000";
                break;
            }
            case "update": {
                color = "#FF8A00";
                break;
            }
            case "unchange": {
                color = "#999999";
                break;
            }
            default: {
                color = "#999999";
            }
        }
        return color;
    }

    private void enableUploadButton() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"btnok"});
    }

    private void disableUploadButton() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
    }
}

