/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode.download;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.kingscript.vscode.download.CompareResult;
import kd.bos.kingscript.vscode.download.DownloadUtil;
import kd.bos.kingscript.vscode.download.FileInfo;
import kd.bos.util.CollectionUtils;

public class DownloadTreeManager {
    private static void addNodeToParent(TreeNode parentNode, TreeNode childNode) {
        ArrayList<TreeNode> children = parentNode.getChildren();
        if (children == null) {
            children = new ArrayList<TreeNode>();
            parentNode.setChildren(children);
        }
        children.add(childNode);
    }

    public static void addFileNode(TreeNode appNode, List<FileInfo> files, String appNumber, String appId) {
        files.sort(Comparator.comparing(FileInfo::getScortCode));
        for (FileInfo file : files) {
            String filePath = file.getFilePath();
            TreeNode currentNode = appNode;
            String[] parts = filePath.substring(filePath.lastIndexOf(appNumber) + appNumber.length()).split("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                if (!StringUtils.isNotBlank((CharSequence)part)) continue;
                if (currentNode.getTreeNode(appId + "#" + part) != null) {
                    currentNode = currentNode.getTreeNode(appId + "#" + part);
                    continue;
                }
                TreeNode folderNode = new TreeNode(currentNode.getId(), appId + "#" + part, part);
                folderNode.setData((Object)"folder");
                DownloadTreeManager.addNodeToParent(currentNode, folderNode);
                currentNode = folderNode;
            }
            TreeNode fileNode = new TreeNode(currentNode.getId(), filePath, file.getFileName());
            fileNode.setColor(DownloadUtil.getColorByCompareRes(file.getCompareResult()));
            fileNode.setData((Object)file.getCompareResult());
            DownloadTreeManager.addNodeToParent(currentNode, fileNode);
        }
    }

    public static void removeUnmodifiedNode(TreeNode rootNode, Boolean onlyShowModified) {
        if (onlyShowModified.booleanValue()) {
            for (TreeNode cloudNode : rootNode.getChildren()) {
                Iterator appNodeIterator = cloudNode.getChildren().iterator();
                while (appNodeIterator.hasNext()) {
                    TreeNode appNode = (TreeNode)appNodeIterator.next();
                    List children = appNode.getChildren();
                    Iterator<TreeNode> fileNodeIterator = children.iterator();
                    DownloadTreeManager.removeFileNode(fileNodeIterator);
                    if (CollectionUtils.isEmpty((Collection)children)) {
                        appNodeIterator.remove();
                        continue;
                    }
                    appNode.setChildren(children);
                }
            }
        }
    }

    private static void removeFileNode(Iterator<TreeNode> fileNodeIterator) {
        while (fileNodeIterator.hasNext()) {
            TreeNode node = fileNodeIterator.next();
            Object data = node.getData();
            if (CompareResult.UNMODIFIED.equals(data) || "UNMODIFIED".equals(data)) {
                fileNodeIterator.remove();
                continue;
            }
            if (!"folder".equals(data)) continue;
            List children = node.getChildren();
            Iterator<TreeNode> iterator = children.iterator();
            DownloadTreeManager.removeFileNode(iterator);
            if (!CollectionUtils.isEmpty((Collection)children)) continue;
            fileNodeIterator.remove();
        }
    }
}

