/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kingscript.vscode.download;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.kingscript.vscode.download.AppAndFileData;
import kd.bos.kingscript.vscode.download.CompareResult;
import kd.bos.kingscript.vscode.download.FileInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DownloadUtil {
    public static List<String> getAppNumberById(List<String> appIds) {
        ArrayList<String> appNumbers = new ArrayList<String>();
        QFilter qFilter = new QFilter("id", "in", appIds);
        DynamicObject[] apps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"number", (QFilter[])new QFilter[]{qFilter});
        for (int i = 0; i < apps.length; ++i) {
            DynamicObject app = apps[i];
            if (app.getString("number") == null) continue;
            appNumbers.add(app.getString("number"));
        }
        return appNumbers;
    }

    public static String getColorByCompareRes(CompareResult compareResult) {
        String color = "#999999";
        switch (compareResult) {
            case ADD: {
                return "#1BA854";
            }
            case MODIFIED: {
                return "#FF991C";
            }
            case UNMODIFIED: {
                return "#999999";
            }
        }
        return color;
    }

    public static String extractFileName(String filePath) {
        int index = filePath.lastIndexOf("/");
        if (index != -1) {
            return filePath.substring(index + 1);
        }
        return filePath;
    }

    public static List<String> getFilePathByAppId(String appId, Map<String, AppAndFileData> idEntityIndex) {
        AppAndFileData appAndFileData = idEntityIndex.get(appId);
        List<FileInfo> files = appAndFileData.getFiles();
        ArrayList<String> filePaths = new ArrayList<String>(files.size());
        for (FileInfo file : files) {
            String filePath = file.getFilePath();
            filePaths.add(filePath);
        }
        return filePaths;
    }

    public static Map<String, AppAndFileData> buildIdEntityIndex(List<AppAndFileData> appAndFileDataList) {
        HashMap<String, AppAndFileData> result = new HashMap<String, AppAndFileData>(appAndFileDataList.size());
        for (AppAndFileData appAndFileData : appAndFileDataList) {
            String id = appAndFileData.getId();
            result.put(id, appAndFileData);
        }
        return result;
    }

    public static Map<String, String> getAppNumberIdIndex(String[] appNumbers) {
        QFilter qFilter = new QFilter("number", "in", (Object)appNumbers);
        DynamicObject[] apps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> numberIdIndex = new HashMap<String, String>(apps.length);
        for (DynamicObject app : apps) {
            String id = app.getString("id");
            String number = app.getString("number");
            numberIdIndex.put(number, id);
        }
        return numberIdIndex;
    }

    public static String convertParentId(String parentid) {
        int index = parentid.lastIndexOf("#");
        if (index != -1) {
            parentid = parentid.substring(0, index);
        }
        return parentid;
    }

    public static List<AppAndFileData> convertTreeData(List<Map<String, Object>> treeData) {
        String number;
        int i = 0;
        ArrayList<AppAndFileData> result = new ArrayList<AppAndFileData>(treeData.size());
        String[] appNumbers = new String[treeData.size()];
        for (Map<String, Object> item : treeData) {
            AppAndFileData appAndFileData = new AppAndFileData();
            number = (String)item.get("number");
            appNumbers[i++] = number;
            appAndFileData.setNumber(number);
            appAndFileData.setName((String)item.get("name"));
            appAndFileData.setCloudnumber((String)item.get("cloudnumber"));
            List files = (List)item.get("files");
            ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>(files.size());
            for (Map file : files) {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName((String)file.get("fileName"));
                fileInfo.setFilePath((String)file.get("filePath"));
                fileInfo.setContent((String)file.get("content"));
                fileInfo.setRawContent((String)file.get("rawContent"));
                fileInfoList.add(fileInfo);
            }
            appAndFileData.setFiles(fileInfoList);
            result.add(appAndFileData);
        }
        Map<String, String> numberIdIndex = DownloadUtil.getAppNumberIdIndex(appNumbers);
        for (AppAndFileData appAndFileData : result) {
            number = appAndFileData.getNumber();
            appAndFileData.setId(numberIdIndex.get(number));
        }
        return result;
    }
}

